/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.misc.HexDumpEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Debug {
    static final String TYPE_CONSOLE = "console";
    static final String TYPE_SIMPLE_FILE = "simple_file";
    static final String HANDLER_TYPE = "debug.output";
    static final String HANDLER_FILE = "debug.output.file";
    public static final String XMLENC = "xmlenc";
    public static final String ALL = "all";
    public static final String CONSOLE = "console";
    public static final String NONE = "none";
    static final String DEBUG = "debug";
    private static List args = new ArrayList();
    private static Debug debug;
    private Logger logger = Logger.getLogger("xmlencryption");
    private Handler handler = new ConsoleHandler();
    private boolean inited;
    private static boolean runtimeSet;
    private static HashMap hmap;

    protected Debug() {
        this.handler.setLevel(Level.ALL);
        this.logger.addHandler(this.handler);
        this.logger.setLevel(Level.ALL);
    }

    public static Debug getInstance(String option) {
        if (Debug.isOn(option)) {
            Debug result = (Debug)hmap.get(option);
            if (result == null) {
                result = new Debug();
                hmap.put(option, result);
                System.out.println("IBMXMLEncProvider Build-Level: -" + Debug.getDebugDate("com.ibm.xml.enc.dom.Debug"));
            }
            return result;
        }
        return null;
    }

    public void init(Properties config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOn(String option) {
        option = option.toLowerCase();
        List list = args;
        synchronized (list) {
            if (args == null) {
                return false;
            }
            if (option.equals(NONE)) {
                return false;
            }
            if (args.contains(option)) {
                return true;
            }
            if (args.contains(ALL)) {
                return true;
            }
            if (args.equals("console")) {
                return true;
            }
            if (args.contains(NONE)) {
                return false;
            }
            return false;
        }
    }

    public void trace(String className, String methodName, String message) {
        this.logger.logp(Level.ALL, className, methodName, message);
    }

    public void trace(String className, String methodName, String message, Object[] params) {
        this.logger.logp(Level.ALL, className, methodName, message, params);
    }

    public void trace(String className, String methodName, byte[] data) {
        HexDumpEncoder encoder = new HexDumpEncoder();
        String datamsg = encoder.encode(data);
        this.logger.logp(Level.ALL, className, methodName, datamsg);
    }

    public void trace(String className, String methodName, Throwable throwable) {
        this.logger.logp(Level.ALL, className, methodName, "", throwable);
    }

    public void trace(String className, String methodName, String message, Throwable throwable) {
        this.logger.logp(Level.ALL, className, methodName, message, throwable);
    }

    public void entry(String className, String methodName) {
        this.logger.entering(className, methodName);
    }

    public void entry(String className, String methodName, Object[] params) {
        this.logger.entering(className, methodName, params);
    }

    public void exit(String className, String methodName) {
        this.logger.exiting(className, methodName);
    }

    public void exit(String className, String methodName, byte retValue) {
        this.logger.exiting(className, methodName, new Byte(retValue));
    }

    public void exit(String className, String methodName, short retValue) {
        this.logger.exiting(className, methodName, new Short(retValue));
    }

    public void exit(String className, String methodName, int retValue) {
        this.logger.exiting(className, methodName, new Integer(retValue));
    }

    public void exit(String className, String methodName, long retValue) {
        this.logger.exiting(className, methodName, new Long(retValue));
    }

    public void exit(String className, String methodName, boolean retValue) {
        this.logger.exiting(className, methodName, new Boolean(retValue));
    }

    public void exit(String className, String methodName, Object retValue) {
        this.logger.exiting(className, methodName, retValue);
    }

    public static void Help() {
        System.err.println();
        System.err.println("all       turn on all debugging");
        System.err.println("admin     turn on debugging on administrative functions and CLI");
        System.err.println("audit     turn on debugging on auditing functions");
        System.err.println("config    configuration provider");
        System.err.println("drivetable drive table provider");
        System.err.println("keystore turn on debugging on key store");
        System.err.println("logic     decision logic provider");
        System.err.println("server    key manager server main program");
        System.err.println("transport transport provider");
        System.err.println("console  message displayed on console for the end users");
        System.exit(0);
    }

    public void refresh(Properties config) {
    }

    public void shutdown() {
        this.handler.flush();
        try {
            this.handler.close();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.logger.removeHandler(this.handler);
        this.logger = null;
        this.handler = null;
        this.inited = false;
        debug = null;
    }

    private static String getDebugDate(String className) {
        String versionDate = "Unknown";
        try {
            Class<?> thisClass = Class.forName(className);
            Package thisPackage = thisClass.getPackage();
            String versionInfo = thisPackage.getImplementationVersion();
            int index = versionInfo.indexOf("_");
            versionDate = versionInfo.substring(index + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return versionDate;
    }

    static {
        hmap = new HashMap(1);
        String argsString = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.security.debug");
            }
        });
        if (argsString != null) {
            if ((argsString = argsString.toLowerCase()).equals("help")) {
                Debug.Help();
            } else {
                String delim = ",";
                if (argsString.indexOf(";") > 0) {
                    delim = ";";
                }
                StringTokenizer st = new StringTokenizer(argsString, delim);
                while (st.hasMoreTokens()) {
                    String temp = st.nextToken().trim();
                    args.add(temp);
                }
            }
            runtimeSet = true;
        }
        if (!args.contains("console")) {
            args.add("console");
        }
    }
}

