/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMEncryptionMethod;
import com.ibm.xml.enc.dom.Debug;
import com.ibm.xml.enc.dom.Utils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;
import org.w3c.dom.Element;

public final class DOMTripleDESCBC
extends DOMEncryptionMethod {
    private static Debug debug = Debug.getInstance("xmlenc");
    private Cipher cipher;
    private boolean padding = false;
    private SecureRandom random = null;

    public DOMTripleDESCBC(Integer keySize, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", keySize, params);
    }

    public DOMTripleDESCBC(Element smElem) throws MarshalException {
        super(smElem);
    }

    @Override
    protected void checkParams(Integer keySize, EncryptionMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for TripleDES cipher algorithm");
        }
    }

    @Override
    protected EncryptionMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        throw new MarshalException("no parameters should be specified for TripleDES cipher algorithm");
    }

    @Override
    protected void marshalParams(Element parent, String dsPrefix) throws MarshalException {
        throw new MarshalException("no parameters should be specified for TripleDES cipher algorithm");
    }

    @Override
    protected boolean paramsEqual(AlgorithmParameterSpec spec) {
        return this.getParameterSpec() == spec;
    }

    @Override
    public byte[] decrypt(Key key, byte[] data) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (key == null || data == null) {
            throw new NullPointerException("key or cipher cannot be null");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("key must be SecretKey");
        }
        if (this.cipher == null) {
            this.cipher = this.getCipher("decrypt");
        }
        byte[] iv = new byte[this.cipher.getBlockSize()];
        System.arraycopy(data, 0, iv, 0, iv.length);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        try {
            this.cipher.init(2, key, ivSpec);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new IllegalBlockSizeException(ex.getMessage());
        }
        byte[] decrypted = this.cipher.doFinal(data, iv.length, data.length - iv.length);
        return decrypted;
    }

    @Override
    public Key decryptKey(Key key, byte[] encrypted, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException {
        byte[] decryptedData = this.decrypt(key, encrypted);
        String algoName = Utils.mapAlgorithm(algo.getAlgorithm());
        return this.genKey(decryptedData, algoName);
    }

    @Override
    public byte[] encrypt(Key key, byte[] data, EncryptedType type) throws InvalidKeyException {
        if (key == null || data == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("key must be SecretKey");
        }
        if (this.cipher == null) {
            this.cipher = this.getCipher("encrypt");
        }
        this.cipher.init(1, key);
        try {
            byte[] encrypted = null;
            encrypted = this.cipher.doFinal(data);
            byte[] iv = this.cipher.getIV();
            byte[] finalBytes = new byte[encrypted.length + iv.length];
            System.arraycopy(iv, 0, finalBytes, 0, iv.length);
            System.arraycopy(encrypted, 0, finalBytes, iv.length, encrypted.length);
            return finalBytes;
        }
        catch (Exception ex) {
            throw (InvalidKeyException)new InvalidKeyException(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    public byte[] wrap(Key key, Key toBeWrapped) throws InvalidKeyException, IllegalBlockSizeException {
        throw new UnsupportedOperationException("Wrap is not supported");
    }

    @Override
    public byte[] unwrap(Key key, byte[] encrypted) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        throw new UnsupportedOperationException("Unwrap is not supported");
    }

    @Override
    public Key unwrap(Key key, byte[] encrypted, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        throw new UnsupportedOperationException("Unwrap is not supported");
    }

    public Cipher getCipher(String callingMethodName) throws InvalidKeyException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("TripleDES/CBC/ISO10126Padding");
        }
        catch (Exception ex) {
            try {
                cipher = Cipher.getInstance("TripleDES/CBC/PKCS5Padding");
            }
            catch (Exception ex2) {
                if (debug != null) {
                    debug.trace("xmlenc", "DOMTripleDESCBC", callingMethodName, ex2);
                }
                throw (InvalidKeyException)new InvalidKeyException(ex2.getMessage()).initCause(ex2);
            }
        }
        return cipher;
    }
}

