/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.xml.enc.dom.DOMEncryptionMethod;
import com.ibm.xml.enc.dom.DOMUtils;
import com.ibm.xml.enc.dom.Debug;
import com.ibm.xml.enc.dom.Utils;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;
import javax.xml.crypto.enc.spec.RSAOAEPParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMRSAOAEP
extends DOMEncryptionMethod {
    private static Debug debug = Debug.getInstance("xmlenc");
    private Cipher cipher;
    private AlgorithmParameters aps;
    private SecureRandom random = null;
    private RSAOAEPParameterSpec rsaSpec = null;
    private XMLSignatureFactory fac = null;

    public DOMRSAOAEP(Integer keySize, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec parms = params;
        if (parms == null) {
            try {
                if (this.fac == null) {
                    this.fac = XMLSignatureFactory.getInstance("DOM");
                }
                parms = new RSAOAEPParameterSpec(this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
            }
            catch (Exception ex) {
                throw (InvalidAlgorithmParameterException)new InvalidAlgorithmParameterException(ex.getMessage()).initCause(ex);
            }
        }
        super.init("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", keySize, params);
    }

    public DOMRSAOAEP(Element smElem) throws MarshalException {
        super(smElem);
    }

    public String getAlgorithmConstant() {
        return "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    }

    @Override
    protected void checkParams(Integer keySize, EncryptionMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            RSAOAEPParameterSpec spec;
            if (!(params instanceof RSAOAEPParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported EncryptionMethodParameterSpec " + params.getClass());
            }
            this.rsaSpec = spec = (RSAOAEPParameterSpec)params;
            String dm = spec.getDigestMethod().getAlgorithm();
            String cp = null;
            try {
                this.aps = AlgorithmParameters.getInstance("OAEP");
            }
            catch (Exception ex) {
                throw (InvalidAlgorithmParameterException)new InvalidAlgorithmParameterException(ex.getMessage()).initCause(ex);
            }
            String oaepSpecCp = null;
            if (dm.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
                cp = "RSA/ /OAEPPADDINGSHA-1";
                oaepSpecCp = "SHA-1";
            } else if (dm.equals("http://www.w3.org/2001/04/xmlenc#sha256")) {
                cp = "RSA/ /OAEPPADDINGSHA-256";
                oaepSpecCp = "SHA-256";
            } else if (dm.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
                cp = "RSA/ /OAEPPADDINGSHA-512";
                oaepSpecCp = "SHA-512";
            } else {
                throw new InvalidAlgorithmParameterException("unsupported cipher " + cp);
            }
            byte[] oaepParams = spec.getOAEPParams();
            try {
                if (oaepParams != null) {
                    if (debug != null) {
                        debug.trace("DOMRSAOAEP", "checkParams", oaepParams);
                    }
                    byte[] encodedParams = this.encodeParams(oaepSpecCp, oaepParams);
                    this.aps.init(encodedParams);
                } else {
                    if (debug != null) {
                        debug.trace("DOMRSAOAEP", "checkParams", "no parameters");
                    }
                    oaepParams = new byte[]{};
                    byte[] encodedParams = this.encodeParams(oaepSpecCp, oaepParams);
                    this.aps.init(encodedParams);
                }
                this.cipher = Cipher.getInstance(cp);
            }
            catch (Exception ex) {
                throw (InvalidAlgorithmParameterException)new InvalidAlgorithmParameterException(ex.getMessage()).initCause(ex);
            }
        }
    }

    private byte[] encodeParams(String oaepSpecCp, byte[] oaepParams) throws IOException, NoSuchAlgorithmException {
        DerValue[] derList = new DerValue[3];
        AlgorithmId aid = AlgorithmId.get((String)oaepSpecCp);
        byte[] aidData = aid.encode();
        derList[0] = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), aidData);
        ObjectIdentifier MGF1 = new ObjectIdentifier("1.2.840.113549.1.1.8");
        AlgorithmId aid2 = AlgorithmId.get((String)"SHA-1");
        AlgorithmId mgfSha1 = new AlgorithmId(MGF1, aid2.encode());
        derList[1] = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), mgfSha1.encode());
        ObjectIdentifier pSec = new ObjectIdentifier("1.2.840.113549.1.1.9");
        DerOutputStream dos = new DerOutputStream();
        dos.putOctetString(oaepParams);
        AlgorithmId psource = new AlgorithmId(pSec, dos.toByteArray());
        derList[2] = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), psource.encode());
        DerOutputStream dos2 = new DerOutputStream();
        dos2.putSequence(derList);
        return dos2.toByteArray();
    }

    @Override
    protected EncryptionMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        Element nextElem;
        String name = paramsElem.getLocalName();
        byte[] oaepParams = null;
        if (name == null) {
            throw new MarshalException("Document implement must be namespace aware");
        }
        if (name.equals("OAEPparams")) {
            this.checkNamespace(paramsElem, "http://www.w3.org/2001/04/xmlenc#");
            Node child = paramsElem.getFirstChild();
            if (child.getNodeType() == 3) {
                try {
                    oaepParams = Utils.base64Decode(child.getNodeValue());
                }
                catch (IOException ex) {
                    throw new MarshalException(ex);
                }
            } else {
                throw new MarshalException("Malformed element");
            }
            if (child.getNextSibling() != null) {
                throw new MarshalException("Malformed element");
            }
        }
        if ((nextElem = DOMUtils.getNextSiblingElement(paramsElem)) != null) {
            name = nextElem.getLocalName();
            if (name.equals("DigestMethod")) {
                String alg;
                this.checkNamespace(nextElem, "http://www.w3.org/2000/09/xmldsig#");
                if (debug != null) {
                    debug.trace("DOMRSAOAEP", "unmarshalParams", "Found digestMethod node");
                }
                if ((alg = nextElem.getAttribute("Algorithm")) == null) {
                    throw new MarshalException("DigestMethod element does not have Algorithm attribute");
                }
                if (alg.equals("http://www.w3.org/2000/09/xmldsig#sha1") || alg.equals("http://www.w3.org/2001/04/xmlenc#sha256") || alg.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
                    if (DOMUtils.getFirstChildElement(nextElem) != null) {
                        throw new MarshalException("Can't process the child element of DigestMethod");
                    }
                    try {
                        if (this.fac == null) {
                            this.fac = XMLSignatureFactory.getInstance("DOM");
                        }
                        return new RSAOAEPParameterSpec(this.fac.newDigestMethod(alg, null), oaepParams);
                    }
                    catch (Exception ex) {
                        throw new MarshalException(ex);
                    }
                }
                throw new MarshalException("Unsupported DigestMethod algorithm");
            }
            throw new MarshalException("Malformed element");
        }
        if (debug != null) {
            debug.trace("DOMRSAOAEP", "unmarshalParams", "localname=" + paramsElem.getLocalName());
        }
        return null;
    }

    private void checkNamespace(Element child, String ns) throws MarshalException {
        String nsuri = child.getNamespaceURI();
        if (nsuri != null && !ns.equals(nsuri)) {
            throw new MarshalException("Unexpected element: " + child.getNodeName());
        }
    }

    @Override
    protected void marshalParams(Element parent, String prefix) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        if (this.rsaSpec != null) {
            DigestMethod dm;
            byte[] oaepParams = this.rsaSpec.getOAEPParams();
            if (oaepParams != null) {
                Element elem = DOMUtils.createElement(ownerDoc, "OAEPparams", "http://www.w3.org/2001/04/xmlenc#", prefix);
                String paramsSt = Utils.base64Encode(oaepParams);
                elem.appendChild(ownerDoc.createTextNode(paramsSt));
                parent.appendChild(elem);
            }
            if ((dm = this.rsaSpec.getDigestMethod()) != null) {
                Element elem = DOMUtils.createElement(ownerDoc, "DigestMethod", "http://www.w3.org/2000/09/xmldsig#", "ds");
                elem.setAttributeNS(null, "Algorithm", dm.getAlgorithm());
                AlgorithmParameterSpec dm_spec = dm.getParameterSpec();
                if (dm_spec != null) {
                    if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(dm.getAlgorithm())) {
                        Document fac = elem.getOwnerDocument();
                        int len = ((HMACParameterSpec)dm_spec).getOutputLength();
                        Element child = DOMUtils.createElement(fac, "HMACOutputLength", "http://www.w3.org/2000/09/xmldsig#", "ds");
                        child.appendChild(fac.createTextNode(Integer.toString(len)));
                        elem.appendChild(child);
                    } else {
                        throw new MarshalException("unsupported algorithm with parameterSpec");
                    }
                }
                parent.appendChild(elem);
            }
        }
    }

    @Override
    protected boolean paramsEqual(AlgorithmParameterSpec spec) {
        return this.getParameterSpec() == spec;
    }

    @Override
    public byte[] decrypt(Key key, byte[] data) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (debug != null) {
            debug.entry("DOMRSAOAEP", "decrypt");
        }
        if (key == null || data == null) {
            throw new NullPointerException("key or cipher data cannot be null");
        }
        if (!(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("key must be a RSAPrivateKey");
        }
        Integer keysizeInt = this.getKeySize();
        if (keysizeInt != null) {
            Utils.checkKeySize(keysizeInt, (RSAKey)((Object)key));
        }
        if (this.cipher == null) {
            try {
                RSAOAEPParameterSpec spec = (RSAOAEPParameterSpec)super.getParameterSpec();
                if (spec != null) {
                    this.checkParams(null, (EncryptionMethodParameterSpec)spec);
                } else {
                    this.cipher = Cipher.getInstance("RSA/ /OAEPPADDINGSHA-1");
                    this.aps = AlgorithmParameters.getInstance("OAEP");
                    byte[] initData = new byte[]{};
                    byte[] paramsData = this.encodeParams("SHA-1", initData);
                    this.aps.init(paramsData);
                }
            }
            catch (Exception ex) {
                throw (InvalidKeyException)new InvalidKeyException(ex.getMessage()).initCause(ex);
            }
        }
        byte[] decrypted = null;
        try {
            this.cipher.init(2, key, this.aps);
            decrypted = this.cipher.doFinal(data);
        }
        catch (Exception ex) {
            throw (InvalidKeyException)new InvalidKeyException(ex.getMessage()).initCause(ex);
        }
        if (debug != null) {
            debug.trace("DOMRSAOAEP", "decrypt", "decrypted data: " + Utils.base64EncodeNoWhite(decrypted));
        }
        return decrypted;
    }

    @Override
    public Key decryptKey(Key key, byte[] encrypted, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry("DOMRSAOAEP", "decryptKey");
        }
        if (key == null || encrypted == null) {
            throw new NullPointerException("key and cipher data can not be null");
        }
        Integer keysizeInt = this.getKeySize();
        if (keysizeInt != null) {
            Utils.checkKeySize(keysizeInt, (RSAKey)((Object)key));
        }
        if (this.cipher == null) {
            try {
                RSAOAEPParameterSpec spec = (RSAOAEPParameterSpec)super.getParameterSpec();
                if (spec != null) {
                    this.checkParams(null, (EncryptionMethodParameterSpec)spec);
                } else {
                    this.cipher = Cipher.getInstance("RSA/ /OAEPPADDINGSHA-1");
                    this.aps = AlgorithmParameters.getInstance("OAEP");
                    byte[] initData = new byte[]{};
                    byte[] paramsData = this.encodeParams("SHA-1", initData);
                    this.aps.init(paramsData);
                }
            }
            catch (Exception ex) {
                throw (InvalidKeyException)new InvalidKeyException(ex.getMessage()).initCause(ex);
            }
        }
        this.cipher.init(4, key, this.aps);
        String alg = Utils.mapAlgorithm(algo.getAlgorithm());
        if (!alg.equals("RSA")) {
            return this.cipher.unwrap(encrypted, alg, 3);
        }
        try {
            Key result = this.cipher.unwrap(encrypted, alg, 2);
            if (result == null) {
                return this.cipher.unwrap(encrypted, alg, 1);
            }
            return result;
        }
        catch (Exception ex) {
            try {
                return this.cipher.unwrap(encrypted, alg, 1);
            }
            catch (Exception ex2) {
                throw (InvalidKeyException)new InvalidKeyException(ex2.getMessage()).initCause(ex2);
            }
        }
    }

    @Override
    public byte[] encrypt(Key key, byte[] data, EncryptedType type) throws InvalidKeyException {
        if (debug != null) {
            debug.entry("DOMRSAOAEP", "encrypt");
        }
        if (key == null || data == null) {
            throw new NullPointerException();
        }
        Integer keysizeInt = this.getKeySize();
        if (!(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("key must be a RSAPublicKey");
        }
        if (keysizeInt != null) {
            Utils.checkKeySize(keysizeInt, (RSAKey)((Object)key));
        }
        if (debug != null) {
            debug.trace("DOMRSAOAEP", "encrypt", "encrypting data: " + Utils.base64EncodeNoWhite(data));
        }
        if (this.cipher == null) {
            try {
                RSAOAEPParameterSpec spec = (RSAOAEPParameterSpec)super.getParameterSpec();
                if (spec != null) {
                    this.checkParams(null, (EncryptionMethodParameterSpec)spec);
                } else {
                    this.cipher = Cipher.getInstance("RSA/ /OAEPPADDINGSHA-1");
                    this.aps = AlgorithmParameters.getInstance("OAEP");
                    byte[] initData = new byte[]{};
                    byte[] paramsData = this.encodeParams("SHA-1", initData);
                    this.aps.init(paramsData);
                }
            }
            catch (Exception ex) {
                throw (InvalidKeyException)new InvalidKeyException(ex.getMessage()).initCause(ex);
            }
        }
        try {
            this.cipher.init(1, key, this.aps);
            byte[] encrypted = null;
            encrypted = this.cipher.doFinal(data);
            byte[] iv = this.cipher.getIV();
            return encrypted;
        }
        catch (Exception ise) {
            throw (InvalidKeyException)new InvalidKeyException(ise.getMessage()).initCause(ise);
        }
    }

    @Override
    public byte[] wrap(Key key, Key toBeWrapped) throws InvalidKeyException, IllegalBlockSizeException {
        throw new UnsupportedOperationException("Wrap is not supported");
    }

    @Override
    public byte[] unwrap(Key key, byte[] encrypted) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        throw new UnsupportedOperationException("Unwrap is not supported");
    }

    @Override
    public Key unwrap(Key key, byte[] encrypted, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        throw new UnsupportedOperationException("Unwrap is not supported");
    }
}

