/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMKeyName;
import com.ibm.xml.enc.dom.DOMKeyValue;
import com.ibm.xml.enc.dom.DOMPGPData;
import com.ibm.xml.enc.dom.DOMRetrievalMethod;
import com.ibm.xml.enc.dom.DOMStructure;
import com.ibm.xml.enc.dom.DOMUtils;
import com.ibm.xml.enc.dom.DOMX509Data;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMKeyInfo
extends DOMStructure
implements KeyInfo {
    private final String id;
    private final List keyInfoTypes;

    public DOMKeyInfo(List content, String id) {
        if (content == null) {
            throw new NullPointerException("content cannot be null");
        }
        if (content.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        ArrayList keyInfoTypes = new ArrayList();
        for (int i = 0; i < content.size(); ++i) {
            Object obj = content.get(i);
            if (!(obj instanceof XMLStructure)) {
                throw new ClassCastException("content[" + i + "] is not a valid KeyInfo type");
            }
            if (obj instanceof KeyName) {
                if (!(obj instanceof DOMKeyName)) {
                    obj = new DOMKeyName(((KeyName)obj).getName());
                }
                keyInfoTypes.add(obj);
                continue;
            }
            if (obj instanceof KeyValue) {
                if (!(obj instanceof DOMKeyValue)) {
                    try {
                        obj = new DOMKeyValue(((KeyValue)obj).getPublicKey());
                    }
                    catch (KeyException ex) {
                        obj = null;
                    }
                }
                if (obj == null) continue;
                keyInfoTypes.add(obj);
                continue;
            }
            if (obj instanceof RetrievalMethod) {
                if (!(obj instanceof DOMRetrievalMethod)) {
                    obj = new DOMRetrievalMethod(((RetrievalMethod)obj).getURI(), ((RetrievalMethod)obj).getType(), ((RetrievalMethod)obj).getTransforms());
                }
                keyInfoTypes.add(obj);
                continue;
            }
            if (obj instanceof X509Data) {
                if (!(obj instanceof DOMX509Data)) {
                    obj = new DOMX509Data(((X509Data)obj).getContent());
                }
                keyInfoTypes.add(obj);
                continue;
            }
            if (obj instanceof PGPData) {
                if (!(obj instanceof DOMPGPData)) {
                    obj = new DOMPGPData(((PGPData)obj).getKeyPacket(), ((PGPData)obj).getExternalElements());
                }
                keyInfoTypes.add(obj);
                continue;
            }
            if (obj instanceof javax.xml.crypto.dom.DOMStructure) {
                keyInfoTypes.add(obj);
                continue;
            }
            throw new ClassCastException("content has unsupported entry type");
        }
        this.keyInfoTypes = Collections.unmodifiableList(keyInfoTypes);
        this.id = id;
    }

    public DOMKeyInfo(Element kiElem, XMLCryptoContext context) throws MarshalException {
        this.id = DOMUtils.getAttributeValue(kiElem, "Id");
        NodeList nl = kiElem.getChildNodes();
        if (nl.getLength() < 1) {
            throw new MarshalException("KeyInfo must contain at least one type");
        }
        ArrayList<XMLStructure> content = new ArrayList<XMLStructure>(nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            Element childElem = (Element)child;
            String temp = childElem.getLocalName();
            if (temp.equals("KeyName")) {
                content.add(new DOMKeyName(childElem));
                continue;
            }
            if (temp.equals("KeyValue")) {
                content.add(new DOMKeyValue(childElem));
                continue;
            }
            if (temp.equals("RetrievalMethod")) {
                content.add(new DOMRetrievalMethod(childElem, context));
                continue;
            }
            if (temp.equals("X509Data")) {
                content.add(new DOMX509Data(childElem));
                continue;
            }
            content.add(new javax.xml.crypto.dom.DOMStructure(childElem));
        }
        this.keyInfoTypes = Collections.unmodifiableList(content);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List getContent() {
        return this.keyInfoTypes;
    }

    @Override
    public void marshal(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        DOMStructure dp = (DOMStructure)parent;
        this.marshal(((javax.xml.crypto.dom.DOMStructure)parent).getNode(), DOMUtils.getSignaturePrefix(context), (DOMCryptoContext)context);
    }

    @Override
    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        this.marshal(parent, null, dsPrefix, context);
    }

    public void marshal(Node parent, Node nextSibling, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element kiElem = DOMUtils.createElement(ownerDoc, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        for (XMLStructure kiType : this.keyInfoTypes) {
            if (kiType instanceof DOMStructure) {
                ((DOMStructure)kiType).marshal(kiElem, dsPrefix, context);
                continue;
            }
            DOMUtils.appendChild(kiElem, ((javax.xml.crypto.dom.DOMStructure)kiType).getNode());
        }
        DOMUtils.setAttributeID(kiElem, "Id", this.id);
        parent.insertBefore(kiElem, nextSibling);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyInfo)) {
            return false;
        }
        KeyInfo oki = (KeyInfo)o;
        boolean idsEqual = this.id == null ? oki.getId() == null : this.id.equals(oki.getId());
        return this.keyInfoTypes.equals(oki.getContent()) && idsEqual;
    }
}

