/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.X509Data;

class X509DataImpl
extends XMLStructureImpl
implements X509Data {
    List content;

    X509DataImpl(AlgorithmFactory f, List content) {
        super(f);
        if (content == null) {
            throw new NullPointerException("The content must not be null.");
        }
        if (content.size() == 0) {
            throw new IllegalArgumentException("The content is empty.");
        }
        this.content = new ArrayList(content.size());
        for (Object obj : content) {
            if (obj == null) {
                throw new NullPointerException("The content contains a null object.");
            }
            if (!(obj instanceof XMLStructure)) {
                if (obj instanceof String) {
                    X509DataImpl.encodeDName((String)obj);
                } else if (obj instanceof byte[]) {
                    byte[] n = new byte[((byte[])obj).length];
                    System.arraycopy(obj, 0, n, 0, n.length);
                    obj = n;
                } else if (!(obj instanceof X509Certificate) && !(obj instanceof X509CRL)) {
                    obj = (XMLStructure)obj;
                }
            }
            this.content.add(obj);
        }
    }

    public List getContent() {
        return Collections.unmodifiableList(this.content);
    }

    private static void encodeXS(StringBuffer buffer, StringBuffer attrv, boolean oid) {
        int space_pos = -1;
        int length = attrv.length();
        if (length < 1) {
            return;
        }
        if (!oid && attrv.charAt(0) == '#') {
            buffer.append('\\');
        }
        for (int i = 0; i < length; ++i) {
            char ch = attrv.charAt(i);
            if (",+\"\\<>;".indexOf(ch) >= 0) {
                buffer.append('\\');
                buffer.append(ch);
                continue;
            }
            if (ch <= '\u001f') {
                buffer.append('\\');
                buffer.append("0123456789abcdef".charAt(ch >> 4 & 0xF));
                buffer.append("0123456789abcdef".charAt(ch & 0xF));
                continue;
            }
            if (ch == ' ') {
                if (i == length - 1) {
                    buffer.append("\\20");
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            buffer.append(ch);
        }
    }

    private static int decodeAttributeType(StringBuffer buffer, String dname, int read) {
        int length = dname.length();
        while (read < length && dname.charAt(read) == ' ') {
            ++read;
        }
        if (read >= length) {
            return read;
        }
        int typestart = read;
        while (read < length && dname.charAt(read) != '=') {
            ++read;
        }
        if (read >= length) {
            return read;
        }
        buffer.append(dname.substring(typestart, read));
        buffer.append('=');
        return ++read;
    }

    private static int decodeAttributeValue(StringBuffer buffer, String dname, int read) throws IllegalArgumentException {
        int length = dname.length();
        if (read >= length) {
            return read;
        }
        if (dname.charAt(read) == '#') {
            // empty if block
        }
        boolean quote = false;
        if (dname.charAt(read) == '\"') {
            ++read;
            quote = true;
        }
        while (read < length) {
            char ch;
            if ((ch = dname.charAt(read++)) == '\\') {
                char ch2;
                if (read >= length) {
                    throw new IllegalArgumentException("Unexpected end.");
                }
                if ("0123456789abcdefABCDEF".indexOf(ch = dname.charAt(read++)) < 0) {
                    buffer.append(ch);
                    continue;
                }
                char decoded = (char)("0123456789abcdef".indexOf(Character.toLowerCase(ch)) << 4);
                if (read >= length) {
                    throw new IllegalArgumentException("Unexpected end.");
                }
                if ("0123456789abcdefABCDEF".indexOf(ch2 = dname.charAt(read++)) < 0) {
                    throw new IllegalArgumentException("Escape format error.");
                }
                decoded = (char)(decoded + "0123456789abcdef".indexOf(Character.toLowerCase(ch2)));
                buffer.append(decoded);
                continue;
            }
            if (quote && ch == '\"') break;
            if (!quote && ch == ',') {
                --read;
                break;
            }
            if (!quote && ch == '+') {
                --read;
                break;
            }
            buffer.append(ch);
        }
        return read;
    }

    public static String encodeDName(String dname) throws IllegalArgumentException {
        int length = dname.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        StringBuffer attr = new StringBuffer(length);
        int read = 0;
        while (read < length) {
            boolean oid;
            while (read < length && dname.charAt(read) == ' ') {
                ++read;
            }
            if (read >= length) break;
            int typestart = read;
            while (read < length && dname.charAt(read) != '=') {
                ++read;
            }
            if (read >= length) {
                throw new IllegalArgumentException("Invalid DName: no '=' after attributeType '" + dname.substring(typestart) + "'");
            }
            String type = dname.substring(typestart, read);
            buffer.append(type);
            buffer.append('=');
            if (++read >= length) {
                throw new IllegalArgumentException("Invalid DName: no value after `" + type + "='");
            }
            if (type.length() == 0) {
                throw new IllegalArgumentException("Invalid DName: 0-length attributeType");
            }
            char ch = type.charAt(0);
            if ('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z') {
                oid = false;
            } else if ('0' <= ch && ch <= '9') {
                oid = true;
            } else {
                throw new IllegalArgumentException("Invalid DName: invalid attributeType: '" + type + "'");
            }
            attr.setLength(0);
            read = X509DataImpl.decodeAttributeValue(attr, dname, read);
            X509DataImpl.encodeXS(buffer, attr, oid);
            if (read < length && dname.charAt(read) == ',') {
                buffer.append(',');
                ++read;
                continue;
            }
            if (read >= length || dname.charAt(read) != '+') continue;
            buffer.append('+');
            ++read;
        }
        return new String(buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof X509Data)) {
            return false;
        }
        X509Data oxd = (X509Data)o;
        List<?> ocontent = oxd.getContent();
        int size = this.content.size();
        if (size != ocontent.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Object x = this.content.get(i);
            Object ox = ocontent.get(i);
            if (!(x instanceof byte[] ? !(ox instanceof byte[]) || !Arrays.equals((byte[])x, (byte[])ox) : !x.equals(ox))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.content.hashCode();
        return result;
    }
}

