/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.util.Msg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import openj9.internal.tools.attach.target.IPC;

public final class Reply {
    private String key;
    private Integer portNumber;
    private final File replyFile;
    static final long ROOT_UID = 0L;
    static final int REPLY_PERMISSIONS = 384;
    static final String REPLY_FILENAME = "replyInfo";
    final long targetUid;

    public Reply(Integer thePort, String theKey, String targetDirectory, long theUid) {
        this.portNumber = thePort;
        this.key = theKey;
        this.targetUid = theUid;
        this.replyFile = new File(targetDirectory, REPLY_FILENAME);
    }

    Reply(String notificationDirectory) {
        this.targetUid = 0L;
        this.replyFile = new File(notificationDirectory, REPLY_FILENAME);
    }

    public void writeReply() throws IOException {
        String replyFileAbsolutePath = this.replyFile.getAbsolutePath();
        IPC.logMessage("writing reply file port=", this.portNumber, " file path=", replyFileAbsolutePath);
        IPC.createNewFileWithPermissions(this.replyFile, 384);
        try (RandomAccessFile replyChannelRAF = new RandomAccessFile(this.replyFile, "rw");){
            replyChannelRAF.writeBytes(this.key);
            replyChannelRAF.writeByte(10);
            replyChannelRAF.writeBytes(this.portNumber.toString());
            replyChannelRAF.writeByte(10);
            replyChannelRAF.close();
            long myUid = IPC.getUid();
            if (0L == myUid && 0L != this.targetUid) {
                IPC.chownFileToTargetUid(replyFileAbsolutePath, this.targetUid);
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException(Msg.getString("K0552", replyFileAbsolutePath), e);
        }
    }

    static Reply readReply(String path) throws IOException {
        Reply rply = new Reply(path);
        String replyFileAbsolutePath = rply.replyFile.getAbsolutePath();
        if (rply.fileDoesNotExist()) {
            return null;
        }
        IPC.checkOwnerAccessOnly(replyFileAbsolutePath);
        try (BufferedReader replyStream = new BufferedReader(new FileReader(rply.replyFile));){
            rply.key = replyStream.readLine();
            String line = replyStream.readLine();
            replyStream.close();
            try {
                rply.portNumber = Integer.valueOf(line);
            }
            catch (NumberFormatException e) {
                rply.portNumber = -1;
                throw new IOException(e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException(Msg.getString("K0548", replyFileAbsolutePath), e);
        }
        return rply;
    }

    private boolean fileDoesNotExist() {
        return !this.replyFile.exists();
    }

    synchronized int getPortNumber() {
        return this.portNumber;
    }

    synchronized String getKey() {
        return this.key;
    }

    public void deleteReply() {
        if (null != this.replyFile) {
            if (!this.replyFile.delete()) {
                IPC.logMessage("eraseReply could not delete ", this.replyFile.getName());
            } else {
                IPC.logMessage("eraseReply deleted ", this.replyFile.getName());
            }
        }
    }
}

