/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.util.List;
import openj9.tools.attach.diagnostics.tools.Util;

public class Jps {
    private static final String DESCRIPTION = "jps: Print a list of Java processes and information about them%n%n";
    private static final String HELP_TEXT = "Usage:%n    jps [-h] [-J<vm option>] [-l] [-q] [-m] [-v]%n    jps [-h] [-J<vm option>] [-q] [-lmv]%n%n    -h: print jps usage help%n    -J: supply arguments to the Java VM running jps%n    -l: print the application package name%n    -q: print only the virtual machine identifiers%n    -m: print the application arguments%n    -v: print the Java VM arguments, including those produced automatically%n";
    private static boolean printApplicationArguments;
    private static boolean printJvmArguments;
    private static boolean noPackageName;
    private static boolean vmidOnly;

    public static void main(String[] args) {
        int rc = 0;
        Jps.parseArguments(args);
        List<AttachProvider> providers = AttachProvider.providers();
        AttachProvider theProvider = null;
        if (0 != providers.size()) {
            theProvider = providers.get(0);
        }
        if (null == theProvider) {
            System.err.println("no attach providers available");
            rc = 1;
        } else {
            List<VirtualMachineDescriptor> vmds = theProvider.listVirtualMachines();
            for (VirtualMachineDescriptor vmd : vmds) {
                StringBuilder outputBuffer = new StringBuilder(vmd.id());
                if (!vmidOnly) {
                    Util.getTargetInformation(theProvider, vmd, printJvmArguments, noPackageName, printApplicationArguments, outputBuffer);
                }
                System.out.println(outputBuffer.toString());
            }
        }
        System.exit(rc);
    }

    private static void parseArguments(String[] args) {
        printApplicationArguments = false;
        printJvmArguments = false;
        noPackageName = true;
        vmidOnly = false;
        for (String arg : args) {
            if (Jps.isInvalidArgument(arg)) {
                System.out.printf("illegal argument: %s%n%n", arg);
                Jps.interruptWithHelpMessage();
            }
            arg = arg.substring(1);
            for (char singleArg : arg.toCharArray()) {
                Jps.processArgument(singleArg);
            }
        }
    }

    private static boolean isInvalidArgument(String arg) {
        return !arg.startsWith("-") || arg.length() == 1 || arg.contains("q") && arg.length() > 2;
    }

    private static void processArgument(char arg) {
        switch (arg) {
            case 'l': {
                noPackageName = false;
                break;
            }
            case 'm': {
                printApplicationArguments = true;
                break;
            }
            case 'q': {
                vmidOnly = true;
                break;
            }
            case 'v': {
                printJvmArguments = true;
                break;
            }
            case 'h': {
                System.out.printf(DESCRIPTION, new Object[0]);
                Jps.interruptWithHelpMessage();
                break;
            }
            default: {
                System.out.printf("illegal argument: -%c%n%n", Character.valueOf(arg));
                Jps.interruptWithHelpMessage();
            }
        }
    }

    private static void interruptWithHelpMessage() {
        System.out.printf(HELP_TEXT, new Object[0]);
        System.exit(1);
    }
}

