/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.PrimitiveHandle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class MethodHandleInfoImpl
implements MethodHandleInfo {
    private final PrimitiveHandle mh;

    MethodHandleInfoImpl(PrimitiveHandle primitiveHandle) {
        this.mh = primitiveHandle;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.mh.defc;
    }

    @Override
    public String getName() {
        return this.mh.name;
    }

    @Override
    public MethodType getMethodType() {
        if (this.requiresReceiver()) {
            return this.mh.type.dropParameterTypes(0, 1);
        }
        if (this.isConstructor()) {
            return this.mh.type.changeReturnType(Void.TYPE);
        }
        return this.mh.type;
    }

    @Override
    public int getModifiers() {
        if (this.isMethod() || this.isConstructor()) {
            return this.mh.rawModifiers & (Modifier.methodModifiers() | 0x80 | 0x40 | 0x1000);
        }
        if (this.isField()) {
            return this.mh.rawModifiers & (Modifier.fieldModifiers() | 0x1000);
        }
        return -1;
    }

    @Override
    public int getReferenceKind() {
        if (this.mh.directHandleOriginatedInFindVirtual() || 11 == this.mh.kind || 12 == this.mh.kind) {
            return 5;
        }
        return this.mh.kind;
    }

    @Override
    public <T extends Member> T reflectAs(Class<T> expected, MethodHandles.Lookup lookup) throws NullPointerException, IllegalArgumentException, ClassCastException {
        if (null == expected || null == lookup) {
            throw new NullPointerException();
        }
        try {
            lookup.checkAccess(this.mh, false);
        }
        catch (IllegalAccessException e) {
            IllegalArgumentException x = new IllegalArgumentException(Msg.getString("K0583"));
            x.initCause(e);
            throw x;
        }
        if (11 == this.mh.kind || 12 == this.mh.kind) {
            throw new IllegalArgumentException(Msg.getString("K0590", this));
        }
        Member member = null;
        final Class<?> defc = this.getDeclaringClass();
        final boolean isPublic = Modifier.isPublic(this.getModifiers());
        member = AccessController.doPrivileged(new PrivilegedAction<Member>(){

            @Override
            public Member run() {
                AccessibleObject result = null;
                try {
                    if (MethodHandleInfoImpl.this.isField()) {
                        result = isPublic ? defc.getField(MethodHandleInfoImpl.this.getName()) : defc.getDeclaredField(MethodHandleInfoImpl.this.getName());
                    } else if (MethodHandleInfoImpl.this.isMethod()) {
                        result = isPublic ? defc.getMethod(MethodHandleInfoImpl.this.getName(), MethodHandleInfoImpl.this.getMethodType().ptypes()) : defc.getDeclaredMethod(MethodHandleInfoImpl.this.getName(), MethodHandleInfoImpl.this.getMethodType().ptypes());
                    } else if (MethodHandleInfoImpl.this.isConstructor()) {
                        result = isPublic ? defc.getConstructor(MethodHandleInfoImpl.this.getMethodType().ptypes()) : defc.getDeclaredConstructor(MethodHandleInfoImpl.this.getMethodType().ptypes());
                    }
                }
                catch (NoSuchFieldException | NoSuchMethodException e) {
                    throw new IllegalArgumentException(e);
                }
                if (null == result) {
                    throw new InternalError("Unable to get the underlying Member due to invalid reference kind");
                }
                return result;
            }
        });
        expected.cast(member);
        return (T)member;
    }

    private boolean requiresReceiver() {
        int kind = this.getReferenceKind();
        return 1 == kind || 3 == kind || 9 == kind || 7 == kind || 5 == kind;
    }

    boolean isMethod() {
        return this.getReferenceKind() >= 5 && !this.isConstructor();
    }

    boolean isField() {
        return this.getReferenceKind() <= 4;
    }

    boolean isConstructor() {
        return this.getReferenceKind() == 8;
    }

    public String toString() {
        return MethodHandleInfo.toString(this.getReferenceKind(), this.getDeclaringClass(), this.getName(), this.getMethodType());
    }
}

