/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Cache;
import java.lang.invoke.CacheKey;
import java.lang.invoke.FieldCacheKey;
import java.lang.invoke.MethodCacheKey;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.util.Map;

final class HandleCache {
    private static final Cache findVirtualCache = new Cache();
    private static final Cache findStaticCache = new Cache();
    private static final Cache findSpecialCache = new Cache();
    private static final Cache findConstructorCache = new Cache();
    private static final Cache staticFieldSetterCache = new Cache();
    private static final Cache staticFieldGetterCache = new Cache();
    private static final Cache fieldSetterCache = new Cache();
    private static final Cache fieldGetterCache = new Cache();

    HandleCache() {
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getVirtualCache(Class<?> c) {
        return (Map)findVirtualCache.get(c);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getStaticCache(Class<?> c) {
        return (Map)findStaticCache.get(c);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getSpecialCache(Class<?> c) {
        return (Map)findSpecialCache.get(c);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getConstructorCache(Class<?> c) {
        return (Map)findConstructorCache.get(c);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getFieldSetterCache(Class<?> c) {
        return (Map)fieldSetterCache.get(c);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getFieldGetterCache(Class<?> c) {
        return (Map)fieldGetterCache.get(c);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getStaticFieldSetterCache(Class<?> c) {
        return (Map)staticFieldSetterCache.get(c);
    }

    static Map<CacheKey, WeakReference<MethodHandle>> getStaticFieldGetterCache(Class<?> c) {
        return (Map)staticFieldGetterCache.get(c);
    }

    public static MethodHandle getMethodFromPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> perClassCache, String name, MethodType type) {
        return HandleCache.getMethodWithSpecialCallerFromPerClassCache(perClassCache, name, type, null);
    }

    public static MethodHandle getMethodWithSpecialCallerFromPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> perClassCache, String name, MethodType type, Class<?> specialCaller) {
        WeakReference<MethodHandle> handleRef = perClassCache.get(new MethodCacheKey(name, type, specialCaller));
        if (handleRef != null) {
            return (MethodHandle)handleRef.get();
        }
        return null;
    }

    public static MethodHandle getFieldFromPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> perClassCache, String name, Class<?> fieldType) {
        WeakReference<MethodHandle> handleRef = perClassCache.get(new FieldCacheKey(name, fieldType));
        if (handleRef != null) {
            return (MethodHandle)handleRef.get();
        }
        return null;
    }

    public static MethodHandle putMethodInPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> perClassCache, String name, MethodType type, MethodHandle handle) {
        return HandleCache.putMethodWithSpecialCallerInPerClassCache(perClassCache, name, type, handle, null);
    }

    public static MethodHandle putMethodWithSpecialCallerInPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> perClassCache, String name, MethodType type, MethodHandle handle, Class<?> specialCaller) {
        return HandleCache.cacheHandle(perClassCache, new MethodCacheKey(name, type, specialCaller), handle);
    }

    public static MethodHandle putFieldInPerClassCache(Map<CacheKey, WeakReference<MethodHandle>> perClassCache, String fieldName, Class<?> fieldType, MethodHandle handle) {
        return HandleCache.cacheHandle(perClassCache, new FieldCacheKey(fieldName, fieldType), handle);
    }

    private static MethodHandle cacheHandle(Map<CacheKey, WeakReference<MethodHandle>> perClassCache, CacheKey cacheKey, MethodHandle handle) {
        handle.cacheKey = cacheKey;
        perClassCache.put(handle.cacheKey, new WeakReference<MethodHandle>(handle));
        return handle;
    }
}

