/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CacheKey;

final class FieldCacheKey
extends CacheKey {
    private final Class<?> fieldType;

    public FieldCacheKey(String fieldName, Class<?> fieldType) {
        super(fieldName, FieldCacheKey.calculateHashcode(fieldName, fieldType));
        this.fieldType = fieldType;
    }

    private static int calculateHashcode(String fieldName, Class<?> fieldType) {
        int hash = 31 + fieldType.hashCode();
        hash = 31 * hash + fieldName.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FieldCacheKey)) {
            return false;
        }
        FieldCacheKey other = (FieldCacheKey)o;
        return other.fieldType == this.fieldType && other.name.equals(this.name);
    }
}

