/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ComputedCalls;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleCache;
import java.lang.invoke.MethodType;
import java.lang.invoke.PrimitiveHandle;
import java.lang.invoke.ReceiverBoundHandle;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class DirectHandle
extends PrimitiveHandle {
    final boolean isStatic;
    final boolean originIsFindVirtual;
    private static final ThunkTable _thunkTable = new ThunkTable();

    DirectHandle(Class<?> referenceClass, String methodName, MethodType type, byte kind, Class<?> specialCaller) throws NoSuchMethodException, IllegalAccessException {
        this(referenceClass, methodName, type, kind, specialCaller, false);
    }

    DirectHandle(Class<?> referenceClass, String methodName, MethodType type, byte kind, Class<?> specialCaller, boolean originIsFindVirtual) throws NoSuchMethodException, IllegalAccessException {
        super(DirectHandle.directMethodType(type, kind, specialCaller), referenceClass, methodName, kind, null);
        assert (kind != 7 || specialCaller != null);
        this.specialCaller = specialCaller;
        this.addHandleToClassCache();
        this.defc = this.finishMethodInitialization(specialCaller, type);
        assert (this.kind != 5);
        this.isStatic = Modifier.isStatic(this.rawModifiers);
        this.originIsFindVirtual = originIsFindVirtual;
    }

    public DirectHandle(Method method, byte kind, Class<?> specialCaller) throws IllegalAccessException {
        this(method, kind, specialCaller, false);
    }

    public DirectHandle(Method method, byte kind, Class<?> specialCaller, boolean originIsFindVirtual) throws IllegalAccessException {
        super(DirectHandle.directMethodType(MethodType.methodType(method.getReturnType(), method.getParameterTypes()), kind, specialCaller), method.getDeclaringClass(), method.getName(), kind, method.getModifiers(), null);
        assert (kind != 7 || specialCaller != null);
        this.specialCaller = specialCaller;
        this.addHandleToClassCache();
        boolean succeed = DirectHandle.setVMSlotAndRawModifiersFromMethod(this, this.referenceClass, method, this.kind, specialCaller);
        if (!succeed) {
            throw new IllegalAccessException();
        }
        this.isStatic = Modifier.isStatic(this.rawModifiers);
        this.originIsFindVirtual = originIsFindVirtual;
    }

    DirectHandle(PrimitiveHandle other, byte kind) {
        super(ReceiverBoundHandle.receiverBoundMethodType(other.type), other.referenceClass, other.name, kind, other.rawModifiers, null);
        if (!(other instanceof DirectHandle)) {
            throw new IllegalArgumentException();
        }
        this.specialCaller = other.specialCaller;
        this.addHandleToClassCache();
        this.vmSlot = other.vmSlot;
        this.defc = other.defc;
        this.isStatic = Modifier.isStatic(other.rawModifiers);
        this.originIsFindVirtual = other.directHandleOriginatedInFindVirtual();
    }

    DirectHandle(DirectHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.isStatic = originalHandle.isStatic;
        this.originIsFindVirtual = originalHandle.originIsFindVirtual;
        this.addHandleToClassCache();
        this.vmSlot = originalHandle.vmSlot;
    }

    private static final MethodType directMethodType(MethodType existingType, byte kind, Class<?> specialCaller) {
        if (kind == 6) {
            return existingType;
        }
        return existingType.insertParameterTypes(0, specialCaller);
    }

    private void addHandleToClassCache() {
        MethodHandleCache cache = MethodHandleCache.getCache(this.defc);
        cache.addDirectHandle(this);
    }

    final void nullCheckIfRequired(Object receiver) throws NullPointerException {
        if (!this.isStatic) {
            receiver.getClass();
        }
    }

    @Override
    boolean canRevealDirect() {
        return true;
    }

    @Override
    boolean directHandleOriginatedInFindVirtual() {
        return this.originIsFindVirtual;
    }

    @Override
    protected ThunkTable thunkTable() {
        return _thunkTable;
    }

    protected static native boolean isAlreadyCompiled(long var0);

    protected static native long compiledEntryPoint(long var0);

    protected static native void directCall_V(int var0);

    protected static native int directCall_I(int var0);

    protected static native long directCall_J(int var0);

    protected static native float directCall_F(int var0);

    protected static native double directCall_D(int var0);

    protected static native Object directCall_L(int var0);

    protected static native void directCall_V(Object var0, int var1);

    protected static native int directCall_I(Object var0, int var1);

    protected static native long directCall_J(Object var0, int var1);

    protected static native float directCall_F(Object var0, int var1);

    protected static native double directCall_D(Object var0, int var1);

    protected static native Object directCall_L(Object var0, int var1);

    @MethodHandle.FrameIteratorSkip
    private final void invokeExact_thunkArchetype_V(int argPlaceholder) {
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            DirectHandle.directCall_V(argPlaceholder);
        } else if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            ComputedCalls.dispatchDirect_V(DirectHandle.compiledEntryPoint(this.vmSlot), argPlaceholder);
        } else {
            ComputedCalls.dispatchJ9Method_V(this.vmSlot, argPlaceholder);
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final void invokeExact_thunkArchetype_V(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            DirectHandle.directCall_V(receiver, argPlaceholder);
        } else if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            ComputedCalls.dispatchDirect_V(DirectHandle.compiledEntryPoint(this.vmSlot), receiver, argPlaceholder);
        } else {
            ComputedCalls.dispatchJ9Method_V(this.vmSlot, receiver, argPlaceholder);
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_I(int argPlaceholder) {
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            return DirectHandle.directCall_I(argPlaceholder);
        }
        if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_I(DirectHandle.compiledEntryPoint(this.vmSlot), argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_I(this.vmSlot, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_I(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            return DirectHandle.directCall_I(receiver, argPlaceholder);
        }
        if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_I(DirectHandle.compiledEntryPoint(this.vmSlot), receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_I(this.vmSlot, receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final long invokeExact_thunkArchetype_J(int argPlaceholder) {
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            return DirectHandle.directCall_J(argPlaceholder);
        }
        if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_J(DirectHandle.compiledEntryPoint(this.vmSlot), argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_J(this.vmSlot, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final long invokeExact_thunkArchetype_J(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            return DirectHandle.directCall_J(receiver, argPlaceholder);
        }
        if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_J(DirectHandle.compiledEntryPoint(this.vmSlot), receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_J(this.vmSlot, receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final float invokeExact_thunkArchetype_F(int argPlaceholder) {
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            return DirectHandle.directCall_F(argPlaceholder);
        }
        if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_F(DirectHandle.compiledEntryPoint(this.vmSlot), argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_F(this.vmSlot, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final float invokeExact_thunkArchetype_F(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            return DirectHandle.directCall_F(receiver, argPlaceholder);
        }
        if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_F(DirectHandle.compiledEntryPoint(this.vmSlot), receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_F(this.vmSlot, receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final double invokeExact_thunkArchetype_D(int argPlaceholder) {
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            return DirectHandle.directCall_D(argPlaceholder);
        }
        if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_D(DirectHandle.compiledEntryPoint(this.vmSlot), argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_D(this.vmSlot, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final double invokeExact_thunkArchetype_D(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            return DirectHandle.directCall_D(receiver, argPlaceholder);
        }
        if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_D(DirectHandle.compiledEntryPoint(this.vmSlot), receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_D(this.vmSlot, receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final Object invokeExact_thunkArchetype_L(int argPlaceholder) {
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            return DirectHandle.directCall_L(argPlaceholder);
        }
        if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_L(DirectHandle.compiledEntryPoint(this.vmSlot), argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_L(this.vmSlot, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final Object invokeExact_thunkArchetype_L(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        this.initializeClassIfRequired();
        if (ILGenMacros.isCustomThunk()) {
            return DirectHandle.directCall_L(receiver, argPlaceholder);
        }
        if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_L(DirectHandle.compiledEntryPoint(this.vmSlot), receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_L(this.vmSlot, receiver, argPlaceholder);
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new DirectHandle(this, newType);
    }

    @Override
    void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof DirectHandle) {
            ((DirectHandle)right).compareWithDirect(this, c);
        } else {
            c.fail();
        }
    }

    void compareWithDirect(DirectHandle left, Comparator c) {
        c.compareStructuralParameter(left.vmSlot, this.vmSlot);
    }

    public static void load() {
    }
}

