/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaJitInputType;
import com.ibm.cuda.CudaJitOptions;
import com.ibm.cuda.internal.CudaUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public final class CudaLinker {
    private final CudaJitOptions createOptions;
    private final int deviceId;
    private final AtomicLong nativeHandle;

    private static native void add(int var0, long var1, int var3, byte[] var4, String var5, long var6) throws CudaException;

    private static native byte[] complete(int var0, long var1) throws CudaException;

    private static native long create(int var0, long var1) throws CudaException;

    private static native void destroy(int var0, long var1) throws CudaException;

    public CudaLinker(CudaDevice device) throws CudaException {
        this(device, null);
    }

    public CudaLinker(CudaDevice device, CudaJitOptions options) throws CudaException {
        this.createOptions = options;
        this.deviceId = device.getDeviceId();
        this.nativeHandle = new AtomicLong(CudaLinker.create(this.deviceId, options == null ? 0L : options.getHandle()));
    }

    public CudaLinker add(CudaJitInputType type, byte[] data, String name) throws CudaException {
        return this.add(type, data, name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CudaLinker add(CudaJitInputType type, byte[] data, String name, CudaJitOptions options) throws CudaException {
        if (type == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        long handle = this.getHandle();
        if (options == null) {
            CudaLinker.add(this.deviceId, handle, type.nativeValue, data, name, 0L);
        } else {
            try {
                CudaLinker.add(this.deviceId, handle, type.nativeValue, data, name, options.getHandle());
            }
            finally {
                options.releaseHandle(true);
            }
        }
        if (this.createOptions != null) {
            this.createOptions.update();
        }
        return this;
    }

    public CudaLinker add(CudaJitInputType type, InputStream input, String name) throws CudaException, IOException {
        return this.add(type, input, name, null);
    }

    public CudaLinker add(CudaJitInputType type, InputStream input, String name, CudaJitOptions options) throws CudaException, IOException {
        return this.add(type, CudaUtil.read(input, true), name, options);
    }

    public byte[] complete() throws CudaException {
        return CudaLinker.complete(this.deviceId, this.getHandle());
    }

    public void destroy() throws CudaException {
        long handle = this.nativeHandle.getAndSet(0L);
        if (handle != 0L) {
            CudaLinker.destroy(this.deviceId, handle);
        }
        if (this.createOptions != null) {
            this.createOptions.releaseHandle(false);
        }
    }

    public String getErrorLogBuffer() {
        if (this.createOptions == null) {
            return "";
        }
        return this.createOptions.getErrorLogBuffer();
    }

    private long getHandle() {
        long handle = this.nativeHandle.get();
        if (handle == 0L) {
            throw new IllegalStateException();
        }
        return handle;
    }

    public String getInfoLogBuffer() {
        if (this.createOptions == null) {
            return "";
        }
        return this.createOptions.getInfoLogBuffer();
    }

    public float getWallTime() {
        if (this.createOptions == null) {
            return 0.0f;
        }
        return this.createOptions.getWallTime();
    }
}

