/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29_00.j9.gc.GCVMThreadJNISlotIterator;
import com.ibm.j9ddr.vm29_00.j9.gc.GCVMThreadMonitorRecordSlotIterator;
import com.ibm.j9ddr.vm29_00.j9.gc.GCVMThreadSlotIterator;
import com.ibm.j9ddr.vm29_00.pointer.VoidPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9VMThreadPointer;
import java.util.NoSuchElementException;

public class GCVMThreadIterator
extends GCIterator {
    public static final int state_start = 0;
    public static final int state_slots = 1;
    public static final int state_jni_slots = 2;
    public static final int state_monitor_records = 3;
    public static final int state_end = 4;
    protected int state = 0;
    protected GCVMThreadSlotIterator threadSlotIterator;
    protected GCVMThreadJNISlotIterator threadJNISlotIterator;
    protected GCVMThreadMonitorRecordSlotIterator threadMonitorRecordSlotIterator;
    protected J9VMThreadPointer vmThread;

    protected GCVMThreadIterator(J9VMThreadPointer vmThread) throws CorruptDataException {
        this.vmThread = vmThread;
        this.threadSlotIterator = GCVMThreadSlotIterator.fromJ9VMThread(vmThread);
        this.threadJNISlotIterator = GCVMThreadJNISlotIterator.fromJ9VMThread(vmThread);
        this.threadMonitorRecordSlotIterator = GCVMThreadMonitorRecordSlotIterator.fromJ9VMThread(vmThread);
    }

    public static GCVMThreadIterator fromJ9VMThread(J9VMThreadPointer vmThread) throws CorruptDataException {
        return new GCVMThreadIterator(vmThread);
    }

    @Override
    public boolean hasNext() {
        if (this.state == 4) {
            return false;
        }
        switch (this.state) {
            case 0: {
                ++this.state;
            }
            case 1: {
                if (this.threadSlotIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
            case 2: {
                if (this.threadJNISlotIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
            case 3: {
                if (this.threadMonitorRecordSlotIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
        }
        return false;
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            switch (this.state) {
                case 1: {
                    return this.threadSlotIterator.next();
                }
                case 2: {
                    return this.threadJNISlotIterator.next();
                }
                case 3: {
                    return this.threadMonitorRecordSlotIterator.next();
                }
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            switch (this.state) {
                case 1: {
                    return this.threadSlotIterator.nextAddress();
                }
                case 2: {
                    return this.threadJNISlotIterator.nextAddress();
                }
                case 3: {
                    return this.threadMonitorRecordSlotIterator.nextAddress();
                }
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    public int getState() {
        return this.state;
    }

    public J9VMThreadPointer getThread() {
        return this.vmThread;
    }
}

