/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29_00.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29_00.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm29_00.j9.stackwalker.IStackWalkerCallbacks;
import com.ibm.j9ddr.vm29_00.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm29_00.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm29_00.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29_00.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29_00.pointer.PointerPointer;
import com.ibm.j9ddr.vm29_00.pointer.VoidPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29_00.structure.J9Consts;
import java.util.ArrayList;
import java.util.Iterator;

public class StackRoots {
    private ArrayList<J9ObjectPointer> _allStackRoots = new ArrayList();
    private ArrayList<VoidPointer> _allAddresses = new ArrayList();
    private static StackRoots _singleton;

    private StackRoots() throws CorruptDataException {
        this._allStackRoots = new ArrayList();
        this._allAddresses = new ArrayList();
        this.walkStacks();
    }

    public static StackRoots from() throws CorruptDataException {
        if (null != _singleton) {
            return _singleton;
        }
        _singleton = new StackRoots();
        return _singleton;
    }

    private void walkStacks() throws CorruptDataException {
        GCVMThreadListIterator threadIterator = GCVMThreadListIterator.from();
        while (threadIterator.hasNext()) {
            J9VMThreadPointer next = threadIterator.next();
            WalkState walkState = new WalkState();
            walkState.walkThread = next;
            walkState.flags = J9Consts.J9_STACKWALK_SKIP_INLINES | J9Consts.J9_STACKWALK_ITERATE_O_SLOTS | J9Consts.J9_STACKWALK_ITERATE_METHOD_CLASS_SLOTS;
            walkState.callBacks = new StackWalkerCallbacks();
            StackWalkResult result = StackWalkResult.STACK_CORRUPT;
            result = StackWalker.walkStackFrames(walkState);
            if (StackWalkResult.NONE == result) continue;
            throw new UnsupportedOperationException("Failed to walk stack");
        }
    }

    public static ArrayList<J9ObjectPointer> allRoots() throws CorruptDataException {
        StackRoots stackRoots = new StackRoots();
        return stackRoots._allStackRoots;
    }

    public static GCIterator stackRootIterator() throws CorruptDataException {
        StackRoots stackRootSet = StackRoots.from();
        final Iterator<J9ObjectPointer> rootSetIterator = stackRootSet._allStackRoots.iterator();
        final Iterator<VoidPointer> rootSetAddressIterator = stackRootSet._allAddresses.iterator();
        return new GCIterator(){

            @Override
            public boolean hasNext() {
                return rootSetIterator.hasNext();
            }

            @Override
            public VoidPointer nextAddress() {
                rootSetIterator.next();
                return (VoidPointer)rootSetAddressIterator.next();
            }

            @Override
            public Object next() {
                rootSetAddressIterator.next();
                return rootSetIterator.next();
            }
        };
    }

    private class StackWalkerCallbacks
    implements IStackWalkerCallbacks {
        private StackWalkerCallbacks() {
        }

        @Override
        public FrameCallbackResult frameWalkFunction(J9VMThreadPointer walkThread, WalkState walkState) {
            return FrameCallbackResult.KEEP_ITERATING;
        }

        @Override
        public void objectSlotWalkFunction(J9VMThreadPointer walkThread, WalkState walkState, PointerPointer objectSlot, VoidPointer stackAddress) {
            if (walkState.method.isNull()) {
                return;
            }
            try {
                J9ObjectPointer object = J9ObjectPointer.cast(objectSlot.at(0L));
                if (object.notNull()) {
                    StackRoots.this._allStackRoots.add(object);
                    StackRoots.this._allAddresses.add(VoidPointer.cast(objectSlot));
                }
            }
            catch (CorruptDataException e) {
                throw new UnsupportedOperationException("Corrupt objectSlot detected");
            }
        }

        @Override
        public void fieldSlotWalkFunction(J9VMThreadPointer walkThread, WalkState walkState, ObjectReferencePointer objectSlot, VoidPointer stackLocation) {
            if (walkState.method.isNull()) {
                return;
            }
            try {
                J9ObjectPointer object = objectSlot.at(0L);
                if (object.notNull()) {
                    StackRoots.this._allStackRoots.add(object);
                    StackRoots.this._allAddresses.add(VoidPointer.cast(objectSlot));
                }
            }
            catch (CorruptDataException e) {
                throw new UnsupportedOperationException("Corrupt objectSlot detected");
            }
        }
    }
}

