/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VTableHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9VTableHeader;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class J9VTablesCommand
extends Command {
    public J9VTablesCommand() {
        this.addCommand("j9vtables", "<ramclass>", "dump interpreter and jit vtables for given ram class.");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            long startIndex;
            long jitVTableOffset;
            UDATAPointer vTable;
            UDATA vTableMethodCount;
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            UDATAPointer jitVTable = UDATAPointer.NULL;
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
            J9ClassPointer ramClass = J9ClassPointer.cast(address);
            if (AlgorithmVersion.getVersionOf("ALG_VM_VTABLE_VERSION").getAlgorithmVersion() >= 1) {
                J9VTableHeaderPointer vTableHeader = J9ClassHelper.vTableHeader(ramClass);
                try {
                    vTableMethodCount = vTableHeader.size();
                }
                catch (NoSuchFieldException e) {
                    throw new CorruptDataException(e);
                }
                vTable = J9ClassHelper.vTable(vTableHeader);
                jitVTableOffset = (vTableMethodCount.longValue() - 1L) * (long)UDATA.SIZEOF + J9VTableHeader.SIZEOF;
                startIndex = 0L;
            } else {
                vTable = J9ClassHelper.oldVTable(ramClass);
                vTableMethodCount = vTable.at(0L).add(1L);
                jitVTableOffset = vTableMethodCount.longValue() * (long)UDATA.SIZEOF;
                startIndex = 2L;
            }
            if (J9BuildFlags.interp_nativeSupport && !vm.jitConfig().isNull()) {
                jitVTable = UDATAPointer.cast(U8Pointer.cast(ramClass).sub(jitVTableOffset));
            }
            CommandUtils.dbgPrint(out, String.format("VTable for j9class %s  (size=%d - 1 for skipped resolve method)\n", ramClass.getHexAddress(), vTableMethodCount.longValue()));
            CommandUtils.dbgPrint(out, String.format("\tInterpreted%s\n", !jitVTable.isNull() ? "\t\tJitted\n" : ""));
            for (long i = startIndex; i < vTableMethodCount.longValue(); ++i) {
                String name = J9MethodHelper.getName(J9MethodPointer.cast(vTable.at(i)));
                String intAddr = U8Pointer.cast(vTable.at(i)).getHexAddress();
                if (!jitVTable.isNull()) {
                    String jitAddr = U8Pointer.cast(jitVTable.at(vTableMethodCount.sub(i))).getHexAddress();
                    CommandUtils.dbgPrint(out, String.format(" %d\t!j9method %s\t%s\t%s\n", i, intAddr, jitAddr, name));
                    continue;
                }
                CommandUtils.dbgPrint(out, String.format(" %d\t!j9method %s\t%s\t\n", i, intAddr, name));
            }
            return;
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

