/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class ClassloadersSummaryCommand
extends Command {
    public ClassloadersSummaryCommand() {
        this.addCommand("classloaderssummary", "[segs]", "Display classloaders summary, optionally including the RAM and ROM segment breakdown");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            Collection<ClassloadersSummaryNode> stats = this.getStat();
            this.printStat(stats, out, args.length > 0 && args[0].equalsIgnoreCase("segs"));
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    public void printStat(Collection<ClassloadersSummaryNode> stats, PrintStream out, boolean printSegments) throws CorruptDataException {
        int longestName = 0;
        int numClassloaders = 0;
        long numROMSegment = 0L;
        long numRAMSegment = 0L;
        long totalROMSegmentAllocatedSize = 0L;
        long totalRAMSegmentAllocatedSize = 0L;
        for (ClassloadersSummaryNode csc : stats) {
            numClassloaders = (int)((long)numClassloaders + csc.numClassloaders);
            longestName = Math.max(longestName, csc.name.length());
        }
        out.println();
        out.println("[Classloaders Summary]");
        CommandUtils.dbgPrint(out, "<num, %-" + longestName + "s, # Classloaders, # Loaded Classes", "Classloader name");
        if (printSegments) {
            CommandUtils.dbgPrint(out, ", # RAM Segments, RAM Segment memory, # ROM Segments, ROM Segment memory, Total Segments, Segments memory>" + nl);
        } else {
            CommandUtils.dbgPrint(out, ", Total Segments, Segments memory>" + nl);
        }
        TreeMap countmap = new TreeMap(Collections.reverseOrder());
        LinkedHashMap<Long, String> cllist = new LinkedHashMap<Long, String>();
        int count = 0;
        for (ClassloadersSummaryNode classloadersSummaryNode : stats) {
            long totalSegmentCount = classloadersSummaryNode.romSegmentCounter + classloadersSummaryNode.ramSegmentCounter;
            long totalAllocatedMemoryForclassloader = classloadersSummaryNode.totalROMSegmentAllocatedMemory + classloadersSummaryNode.totalRAMSegmentAllocatedMemory;
            CommandUtils.dbgPrint(out, "%3d)  %-" + longestName + "s, %-14d, %-16d", count, classloadersSummaryNode.name, classloadersSummaryNode.numClassloaders, classloadersSummaryNode.numLoadedClasses);
            if (printSegments) {
                CommandUtils.dbgPrint(out, ", %-14d, %-18d, %-14d, %-18d, %-14d, %d" + nl, classloadersSummaryNode.ramSegmentCounter, classloadersSummaryNode.totalRAMSegmentAllocatedMemory, classloadersSummaryNode.romSegmentCounter, classloadersSummaryNode.totalROMSegmentAllocatedMemory, totalSegmentCount, totalAllocatedMemoryForclassloader);
            } else {
                CommandUtils.dbgPrint(out, ", %-14d, %d" + nl, totalSegmentCount, totalAllocatedMemoryForclassloader);
            }
            numROMSegment += classloadersSummaryNode.romSegmentCounter;
            numRAMSegment += classloadersSummaryNode.ramSegmentCounter;
            totalROMSegmentAllocatedSize += classloadersSummaryNode.totalROMSegmentAllocatedMemory;
            totalRAMSegmentAllocatedSize += classloadersSummaryNode.totalRAMSegmentAllocatedMemory;
            Long cpval = (Long)countmap.get(classloadersSummaryNode.numLoadedClasses);
            if (cpval != null) {
                Long clcount = new Long(cpval + classloadersSummaryNode.numClassloaders);
                countmap.put(classloadersSummaryNode.numLoadedClasses, clcount);
                String list = (String)((HashMap)cllist).get(classloadersSummaryNode.numLoadedClasses);
                cllist.put(classloadersSummaryNode.numLoadedClasses, list + ", " + classloadersSummaryNode.name);
            } else {
                countmap.put(classloadersSummaryNode.numLoadedClasses, classloadersSummaryNode.numClassloaders);
                cllist.put(classloadersSummaryNode.numLoadedClasses, classloadersSummaryNode.name);
            }
            ++count;
        }
        if (!countmap.isEmpty()) {
            out.println("\n<# Loaded Classes, # Classloaders, Classloader Names>");
            for (Map.Entry entry : countmap.entrySet()) {
                CommandUtils.dbgPrint(out, "%-17d, %-14d, %s" + nl, entry.getKey(), entry.getValue(), ((HashMap)cllist).get(entry.getKey()));
            }
        }
        out.println();
        out.println("Number of Classloaders: " + numClassloaders);
        out.println();
        out.println("Segment Totals: ");
        out.println("\n<# RAM Segments, RAM Segments memory, # ROM Segments, ROM Segments memory, Total Segments, Segments memory>");
        CommandUtils.dbgPrint(out, " %-14d, %-19d, %-14d, %-19d, %-14d, %d", numRAMSegment, totalRAMSegmentAllocatedSize, numROMSegment, totalROMSegmentAllocatedSize, numRAMSegment + numROMSegment, totalRAMSegmentAllocatedSize + totalROMSegmentAllocatedSize);
        out.println();
    }

    public Collection<ClassloadersSummaryNode> getStat() throws CorruptDataException {
        HashMap<J9ClassLoaderPointer, Counter> classloadersCount = new HashMap<J9ClassLoaderPointer, Counter>();
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        GCClassLoaderIterator iterator = GCClassLoaderIterator.from();
        while (iterator.hasNext()) {
            J9ClassLoaderPointer classLoader = iterator.next();
            classloadersCount.put(classLoader, new Counter(0L));
        }
        ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(vm.classMemorySegments());
        while (classSegmentIterator.hasNext()) {
            J9ClassPointer classPointer = (J9ClassPointer)classSegmentIterator.next();
            Counter counter = (Counter)classloadersCount.get(classPointer.classLoader());
            if (counter != null) {
                counter.addOne();
                continue;
            }
            classloadersCount.put(classPointer.classLoader(), new Counter(1L));
        }
        J9ObjectPointer sys = vm.systemClassLoader().classLoaderObject();
        UDATA valueROM = new UDATA(J9MemorySegment.MEMORY_TYPE_ROM_CLASS);
        UDATA valueRAM = new UDATA(J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        LinkedHashMap<String, ClassloadersSummaryNode> classloaders = new LinkedHashMap<String, ClassloadersSummaryNode>();
        for (Map.Entry entry : classloadersCount.entrySet()) {
            J9ObjectPointer classLoaderObject = ((J9ClassLoaderPointer)entry.getKey()).classLoaderObject();
            boolean isSystem = classLoaderObject.equals(sys);
            String loader = isSystem ? "*System*" : J9ObjectHelper.getClassName(classLoaderObject);
            long romSegmentCount = 0L;
            long ramSegmentCount = 0L;
            long romSegmentAllocatedMem = 0L;
            long ramSegmentAllocatedMem = 0L;
            J9MemorySegmentPointer segment = ((J9ClassLoaderPointer)entry.getKey()).classSegments();
            while (segment.notNull()) {
                if (segment.type().bitAnd(valueROM).equals(valueROM)) {
                    ++romSegmentCount;
                    romSegmentAllocatedMem += segment.size().longValue();
                } else if (segment.type().bitAnd(valueRAM).equals(valueRAM)) {
                    ++ramSegmentCount;
                    ramSegmentAllocatedMem += segment.size().longValue();
                }
                segment = segment.nextSegmentInClassLoader();
            }
            ClassloadersSummaryNode cpentry = (ClassloadersSummaryNode)classloaders.get(loader);
            if (cpentry == null) {
                classloaders.put(loader, new ClassloadersSummaryNode(loader, 1L, ((Counter)entry.getValue()).getCount(), ramSegmentCount, romSegmentCount, romSegmentAllocatedMem, ramSegmentAllocatedMem));
                continue;
            }
            ClassloadersSummaryNode classloadersSummaryNode = cpentry;
            Long.valueOf(classloadersSummaryNode.numClassloaders + 1L);
            classloadersSummaryNode.numClassloaders = classloadersSummaryNode.numClassloaders;
            cpentry.numLoadedClasses += ((Counter)entry.getValue()).getCount();
            cpentry.ramSegmentCounter += ramSegmentCount;
            cpentry.romSegmentCounter += romSegmentCount;
            cpentry.totalROMSegmentAllocatedMemory += romSegmentAllocatedMem;
            cpentry.totalRAMSegmentAllocatedMemory += ramSegmentAllocatedMem;
        }
        return classloaders.values();
    }

    public class ClassloadersSummaryNode {
        public String name;
        public Long numClassloaders;
        public long numLoadedClasses;
        public long romSegmentCounter;
        public long ramSegmentCounter;
        public long totalROMSegmentAllocatedMemory;
        public long totalRAMSegmentAllocatedMemory;

        public ClassloadersSummaryNode(String name, Long numClassloaders, long numLoadedClasses, long ramSegmentCounter, long romSegmentCounter, long totalROMSegmentAllocatedMemory, long totalRAMSegmentAllocatedMemory) {
            this.name = name;
            this.numClassloaders = numClassloaders;
            this.numLoadedClasses = numLoadedClasses;
            this.romSegmentCounter = romSegmentCounter;
            this.ramSegmentCounter = ramSegmentCounter;
            this.totalROMSegmentAllocatedMemory = totalROMSegmentAllocatedMemory;
            this.totalRAMSegmentAllocatedMemory = totalRAMSegmentAllocatedMemory;
        }
    }

    static final class Counter {
        long count;

        Counter(long initialValue) {
            this.count = initialValue;
        }

        Counter addOne() {
            ++this.count;
            return this;
        }

        long getCount() {
            return this.count;
        }
    }
}

