/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionManager;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectModel;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

public final class ObjectModel {
    protected static final GCObjectModel gcObjectModel;

    private ObjectModel() {
    }

    public static UDATA adjustSizeInBytes(UDATA sizeInBytes) {
        return gcObjectModel.adjustSizeInBytes(sizeInBytes);
    }

    public static long getObjectAlignmentInBytes() {
        return gcObjectModel.getObjectAlignmentInBytes();
    }

    public static UDATA getClassShape(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getClassShape(object);
    }

    public static UDATA getClassShape(J9ClassPointer clazz) throws CorruptDataException {
        return gcObjectModel.getClassShape(clazz);
    }

    public static boolean isIndexable(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isIndexable(object);
    }

    public static boolean isIndexable(J9ClassPointer clazz) throws CorruptDataException {
        return gcObjectModel.isIndexable(clazz);
    }

    public static boolean isHoleObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isHoleObject(object);
    }

    public static boolean isSingleSlotHoleObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isSingleSlotHoleObject(object);
    }

    public static UDATA getSizeInBytesMultiSlotHoleObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesMultiSlotHoleObject(object);
    }

    public static UDATA getSizeInBytesSingleSlotHoleObject(J9ObjectPointer object) {
        return gcObjectModel.getSizeInBytesSingleSlotHoleObject(object);
    }

    public static UDATA getSizeInBytesHoleObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesHoleObject(object);
    }

    public static boolean isDarkMatterObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isDarkMatterObject(object);
    }

    public static UDATA getSizeInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesWithHeader(object);
    }

    public static UDATA getTotalFootprintInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getTotalFootprintInBytesWithHeader(object);
    }

    public static UDATA getConsumedSizeInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getConsumedSizeInBytesWithHeader(object);
    }

    public UDATA getSizeInSlotsWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return UDATA.convertBytesToSlots(ObjectModel.getSizeInBytesWithHeader(object));
    }

    public UDATA getConsumedSizeInSlotsWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return UDATA.convertBytesToSlots(ObjectModel.getConsumedSizeInBytesWithHeader(object));
    }

    public static U32 getAge(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getAge(object);
    }

    public static boolean isRemembered(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isRemembered(object);
    }

    public static UDATA getRememberedBits(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getRememberedBits(object);
    }

    public static boolean isOld(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isOld(object);
    }

    public static UDATA getSizeInElements(J9ObjectPointer object) throws IllegalArgumentException, CorruptDataException {
        return gcObjectModel.getSizeInElements(object);
    }

    public static long getScanType(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getScanType(object);
    }

    public static boolean hasBeenHashed(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.hasBeenHashed(object);
    }

    public static boolean hasBeenMoved(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.hasBeenMoved(object);
    }

    public static I32 getObjectHashCode(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getObjectHashCode(object);
    }

    public static UDATA getHashcodeOffset(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getHashcodeOffset(object);
    }

    public static UDATA getDataSizeInBytes(J9IndexableObjectPointer array) throws CorruptDataException {
        return gcObjectModel.getDataSizeInBytes(array);
    }

    public static UDATA getHeaderSize(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getHeaderSize(object);
    }

    public static VoidPointer getElementAddress(J9IndexableObjectPointer indexableObjectPointer, int elementIndex, int elementSize) throws CorruptDataException {
        return gcObjectModel.getElementAddress(indexableObjectPointer, elementIndex, elementSize);
    }

    public static GCHeapRegionDescriptor findRegionForPointer(J9JavaVMPointer javaVM, GCHeapRegionManager hrm, AbstractPointer pointer, GCHeapRegionDescriptor region) {
        GCHeapRegionDescriptor regionDesc = null;
        if (region != null && region.isAddressInRegion(pointer)) {
            return region;
        }
        regionDesc = ObjectModel.regionForAddress(javaVM, hrm, pointer);
        if (null != regionDesc) {
            return regionDesc;
        }
        try {
            GCHeapRegionIterator iterator = GCHeapRegionIterator.from();
            while (iterator.hasNext()) {
                regionDesc = GCHeapRegionDescriptor.fromHeapRegionDescriptor(iterator.next());
                if (!ObjectModel.isPointerInRegion(pointer, regionDesc)) continue;
                return regionDesc;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        return null;
    }

    public static GCHeapRegionDescriptor regionForAddress(J9JavaVMPointer javaVM, GCHeapRegionManager hrm, AbstractPointer pointer) {
        try {
            if (null == hrm) {
                MM_HeapRegionManagerPointer hrmPtr = MM_GCExtensionsPointer.cast(javaVM.gcExtensions()).heapRegionManager();
                hrm = GCHeapRegionManager.fromHeapRegionManager(hrmPtr);
            }
            return hrm.regionDescriptorForAddress(pointer);
        }
        catch (CorruptDataException corruptDataException) {
            return null;
        }
    }

    public static boolean isPointerInRegion(AbstractPointer pointer, GCHeapRegionDescriptor region) {
        return pointer.gte(region.getLowAddress()) && pointer.lt(region.getHighAddress());
    }

    public static boolean isPointerInHeap(J9JavaVMPointer javaVM, AbstractPointer pointer) {
        return ObjectModel.findRegionForPointer(javaVM, null, pointer, null) != null;
    }

    public static boolean isInlineContiguousArraylet(J9IndexableObjectPointer arrayPtr) throws CorruptDataException {
        return gcObjectModel.isInlineContiguousArraylet(arrayPtr);
    }

    static {
        GCObjectModel objectModel = null;
        try {
            objectModel = GCObjectModel.from();
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error initializing the object model", cde, true);
            objectModel = null;
        }
        gcObjectModel = objectModel;
    }
}

