/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm28.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm28.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm28.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm28.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm28.view.dtfj.java.j9.SlidingIterator;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTFJJavaClassloader
implements JavaClassLoader {
    private J9ClassLoaderPointer j9ClassLoader;
    private SoftReference<ClassCache> softReferenceToClassCache = new SoftReference<Object>(null);
    private Logger log = DTFJContext.getLogger();

    public DTFJJavaClassloader(J9ClassLoaderPointer pointer) {
        this.j9ClassLoader = pointer;
        this.log.fine(String.format("Created JavaClassloader for 0x%016x", pointer.getAddress()));
    }

    public JavaClass findClass(String name) throws com.ibm.dtfj.image.CorruptDataException {
        ClassCache cache = this.getPopulatedClassCache();
        return cache.findClass(name);
    }

    public Iterator getCachedClasses() {
        ClassCache cache = this.getPopulatedClassCache();
        return cache.getCachedClasses();
    }

    public Iterator getDefinedClasses() {
        ClassCache cache = this.getPopulatedClassCache();
        return cache.getDefinedClasses();
    }

    public JavaObject getObject() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return new DTFJJavaObject(this.j9ClassLoader.classLoaderObject());
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DTFJJavaClassloader) {
            DTFJJavaClassloader objImpl = (DTFJJavaClassloader)obj;
            return this.j9ClassLoader.getAddress() == objImpl.j9ClassLoader.getAddress();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.j9ClassLoader.getAddress();
    }

    private ClassCache getPopulatedClassCache() {
        ClassCache cache = this.softReferenceToClassCache.get();
        if (cache == null) {
            cache = new ClassCache();
            cache.populateCache();
            this.log.fine(String.format("Populated class cache for JavaClassLoader 0x%016x", this.j9ClassLoader.getAddress()));
            this.softReferenceToClassCache = new SoftReference<ClassCache>(cache);
        }
        return cache;
    }

    private class ClassCache
    implements IEventListener {
        private ArrayList<Object> cache = new ArrayList();
        private HashMap<String, Integer> names = new HashMap();
        private Iterator corruptCache;
        private int definedClassCount = 0;

        private ClassCache() {
        }

        void populateCache() {
            Iterator<J9ClassPointer> classes;
            try {
                classes = ClassIterator.fromJ9Classloader(DTFJJavaClassloader.this.j9ClassLoader);
            }
            catch (Throwable t) {
                CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                this.corruptCache = J9DDRDTFJUtils.corruptIterator(cd);
                return;
            }
            int index = 0;
            index += this.storeClasses(classes, index);
            try {
                ClassSegmentIterator definedClasses = new ClassSegmentIterator(DTFJJavaClassloader.this.j9ClassLoader.classSegments());
                this.definedClassCount = this.storeClasses(definedClasses, index);
                index += this.definedClassCount;
            }
            catch (Throwable t) {
                CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                this.cache.add(cd);
            }
            if (DTFJJavaClassloader.this.log.isLoggable(Level.FINE)) {
                if (this.corruptCache == null) {
                    DTFJJavaClassloader.this.log.fine(String.format("The class loader cache for 0x%016x is not corrupt", DTFJJavaClassloader.this.j9ClassLoader.getAddress()));
                    DTFJJavaClassloader.this.log.fine(String.format("Stored %d classes", this.cache.size()));
                    DTFJJavaClassloader.this.log.fine(String.format("Found %d defined classes", this.definedClassCount));
                } else {
                    DTFJJavaClassloader.this.log.fine("The class loader cache is corrupt");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int storeClasses(Iterator classes, int start) {
            int initialSize = this.cache.size();
            try {
                EventManager.register(this);
                while (classes.hasNext()) {
                    J9ClassPointer ptr = (J9ClassPointer)classes.next();
                    DTFJJavaClassloader.this.log.fine(String.format("Found JavaClass at 0x%016x", ptr.getAddress()));
                    DTFJJavaClass clazz = new DTFJJavaClass(ptr);
                    try {
                        this.names.put(clazz.getName(), start + (this.cache.size() - initialSize));
                        this.cache.add(clazz);
                    }
                    catch (com.ibm.dtfj.image.CorruptDataException e) {
                        this.cache.add(e.getCorruptData());
                    }
                }
            }
            finally {
                EventManager.unregister(this);
            }
            return this.cache.size() - initialSize;
        }

        @Override
        public void corruptData(String message2, CorruptDataException e, boolean fatal) {
            J9DDRCorruptData cd = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e);
            this.cache.add(cd);
        }

        Iterator getCachedClasses() {
            if (this.corruptCache == null) {
                return new SlidingIterator(this.cache, 0, this.cache.size() - this.definedClassCount);
            }
            return this.corruptCache;
        }

        Iterator getDefinedClasses() {
            if (this.corruptCache == null) {
                if (this.definedClassCount == 0) {
                    return J9DDRDTFJUtils.emptyIterator();
                }
                return new SlidingIterator(this.cache, this.cache.size() - this.definedClassCount, this.cache.size());
            }
            return this.corruptCache;
        }

        JavaClass findClass(String name) {
            Integer index = this.names.get(name);
            if (index == null) {
                return null;
            }
            if (index instanceof Integer) {
                return (JavaClass)this.cache.get(index);
            }
            throw new IllegalArgumentException(String.format("The name lookup cache contained an instance of %s", index.getClass().getName()));
        }
    }
}

