/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm28.pointer.U32Pointer;
import com.ibm.j9ddr.vm28.pointer.U8Pointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9LineNumberPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm28.types.U32;

public class J9MethodDebugInfoHelper {
    public static U32 getLineNumberCount(J9MethodDebugInfoPointer ptr) throws CorruptDataException {
        if (AlgorithmVersion.getVersionOf("VM_LINE_NUMBER_TABLE_VERSION").getAlgorithmVersion() < 1) {
            return ptr.lineNumberCount();
        }
        U32 lineNumberCount = ptr.lineNumberCount();
        if (lineNumberCount.bitAnd(1).eq(0L)) {
            return lineNumberCount.rightShift(1).bitAnd(Short.MAX_VALUE);
        }
        return lineNumberCount.rightShift(1);
    }

    public static J9LineNumberPointer getLineNumberTableForROMClass(J9MethodDebugInfoPointer ptr) throws CorruptDataException {
        if (!ptr.lineNumberCount().eq(0L)) {
            return J9LineNumberPointer.cast(ptr.add(1L));
        }
        return J9LineNumberPointer.NULL;
    }

    public static U8Pointer getCompressedLineNumberTableForROMClassV1(J9MethodDebugInfoPointer ptr) throws CorruptDataException {
        if (!J9MethodDebugInfoHelper.getLineNumberCount(ptr).eq(0L)) {
            if (ptr.lineNumberCount().bitAnd(1).eq(1L)) {
                return U8Pointer.cast(ptr.add(1L)).add(4L);
            }
            return U8Pointer.cast(ptr.add(1L));
        }
        return U8Pointer.NULL;
    }

    public static U32 getLineNumberCompressedSize(J9MethodDebugInfoPointer ptr) throws CorruptDataException {
        U32 lineNumberCount = ptr.lineNumberCount();
        if (lineNumberCount.bitAnd(1).eq(0L)) {
            return lineNumberCount.rightShift(16).bitAnd(65535);
        }
        return U32Pointer.cast(ptr.add(1L)).at(0L);
    }
}

