/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.pointer.generated;

import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm28.pointer.AbstractPointer;
import com.ibm.j9ddr.vm28.pointer.StructurePointer;
import com.ibm.j9ddr.vm28.structure.JniConstants;
import com.ibm.j9ddr.vm28.types.Scalar;
import com.ibm.j9ddr.vm28.types.UDATA;

@GeneratedPointerClass(structureClass=JniConstants.class)
public class JniConstantsPointer
extends StructurePointer {
    public static final JniConstantsPointer NULL = new JniConstantsPointer(0L);

    protected JniConstantsPointer(long address) {
        super(address);
    }

    public static JniConstantsPointer cast(AbstractPointer structure) {
        return JniConstantsPointer.cast(structure.getAddress());
    }

    public static JniConstantsPointer cast(UDATA udata) {
        return JniConstantsPointer.cast(udata.longValue());
    }

    public static JniConstantsPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new JniConstantsPointer(address);
    }

    @Override
    public JniConstantsPointer add(long count) {
        return JniConstantsPointer.cast(this.address + JniConstants.SIZEOF * count);
    }

    @Override
    public JniConstantsPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public JniConstantsPointer addOffset(long offset) {
        return JniConstantsPointer.cast(this.address + offset);
    }

    @Override
    public JniConstantsPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public JniConstantsPointer sub(long count) {
        return JniConstantsPointer.cast(this.address - JniConstants.SIZEOF * count);
    }

    @Override
    public JniConstantsPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public JniConstantsPointer subOffset(long offset) {
        return JniConstantsPointer.cast(this.address - offset);
    }

    @Override
    public JniConstantsPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public JniConstantsPointer untag(long mask) {
        return JniConstantsPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public JniConstantsPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return JniConstants.SIZEOF;
    }
}

