/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm28.pointer.generated.J9MemCategoryPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9MemCategorySetPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9PortLibraryPointer;
import com.ibm.j9ddr.vm28.types.U32;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class MemoryCategoryIterator
implements Iterator<J9MemCategoryPointer> {
    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }

    public static Iterator<J9MemCategoryPointer> iterateAllCategories(J9PortLibraryPointer portLibrary) throws CorruptDataException {
        J9MemCategorySetPointer omr_categories = portLibrary.portGlobals().control().omr_memory_categories();
        J9MemCategorySetPointer language_categories = portLibrary.portGlobals().control().language_memory_categories();
        if (omr_categories.notNull() && language_categories.notNull()) {
            return IteratorHelpers.combineIterators(new MemoryCategorySetIterator(omr_categories), new MemoryCategorySetIterator(language_categories));
        }
        if (omr_categories.notNull()) {
            return new MemoryCategorySetIterator(omr_categories);
        }
        if (language_categories.notNull()) {
            return new MemoryCategorySetIterator(language_categories);
        }
        return new PortLibraryCategoryIterator(portLibrary);
    }

    public static Iterator<? extends J9MemCategoryPointer> iterateCategoryRootSet(J9PortLibraryPointer portLibrary) throws CorruptDataException {
        J9MemCategoryPointer thisCategory;
        HashMap<U32, J9MemCategoryPointer> rootSetMap = new HashMap<U32, J9MemCategoryPointer>();
        Iterator<J9MemCategoryPointer> categoryIt = MemoryCategoryIterator.iterateAllCategories(portLibrary);
        while (categoryIt.hasNext()) {
            thisCategory = categoryIt.next();
            rootSetMap.put(thisCategory.categoryCode(), thisCategory);
        }
        categoryIt = MemoryCategoryIterator.iterateAllCategories(portLibrary);
        while (categoryIt.hasNext()) {
            thisCategory = categoryIt.next();
            int numberOfChildren = thisCategory.numberOfChildren().intValue();
            for (int i = 0; i < numberOfChildren; ++i) {
                U32 childCode = thisCategory.children().at(i);
                rootSetMap.remove(childCode);
            }
        }
        return Collections.unmodifiableCollection(rootSetMap.values()).iterator();
    }

    private static class PortLibraryCategoryIterator
    extends MemoryCategoryIterator {
        protected final J9PortLibraryPointer portLib;
        private State state;

        public PortLibraryCategoryIterator(J9PortLibraryPointer portLib) throws CorruptDataException {
            this.portLib = portLib;
            this.state = State.PORT_LIBRARY_CATEGORY;
        }

        @Override
        public boolean hasNext() {
            return this.state != State.TERMINAL_STATE;
        }

        @Override
        public J9MemCategoryPointer next() {
            J9MemCategoryPointer toReturn = null;
            while (toReturn == null) {
                try {
                    switch (this.state) {
                        case PORT_LIBRARY_CATEGORY: {
                            toReturn = this.portLib.portGlobals().portLibraryMemoryCategory();
                            break;
                        }
                        case UNKNOWN_CATEGORY: {
                            toReturn = this.portLib.portGlobals().unknownMemoryCategory();
                            break;
                        }
                        case UNUSED_SLAB_CATEGORY: {
                            toReturn = this.portLib.portGlobals().unusedAllocate32HeapRegionsMemoryCategory();
                            break;
                        }
                        case TERMINAL_STATE: {
                            return null;
                        }
                        default: {
                            throw new IllegalStateException("Unknown state: " + (Object)((Object)this.state));
                        }
                    }
                }
                catch (CorruptDataException ex) {
                    EventManager.raiseCorruptDataEvent("CorruptData encountered walking port library memory categories.", ex, false);
                }
                this.state = this.state.getNextState();
            }
            return toReturn;
        }

        private static enum State {
            TERMINAL_STATE(null),
            UNUSED_SLAB_CATEGORY(TERMINAL_STATE),
            UNKNOWN_CATEGORY(J9BuildFlags.env_data64 ? UNUSED_SLAB_CATEGORY : TERMINAL_STATE),
            PORT_LIBRARY_CATEGORY(UNKNOWN_CATEGORY);

            private final State nextState;

            private State(State nextState) {
                this.nextState = nextState;
            }

            public State getNextState() {
                if (this.nextState == null) {
                    return this;
                }
                return this.nextState;
            }
        }
    }

    private static class MemoryCategorySetIterator
    extends MemoryCategoryIterator {
        private int index = 0;
        private final J9MemCategorySetPointer categorySet;
        private J9MemCategoryPointer next;

        MemoryCategorySetIterator(J9MemCategorySetPointer categorySet) throws CorruptDataException {
            this.categorySet = categorySet;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.internalNext();
            return this.next != null;
        }

        private J9MemCategoryPointer internalNext() {
            try {
                if (this.index >= this.categorySet.numberOfCategories().intValue()) {
                    return null;
                }
            }
            catch (CorruptDataException e1) {
                return null;
            }
            try {
                VoidPointer nextAtIndex = this.categorySet.categories().at(this.index++);
                while (nextAtIndex.isNull() && this.index < this.categorySet.numberOfCategories().intValue()) {
                    nextAtIndex = this.categorySet.categories().at(this.index++);
                }
                return J9MemCategoryPointer.cast(nextAtIndex);
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("CorruptData encountered walking port library memory category set.", e, false);
                return null;
            }
        }

        @Override
        public J9MemCategoryPointer next() {
            if (this.hasNext()) {
                J9MemCategoryPointer toReturn = this.next;
                this.next = null;
                return toReturn;
            }
            throw new NoSuchElementException();
        }
    }
}

