/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9;

import com.ibm.j9ddr.IBootstrapRunnable;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.J9DDRClassLoader;
import com.ibm.j9ddr.StructureReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;

public class VMData
implements IVMData {
    private static final String version = "28";

    @Override
    public void bootstrapRelative(String relativeClassname, Object ... userData) throws ClassNotFoundException {
        Class<?> clazz = this.getClassLoader().loadClassRelativeToStream(relativeClassname, true);
        this.bootstrapClass(clazz, userData);
    }

    @Override
    public void bootstrap(String binaryName, Object ... userData) throws ClassNotFoundException {
        Class<?> clazz = this.getClassLoader().loadClass(binaryName);
        this.bootstrapClass(clazz, userData);
    }

    @Override
    public J9DDRClassLoader getClassLoader() {
        return (J9DDRClassLoader)VMData.class.getClassLoader();
    }

    private void bootstrapClass(Class<?> clazz, Object[] userData) {
        try {
            IBootstrapRunnable runnable = (IBootstrapRunnable)clazz.newInstance();
            Method runMenthod = clazz.getMethod("run", IVMData.class, Object[].class);
            runMenthod.invoke((Object)runnable, this, userData);
            return;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Collection<StructureReader.StructureDescriptor> getStructures() {
        ClassLoader loader = VMData.class.getClassLoader();
        if (loader instanceof J9DDRClassLoader) {
            return ((J9DDRClassLoader)loader).getStructures();
        }
        throw new UnsupportedOperationException("This VMData wasn't loaded through a J9DDRClassLoader. Loaded by: " + loader + ", loader class: " + loader.getClass().getName());
    }

    @Override
    public String getVersion() {
        return version;
    }
}

