/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckClassLoaders
extends Check {
    CheckClassLoaders() {
    }

    @Override
    public void check() {
        try {
            GCClassLoaderIterator classLoaderIterator = GCClassLoaderIterator.from();
            while (classLoaderIterator.hasNext()) {
                PointerPointer slot;
                J9ClassLoaderPointer classLoader = classLoaderIterator.next();
                if (classLoader.gcFlags().allBitsIn(2L) || this._engine.checkSlotPool(slot = classLoader.classLoaderObjectEA(), VoidPointer.cast(classLoader)) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "CLASS LOADERS";
    }

    @Override
    public void print() {
        try {
            GCClassLoaderIterator classLoaderIterator = GCClassLoaderIterator.from();
            this.getReporter().println(String.format("<gc check: Start scan classLoaderBlocks (%s)>", ScanFormatter.formatPointer(this.getJavaVM().classLoaderBlocks())));
            while (classLoaderIterator.hasNext()) {
                J9ClassLoaderPointer classLoader = classLoaderIterator.next();
                this.getReporter().println(String.format("  <classLoader (%s)>", ScanFormatter.formatPointer(classLoader)));
                this.getReporter().println(String.format("    <flags=%d, classLoaderObject=%s>", classLoader.gcFlags().longValue(), ScanFormatter.formatPointer(classLoader.classLoaderObject())));
            }
            this.getReporter().println(String.format("<gc check: End scan classLoaderBlocks (%s)>", ScanFormatter.formatPointer(this.getJavaVM().classLoaderBlocks())));
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

