/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.Pool;
import com.ibm.j9ddr.vm26.j9.SlotIterator;
import com.ibm.j9ddr.vm26.j9.gc.GCIterator;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9MemorySpacePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_MemorySpacePointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9MemorySpaceHelper;

public class GCMemorySpaceIterator
extends GCIterator {
    protected SlotIterator<J9MemorySpacePointer> iterator;

    protected GCMemorySpaceIterator(J9PoolPointer memorySpaceList) throws CorruptDataException {
        this.iterator = Pool.fromJ9Pool(memorySpaceList, J9MemorySpacePointer.class).iterator();
    }

    public static GCMemorySpaceIterator from() throws CorruptDataException {
        return new GCMemorySpaceIterator(GCMemorySpaceIterator.getJavaVM().memorySpaceList());
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public MM_MemorySpacePointer next() {
        try {
            return J9MemorySpaceHelper.getMemorySpace((J9MemorySpacePointer)this.iterator.next());
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        return this.iterator.nextAddress();
    }
}

