/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm26.j9.VMConstantPool;
import com.ibm.j9ddr.vm26.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm26.pointer.generated.GC_ObjectModelPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm26.structure.J9VmconstantpoolConstants;

public class JavaLangClassLoaderHelper {
    private static J9ClassPointer classLoaderClass;
    private static J9ObjectFieldOffset vmRefOffset;
    private static J9ObjectFieldOffset parentOffset;

    public static J9ObjectPointer getParent(J9ObjectPointer loader) throws CorruptDataException {
        if (loader.isNull()) {
            return J9ObjectPointer.NULL;
        }
        if (classLoaderClass == null) {
            MM_GCExtensionsPointer extensions = GCExtensions.getGCExtensionsPointer();
            GC_ObjectModelPointer objectModel = extensions.objectModel();
            classLoaderClass = objectModel._classLoaderClass();
        }
        if (!J9ClassHelper.isSameOrSuperClassOf(classLoaderClass, J9ObjectHelper.clazz(loader))) {
            throw new IllegalArgumentException("J9Objects is not a class loader");
        }
        if (parentOffset == null) {
            parentOffset = VMConstantPool.getFieldOffset(J9VmconstantpoolConstants.J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_PARENT);
        }
        if (parentOffset != null) {
            return J9ObjectHelper.getObjectField(loader, parentOffset);
        }
        throw new CorruptDataException("Unable to find field offset for the 'parent' field");
    }

    public static J9ClassLoaderPointer getClassLoader(J9ObjectPointer loader) throws CorruptDataException {
        if (loader.isNull()) {
            return J9ClassLoaderPointer.NULL;
        }
        if (classLoaderClass == null) {
            MM_GCExtensionsPointer extensions = GCExtensions.getGCExtensionsPointer();
            GC_ObjectModelPointer objectModel = extensions.objectModel();
            classLoaderClass = objectModel._classLoaderClass();
        }
        if (!J9ClassHelper.isSameOrSuperClassOf(classLoaderClass, J9ObjectHelper.clazz(loader))) {
            throw new IllegalArgumentException("J9Objects is not a class loader");
        }
        if (vmRefOffset == null) {
            vmRefOffset = VMConstantPool.getFieldOffset(J9VmconstantpoolConstants.J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_VMREF);
        }
        if (vmRefOffset != null) {
            long address = J9ObjectHelper.getLongField(loader, vmRefOffset);
            return J9ClassLoaderPointer.cast(address);
        }
        throw new CorruptDataException("Unable to find field offset for the 'vmRef' field");
    }
}

