/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.AVLTree;
import com.ibm.j9ddr.vm26.j9.IAVLSearchComparator;
import com.ibm.j9ddr.vm26.pointer.IDATAPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9AVLTreeNodePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9AVLTreePointer;
import com.ibm.j9ddr.vm26.types.IDATA;
import com.ibm.j9ddr.vm26.types.UDATA;

class AVLTree_26_V0
extends AVLTree {
    private final J9AVLTreePointer _tree;
    private final IAVLSearchComparator _searchComparator;
    private static final long AVL_BALANCEMASK = 3L;

    AVLTree_26_V0(J9AVLTreePointer structure, IAVLSearchComparator comparator) {
        super(60, 0);
        this._tree = structure;
        this._searchComparator = comparator;
    }

    private J9AVLTreeNodePointer findNode(UDATA searchValue) throws CorruptDataException {
        int dir;
        J9AVLTreeNodePointer walk = this._tree.rootNode();
        while (walk.notNull() && 0 != (dir = this._searchComparator.searchComparator(this._tree, searchValue, walk))) {
            if (dir < 0) {
                walk = this.AVL_SRP_GETNODE(walk.leftChild(), walk.leftChildEA());
                continue;
            }
            walk = this.AVL_SRP_GETNODE(walk.rightChild(), walk.rightChildEA());
        }
        return walk;
    }

    private J9AVLTreeNodePointer AVL_SRP_GETNODE(IDATA srp, IDATAPointer srpEA) {
        return AVLTree_26_V0.AVL_GETNODE(srp).notNull() ? J9AVLTreeNodePointer.cast(srpEA.addOffset(IDATA.cast(AVLTree_26_V0.AVL_GETNODE(srp)))) : J9AVLTreeNodePointer.NULL;
    }

    private static J9AVLTreeNodePointer AVL_GETNODE(IDATA ptr) {
        return J9AVLTreeNodePointer.cast(new UDATA(ptr).bitAnd(-4L));
    }

    @Override
    public J9AVLTreeNodePointer search(UDATA searchValue) throws CorruptDataException {
        return this.findNode(searchValue);
    }
}

