/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.generated;

import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.StructurePointer;
import com.ibm.j9ddr.vm24.structure.PushType;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.UDATA;

@GeneratedPointerClass(structureClass=PushType.class)
public class PushTypePointer
extends StructurePointer {
    public static final PushTypePointer NULL = new PushTypePointer(0L);

    protected PushTypePointer(long address) {
        super(address);
    }

    public static PushTypePointer cast(AbstractPointer structure) {
        return PushTypePointer.cast(structure.getAddress());
    }

    public static PushTypePointer cast(UDATA udata) {
        return PushTypePointer.cast(udata.longValue());
    }

    public static PushTypePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new PushTypePointer(address);
    }

    @Override
    public PushTypePointer add(long count) {
        return PushTypePointer.cast(this.address + PushType.SIZEOF * count);
    }

    @Override
    public PushTypePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public PushTypePointer addOffset(long offset) {
        return PushTypePointer.cast(this.address + offset);
    }

    @Override
    public PushTypePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public PushTypePointer sub(long count) {
        return PushTypePointer.cast(this.address - PushType.SIZEOF * count);
    }

    @Override
    public PushTypePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public PushTypePointer subOffset(long offset) {
        return PushTypePointer.cast(this.address - offset);
    }

    @Override
    public PushTypePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public PushTypePointer untag(long mask) {
        return PushTypePointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public PushTypePointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return PushType.SIZEOF;
    }
}

