/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.j9.Pool;
import com.ibm.j9ddr.vm24.j9.SlotIterator;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.WideSelfRelativePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9PoolPuddlePointer;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.logging.Level;

public class Pool_24_V0<StructType extends DataType>
extends Pool<StructType>
implements SlotIterator<StructType> {
    private static int POOLSTATE_FOLLOW_NEXT_POINTERS = 1;
    private final boolean isInline;
    private final State state = new State();
    private VoidPointer nextItem = null;

    protected <T extends DataType> Pool_24_V0(J9PoolPointer structure, Class<T> structType, boolean isInline) throws CorruptDataException {
        super(structure, structType);
        this.isInline = isInline;
    }

    @Override
    public boolean includesElement(StructType anElement) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public SlotIterator<StructType> iterator() {
        try {
            this.nextItem = this.pool_startDo();
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error creating iterator", e, true);
            this.nextItem = null;
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null && this.nextItem.notNull();
    }

    @Override
    public StructType next() {
        if (this.hasNext()) {
            DataType next = null;
            try {
                if (!this.isInline) {
                    PointerPointer ptr = PointerPointer.cast(this.nextItem);
                    this.nextItem = ptr.at(0L);
                }
                next = (DataType)DataType.getStructure(this.structType.getSimpleName(), this.nextItem.getAddress());
                this.nextItem = this.pool_nextDo();
            }
            catch (CorruptDataException e) {
                this.nextItem = null;
                EventManager.raiseCorruptDataEvent("Error getting next pool item", e, true);
            }
            return (StructType)next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            try {
                VoidPointer next = this.nextItem;
                this.nextItem = this.pool_nextDo();
                return next;
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next pool item", e, true);
                this.nextItem = null;
                return null;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long numElements() {
        long numElements = 0L;
        try {
            if (this.pool.notNull()) {
                J9PoolPuddlePointer walk = this.pool.nextPuddle();
                while (walk.notNull()) {
                    numElements += walk.usedElements().longValue();
                    walk = walk.nextPuddle();
                }
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting number of pool elements", e, true);
        }
        return numElements;
    }

    @Override
    public long capacity() {
        long numElements = 0L;
        try {
            if (this.pool.notNull()) {
                J9PoolPuddlePointer walk = this.pool.nextPuddle();
                while (walk.notNull()) {
                    numElements += this.pool.numberOfElements().longValue();
                    walk = walk.nextPuddle();
                }
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting capacity of pool", e, true);
        }
        return numElements;
    }

    private VoidPointer pool_startDo() throws CorruptDataException {
        VoidPointer result = VoidPointer.NULL;
        if (this.pool.notNull()) {
            result = this.poolPuddle_startDo(this.pool.nextPuddle(), true);
        }
        return result;
    }

    private VoidPointer poolPuddle_startDo(J9PoolPuddlePointer currentPuddle, boolean followNextPointers) throws CorruptDataException {
        UDATAPointer currAddr = null;
        if (this.pool.isNull() || currentPuddle.isNull()) {
            return null;
        }
        if (currentPuddle.usedElements().longValue() == 0L) {
            if (currentPuddle.nextPuddle().notNull() && followNextPointers) {
                return this.poolPuddle_startDo(currentPuddle.nextPuddle(), followNextPointers);
            }
            return null;
        }
        long tmpInc = this.pool.elementSize().longValue();
        currAddr = UDATAPointer.cast(currentPuddle.firstElementAddress());
        ArrayList<UDATAPointer> freeList = this.freeListFromPuddle(currentPuddle);
        while (freeList.contains(currAddr)) {
            currAddr = currAddr.addOffset(tmpInc);
        }
        this.state.currentPuddle = currentPuddle;
        this.state.puddleFreeList = freeList;
        this.state.lastAddr = currAddr.addOffset(tmpInc);
        this.state.leftToDo = currentPuddle.usedElements().intValue() - 1;
        this.state.flags = 0;
        if (followNextPointers) {
            this.state.flags |= POOLSTATE_FOLLOW_NEXT_POINTERS;
        }
        if (this.state.leftToDo == 0) {
            this.state.currentPuddle = followNextPointers ? this.state.currentPuddle.nextPuddle() : null;
        }
        logger.fine(String.format("Next pool item 0x%016x", currAddr.getAddress()));
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.state.toString());
        }
        return VoidPointer.cast(currAddr);
    }

    private VoidPointer pool_nextDo() throws CorruptDataException {
        UDATAPointer currAddr = null;
        if (this.state.leftToDo == 0) {
            if (this.state.currentPuddle != null && this.state.currentPuddle.notNull()) {
                return this.poolPuddle_startDo(this.state.currentPuddle, true);
            }
            return null;
        }
        long tmpInc = this.pool.elementSize().longValue();
        currAddr = this.state.lastAddr;
        ArrayList<UDATAPointer> freeList = this.state.puddleFreeList;
        while (freeList.contains(currAddr)) {
            currAddr = currAddr.addOffset(tmpInc);
        }
        this.state.lastAddr = currAddr.addOffset(tmpInc);
        --this.state.leftToDo;
        if (this.state.leftToDo == 0) {
            this.state.currentPuddle = (this.state.flags & POOLSTATE_FOLLOW_NEXT_POINTERS) == POOLSTATE_FOLLOW_NEXT_POINTERS ? this.state.currentPuddle.nextPuddle() : null;
        }
        logger.fine(String.format("Next pool item 0x%016x", currAddr.getAddress()));
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.state.toString());
        }
        return VoidPointer.cast(currAddr);
    }

    private ArrayList<UDATAPointer> freeListFromPuddle(J9PoolPuddlePointer puddle) throws CorruptDataException {
        UDATAPointer freeAddr = puddle.firstFreeSlot();
        ArrayList<UDATAPointer> freeAddrList = new ArrayList<UDATAPointer>();
        while (freeAddr.notNull()) {
            freeAddrList.add(freeAddr);
            freeAddr = UDATAPointer.cast(WideSelfRelativePointer.cast(freeAddr).get());
        }
        return freeAddrList;
    }

    private class State {
        J9PoolPuddlePointer currentPuddle = null;
        ArrayList<UDATAPointer> puddleFreeList = null;
        UDATAPointer lastAddr = null;
        int leftToDo = 0;
        int flags = 0;

        private State() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Pool walker state\n\tCurrent Puddle : 0x");
            builder.append(Long.toHexString(this.currentPuddle.getAddress()));
            builder.append("\n\tLeft to do : ");
            builder.append(this.leftToDo);
            builder.append("\n\tFlags : ");
            builder.append(this.flags);
            return builder.toString();
        }
    }
}

