/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.OptionalValidity;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CertificateException;

public final class CertTemplate
extends CMPDerObject {
    private BigInteger version;
    private BigInteger serialNumber;
    private AlgorithmId signingAlg;
    private X500Name issuer;
    private OptionalValidity validity;
    private X500Name subject;
    private X509Key publicKey;
    private byte[] issuerUID;
    private byte[] subjectUID;
    private CertificateExtensions extensions;
    private static final byte TAG_VERSION = 0;
    private static final byte TAG_SERIAL_NUMBER = 1;
    private static final byte TAG_SIGNING_ALG = 2;
    private static final byte TAG_ISSUER = 3;
    private static final byte TAG_VALIDITY = 4;
    private static final byte TAG_SUBJECT = 5;
    private static final byte TAG_PUBLIC_KEY = 6;
    private static final byte TAG_ISSUER_UID = 7;
    private static final byte TAG_SUBJECT_UID = 8;
    private static final byte TAG_EXTENSIONS = 9;

    public CertTemplate() {
    }

    public CertTemplate(BigInteger bigInteger, BigInteger bigInteger2, AlgorithmId algorithmId, X500Name x500Name, OptionalValidity optionalValidity, X500Name x500Name2, PublicKey publicKey, byte[] byArray, byte[] byArray2, CertificateExtensions certificateExtensions) {
        this.version = bigInteger;
        this.serialNumber = bigInteger2;
        this.signingAlg = algorithmId;
        this.issuer = x500Name;
        this.validity = optionalValidity;
        this.subject = x500Name2;
        if (publicKey != null) {
            try {
                this.publicKey = new X509Key();
                byte[] byArray3 = publicKey.getEncoded();
                this.publicKey.decode(byArray3);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalArgumentException("Invalid public key.  The key must be in X.509 format.");
            }
        }
        this.issuerUID = byArray;
        this.subjectUID = byArray2;
        this.extensions = certificateExtensions;
    }

    public CertTemplate(byte[] byArray) throws IOException {
        super(byArray);
    }

    public void addExtension(Extension[] extensionArray) throws IOException {
        if (extensionArray == null || extensionArray.length == 0) {
            return;
        }
        if (this.extensions == null) {
            this.extensions = new CertificateExtensions();
        }
        int n = 0;
        while (n < extensionArray.length) {
            this.extensions.set(extensionArray[n].getExtensionId().toString(), (Object)extensionArray[n]);
            ++n;
        }
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new CertTemplate(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        DerValue derValue2 = null;
        if (derValue.getTag() != 48) {
            throw new IOException("CertTemplate parsing error, not a SEQUENCE");
        }
        this.version = null;
        this.serialNumber = null;
        this.signingAlg = null;
        this.issuer = null;
        this.validity = null;
        this.subject = null;
        this.publicKey = null;
        this.issuerUID = null;
        this.subjectUID = null;
        this.extensions = null;
        boolean bl = true;
        boolean bl2 = false;
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                return;
            }
        }
        if (!bl && derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
            derValue2.resetTag((byte)2);
            this.version = derValue2.getInteger();
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                return;
            }
        }
        if (!bl && derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
            derValue2.resetTag((byte)2);
            this.serialNumber = derValue2.getInteger();
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                return;
            }
        }
        if (!bl && derValue2.isContextSpecific((byte)2) && derValue2.isConstructed()) {
            derValue2.resetTag((byte)48);
            this.signingAlg = AlgorithmId.parse((DerValue)derValue2);
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                return;
            }
        }
        if (!bl && derValue2.isContextSpecific((byte)3) && derValue2.isConstructed()) {
            this.issuer = new X500Name(derValue2.getData().getDerValue());
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                return;
            }
        }
        if (!bl && derValue2.isContextSpecific((byte)4) && derValue2.isConstructed()) {
            derValue2.resetTag((byte)48);
            this.validity = new OptionalValidity(derValue2.toByteArray());
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                return;
            }
        }
        if (!bl && derValue2.isContextSpecific((byte)5) && derValue2.isConstructed()) {
            this.subject = new X500Name(derValue2.getData().getDerValue());
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                return;
            }
        }
        if (!bl && derValue2.isContextSpecific((byte)6) && derValue2.isConstructed()) {
            derValue2.resetTag((byte)48);
            try {
                PublicKey publicKey = X509Key.parse((DerValue)derValue2);
                this.publicKey = new X509Key();
                this.publicKey.decode(publicKey.getEncoded());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IOException("CertTemplate parsing error, error decoding public key; the key must be in X.509 format.");
            }
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                return;
            }
        }
        if (!bl && derValue2.isContextSpecific((byte)7) && !derValue2.isConstructed()) {
            derValue2.resetTag((byte)3);
            this.issuerUID = derValue2.getBitString();
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                return;
            }
        }
        if (!bl && derValue2.isContextSpecific((byte)8) && !derValue2.isConstructed()) {
            derValue2.resetTag((byte)3);
            this.subjectUID = derValue2.getBitString();
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                return;
            }
        }
        if (!bl && derValue2.isContextSpecific((byte)9) && derValue2.isConstructed()) {
            derValue2.resetTag((byte)48);
            this.extensions = new CertificateExtensions(new DerInputStream(derValue2.toByteArray()));
            bl = true;
        }
        if (!bl || derValue.getData().available() != 0) {
            throw new IOException("CertTemplate parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.version != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(this.version);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)0), derOutputStream);
        }
        if (this.serialNumber != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(this.serialNumber);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)1), derOutputStream);
        }
        if (this.signingAlg != null) {
            derOutputStream = new DerOutputStream();
            this.signingAlg.encode(derOutputStream);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream);
        }
        if (this.issuer != null) {
            derOutputStream = new DerOutputStream();
            this.issuer.encode(derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream);
        }
        if (this.validity != null) {
            derOutputStream = new DerOutputStream();
            this.validity.encode((OutputStream)derOutputStream);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)4), derOutputStream);
        }
        if (this.subject != null) {
            derOutputStream = new DerOutputStream();
            this.subject.encode(derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), derOutputStream);
        }
        if (this.publicKey != null) {
            derOutputStream = new DerOutputStream();
            try {
                derOutputStream.write(this.publicKey.encode());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IOException("Error encoding public key.");
            }
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)6), derOutputStream);
        }
        if (this.issuerUID != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putBitString(this.issuerUID);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)7), derOutputStream);
        }
        if (this.subjectUID != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putBitString(this.subjectUID);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)8), derOutputStream);
        }
        if (this.extensions != null) {
            derOutputStream = new DerOutputStream();
            try {
                this.extensions.encode((OutputStream)derOutputStream, true);
            }
            catch (CertificateException certificateException) {
                throw new IOException("CertTemplate encoding error, " + certificateException);
            }
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)9), derOutputStream);
        }
        derOutputStream3.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public boolean equals(CertTemplate certTemplate) {
        DerValue derValue;
        DerValue derValue2;
        if (certTemplate == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certTemplate.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CertTemplate) {
            return this.equals((CertTemplate)object);
        }
        return false;
    }

    public CertificateExtensions getExtensions() {
        if (this.extensions == null) {
            return null;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.extensions.encode((OutputStream)derOutputStream, true);
            DerInputStream derInputStream = new DerInputStream(derOutputStream.toByteArray());
            return new CertificateExtensions(derInputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    public X500Name getIssuer() {
        if (this.issuer == null) {
            return null;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.issuer.encode(derOutputStream);
            DerInputStream derInputStream = new DerInputStream(derOutputStream.toByteArray());
            return new X500Name(derInputStream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getIssuerUID() {
        if (this.issuerUID == null) {
            return null;
        }
        return (byte[])this.issuerUID.clone();
    }

    public PublicKey getPublicKey() throws InvalidKeyException, IOException {
        if (this.publicKey == null) {
            return null;
        }
        DerValue derValue = new DerValue(this.publicKey.getEncoded());
        return X509Key.parse((DerValue)derValue);
    }

    public BigInteger getSerialNumber() {
        if (this.serialNumber == null) {
            return null;
        }
        return new BigInteger(this.serialNumber.toByteArray());
    }

    public AlgorithmId getSigningAlg() {
        if (this.signingAlg == null) {
            return null;
        }
        try {
            return new AlgorithmId(this.signingAlg.getOID(), this.signingAlg.getParameters());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public X500Name getSubject() {
        if (this.subject == null) {
            return null;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.subject.encode(derOutputStream);
            DerInputStream derInputStream = new DerInputStream(derOutputStream.toByteArray());
            return new X500Name(derInputStream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getSubjectUID() {
        if (this.subjectUID == null) {
            return null;
        }
        return (byte[])this.subjectUID.clone();
    }

    public OptionalValidity getValidity() {
        if (this.validity == null) {
            return null;
        }
        return (OptionalValidity)this.validity.clone();
    }

    public BigInteger getVersion() {
        if (this.version == null) {
            return null;
        }
        return new BigInteger(this.version.toByteArray());
    }

    public void setExtensions(CertificateExtensions certificateExtensions) {
        this.extensions = certificateExtensions;
    }

    public void setIssuer(X500Name x500Name) {
        this.issuer = x500Name;
    }

    public void setIssuerUID(byte[] byArray) {
        this.issuerUID = byArray;
    }

    public void setPublicKey(PublicKey publicKey) {
        try {
            this.publicKey = new X509Key();
            byte[] byArray = publicKey.getEncoded();
            this.publicKey.decode(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("Invalid public key.  The key must be in X.509 format.");
        }
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.serialNumber = bigInteger;
    }

    public void setSigningAlg(AlgorithmId algorithmId) {
        this.signingAlg = algorithmId;
    }

    public void setSubject(X500Name x500Name) {
        this.subject = x500Name;
    }

    public void setSubjectUID(byte[] byArray) {
        this.subjectUID = byArray;
    }

    public void setValidity(OptionalValidity optionalValidity) {
        this.validity = optionalValidity;
    }

    public void setVersion(BigInteger bigInteger) {
        this.version = bigInteger;
    }

    public String toString() {
        String string = "CertTemplate:";
        if (this.version != null) {
            string = String.valueOf(string) + "\r\n\tversion: " + this.version.toString();
        }
        if (this.serialNumber != null) {
            string = String.valueOf(string) + "\r\n\tserial number: " + this.serialNumber.toString();
        }
        if (this.signingAlg != null) {
            string = String.valueOf(string) + "\r\n\tsigning algorithm: " + this.signingAlg.toString();
        }
        if (this.issuer != null) {
            string = String.valueOf(string) + "\r\n\tissuer: " + this.issuer.toString();
        }
        if (this.validity != null) {
            string = String.valueOf(string) + "\r\n\tvalidity: " + this.validity.toString();
        }
        if (this.subject != null) {
            string = String.valueOf(string) + "\r\n\tsubject: " + this.subject.toString();
        }
        if (this.publicKey != null) {
            string = String.valueOf(string) + "\r\n\tpublic key: " + this.publicKey.toString();
        }
        if (this.issuerUID != null) {
            string = String.valueOf(string) + "\r\n\tissuer UID: " + new String(this.issuerUID);
        }
        if (this.subjectUID != null) {
            string = String.valueOf(string) + "\r\n\tsubject UID: " + new String(this.subjectUID);
        }
        if (this.extensions != null) {
            string = String.valueOf(string) + "\r\n\textensions: " + this.extensions.toString();
        }
        return string;
    }
}

