/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CMP;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.EncryptedValue;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class RevPassphraseInfoValue
extends CMPDerObject
implements InfoValue,
Cloneable {
    private static final ObjectIdentifier oid = CMP.rev_passphrase_oid;
    private EncryptedValue value;
    private byte[] encodedValue;

    public RevPassphraseInfoValue(EncryptedValue encryptedValue) throws IOException {
        if (encryptedValue == null) {
            throw new IllegalArgumentException("RevPassphraseInfoValue error, encValue not specified");
        }
        this.value = (EncryptedValue)encryptedValue.clone();
        this.setEncodedValue();
    }

    public RevPassphraseInfoValue(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            return new RevPassphraseInfoValue(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        try {
            this.value = new EncryptedValue(derValue.toByteArray());
            this.setEncodedValue();
        }
        catch (Exception exception) {
            throw new IOException("RevPassphraseInfoValue decoding error, " + exception.toString());
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encodedValue);
    }

    public boolean equals(RevPassphraseInfoValue revPassphraseInfoValue) {
        DerValue derValue;
        DerValue derValue2;
        if (revPassphraseInfoValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            revPassphraseInfoValue.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof RevPassphraseInfoValue) {
            return this.equals((RevPassphraseInfoValue)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return (byte[])this.encodedValue.clone();
    }

    public String getName() {
        return "RevPassphrase";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        try {
            return new EncryptedValue(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setEncodedValue() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.value.encode((OutputStream)derOutputStream);
        this.encodedValue = derOutputStream.toByteArray();
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "RevPassphraseInfoValue:";
        string = String.valueOf(string) + "\r\nobject identifier: " + oid;
        string = String.valueOf(string) + "\r\ncertificate:\r\n";
        string = object == null ? String.valueOf(string) + "no cert" : String.valueOf(string) + object.toString();
        return string;
    }
}

