/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class InfoTypeAndValue
extends CMPDerObject {
    private InfoValue infoValue;
    private ObjectIdentifier oid;
    private Object value;
    private byte[] encodedValue;

    public InfoTypeAndValue(InfoValue infoValue) throws IOException {
        if (infoValue == null) {
            throw new IllegalArgumentException("InfoTypeAndValue error, infoVal not specified");
        }
        this.infoValue = infoValue;
        this.oid = infoValue.getObjectIdentifier();
        this.value = infoValue.getValue();
        this.encodedValue = infoValue.getEncodedValue();
    }

    public InfoTypeAndValue(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new InfoTypeAndValue(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("InfoTypeAndValue parsing error, not a SEQUENCE");
        }
        this.oid = derValue.getData().getOID();
        if (derValue.getData().available() == 0) {
            this.value = null;
            this.encodedValue = null;
            this.infoValue = null;
            return;
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.encodedValue = derValue2.toByteArray();
        if (derValue.getData().available() != 0) {
            throw new IOException("InfoTypeAndValue parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        if (this.encodedValue != null) {
            derOutputStream.write(this.encodedValue);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(InfoTypeAndValue infoTypeAndValue) {
        DerValue derValue;
        DerValue derValue2;
        if (infoTypeAndValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            infoTypeAndValue.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof InfoTypeAndValue) {
            return this.equals((InfoTypeAndValue)object);
        }
        return false;
    }

    public ObjectIdentifier getObjectIdentifier() {
        return this.oid;
    }

    public byte[] getValue() {
        if (this.encodedValue == null) {
            return null;
        }
        return (byte[])this.encodedValue.clone();
    }

    public String toString() {
        String string = "";
        if (this.infoValue != null) {
            string = String.valueOf(string) + this.infoValue.toString();
        } else {
            if (this.encodedValue == null) {
                string = String.valueOf(string) + "InfoTypeAndValue: null";
                return string;
            }
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            string = String.valueOf(string) + "InfoTypeAndValue:";
            string = String.valueOf(string) + "\r\nobject identifier: " + this.oid;
            string = String.valueOf(string) + "\r\nvalue: ";
            string = String.valueOf(string) + "\r\n";
            string = String.valueOf(string) + hexDumpEncoder.encode(this.encodedValue);
        }
        return string;
    }
}

