/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public final class AlgorithmIds
extends CMPDerObject {
    private AlgorithmId[] algids;

    public AlgorithmIds(byte[] byArray) throws IOException {
        super(byArray);
    }

    public AlgorithmIds(AlgorithmId[] algorithmIdArray) {
        if (algorithmIdArray == null) {
            throw new IllegalArgumentException("AlgorithmIds error, algids not specified");
        }
        if (algorithmIdArray.length == 0) {
            throw new IllegalArgumentException("AlgorithmIds error, there should be at least one AlgorithmId");
        }
        this.algids = algorithmIdArray;
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new AlgorithmIds(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void decode(DerValue var1_1) throws IOException {
        var2_2 = new Vector<AlgorithmId>();
        if (var1_1.getTag() == 48) ** GOTO lbl8
        throw new IOException("AlgorithmId parsing error, not a SEQUENCE OF");
lbl-1000:
        // 1 sources

        {
            var3_3 = var1_1.getData().getDerValue();
            var4_5 = new AlgorithmId(var3_3);
            var2_2.add(var4_5);
lbl8:
            // 2 sources

            ** while (var1_1.getData().available() != 0)
        }
lbl9:
        // 1 sources

        if (var2_2.size() > 0) {
            this.algids = new AlgorithmId[var2_2.size()];
            var3_4 = 0;
            while (var3_4 < var2_2.size()) {
                this.algids[var3_4] = (AlgorithmId)var2_2.elementAt(var3_4);
                ++var3_4;
            }
        } else {
            throw new IOException("AlgorithmIds parsing error, missing data");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.algids == null) {
            throw new IOException("AlgorithmIds encoding error, AlgorithmId not specified");
        }
        int n = 0;
        while (n < this.algids.length) {
            this.algids[n].encode(derOutputStream);
            ++n;
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(AlgorithmIds algorithmIds) {
        DerValue derValue;
        DerValue derValue2;
        if (algorithmIds == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            algorithmIds.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof AlgorithmIds) {
            return this.equals((AlgorithmIds)object);
        }
        return false;
    }

    public AlgorithmId[] getAlgorithmIds() {
        return (AlgorithmId[])this.algids.clone();
    }

    public String toString() {
        String string = "AlgorithmIds:\r";
        if (this.algids == null || this.algids.length == 0) {
            string = String.valueOf(string) + "\r\n\tNo algorithm identifier";
        } else {
            int n = 0;
            while (n < this.algids.length) {
                string = String.valueOf(string) + "\r\n\talgids[" + n + "]: " + this.algids[n];
                ++n;
            }
        }
        return string;
    }
}

