/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl;

import java.io.UnsupportedEncodingException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class ExternalClient
implements SaslClient {
    private byte[] username;
    private boolean completed = false;

    ExternalClient(String string) throws SaslException {
        if (string != null) {
            try {
                this.username = string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SaslException("Cannot convert " + string + " into UTF-8", unsupportedEncodingException);
            }
        } else {
            this.username = new byte[0];
        }
    }

    @Override
    public String getMechanismName() {
        return "EXTERNAL";
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public void dispose() throws SaslException {
    }

    @Override
    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("EXTERNAL authentication already completed");
        }
        this.completed = true;
        return this.username;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("EXTERNAL has no supported QOP");
        }
        throw new IllegalStateException("EXTERNAL authentication Not completed");
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("EXTERNAL has no supported QOP");
        }
        throw new IllegalStateException("EXTERNAL authentication not completed");
    }

    @Override
    public Object getNegotiatedProperty(String string) {
        if (this.completed) {
            return null;
        }
        throw new IllegalStateException("EXTERNAL authentication not completed");
    }
}

