/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import java.util.Enumeration;

public final class PrivateKeyUsageExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.PrivateKeyUsage";
    public static final String NAME = "PrivateKeyUsage";
    public static final String NOT_BEFORE = "not_before";
    public static final String NOT_AFTER = "not_after";
    private static final byte TAG_BEFORE = 0;
    private static final byte TAG_AFTER = 1;
    private Date notBefore = null;
    private Date notAfter = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.PrivateKeyUsageExtension";

    private void encodeThis() throws IOException {
        DerOutputStream tmp;
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.notBefore == null && this.notAfter == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream seq = new DerOutputStream();
        DerOutputStream tagged = new DerOutputStream();
        if (this.notBefore != null) {
            tmp = new DerOutputStream();
            tmp.putGeneralizedTime(this.notBefore);
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmp);
        }
        if (this.notAfter != null) {
            tmp = new DerOutputStream();
            tmp.putGeneralizedTime(this.notAfter);
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), tmp);
        }
        seq.write((byte)48, tagged);
        this.extensionValue = seq.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public PrivateKeyUsageExtension(Date notBefore, Date notAfter) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PrivateKeyUsageExtension", notBefore, notAfter);
        }
        this.notBefore = notBefore != null ? new Date(notBefore.getTime()) : notBefore;
        this.notAfter = notAfter != null ? new Date(notAfter.getTime()) : notAfter;
        this.extensionId = PKIXExtensions.PrivateKeyUsage_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "PrivateKeyUsageExtension");
        }
    }

    public PrivateKeyUsageExtension(Boolean critical, Object value) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PrivateKeyUsageExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.PrivateKeyUsage_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "PrivateKeyUsageExtension", "Illegal argument type");
            }
            throw new CertificateException("Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        DerInputStream str = new DerInputStream(extValue);
        DerValue[] seq = str.getSequence(2);
        for (int i = 0; i < seq.length; ++i) {
            DerValue opt = seq[i];
            if (opt.isContextSpecific((byte)0) && !opt.isConstructed()) {
                if (this.notBefore != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "PrivateKeyUsageExtension", "Duplicate notBefore in PrivateKeyUsage.");
                    }
                    throw new CertificateParsingException("Duplicate notBefore in PrivateKeyUsage.");
                }
                opt.resetTag((byte)24);
                str = new DerInputStream(opt.toByteArray());
                this.notBefore = str.getGeneralizedTime();
                continue;
            }
            if (opt.isContextSpecific((byte)1) && !opt.isConstructed()) {
                if (this.notAfter != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "PrivateKeyUsageExtension", "Duplicate notAfter in PrivateKeyUsage.");
                    }
                    throw new CertificateParsingException("Duplicate notAfter in PrivateKeyUsage.");
                }
                opt.resetTag((byte)24);
                str = new DerInputStream(opt.toByteArray());
                this.notAfter = str.getGeneralizedTime();
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "PrivateKeyUsageExtension", "Invalid encoding of PrivateKeyUsageExtension");
            }
            throw new IOException("Invalid encoding of PrivateKeyUsageExtension");
        }
        if (debug != null) {
            debug.exit(16384L, className, "PrivateKeyUsageExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", super.toString() + "PrivateKeyUsage: [\n" + (this.notBefore == null ? "" : "From: " + this.notBefore.toString() + ", ") + (this.notAfter == null ? "" : "To: " + this.notAfter.toString()) + "]\n");
        }
        return super.toString() + "PrivateKeyUsage: [\n" + (this.notBefore == null ? "" : "From: " + this.notBefore.toString() + ", ") + (this.notAfter == null ? "" : "To: " + this.notAfter.toString()) + "]\n";
    }

    public void valid() throws CertificateNotYetValidException, CertificateExpiredException {
        if (debug != null) {
            debug.entry(16384L, className, "valid");
        }
        Date now = new Date();
        this.valid(now);
        if (debug != null) {
            debug.exit(16384L, className, "valid");
        }
    }

    public void valid(Date now) throws CertificateNotYetValidException, CertificateExpiredException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "valid", now);
        }
        if (this.notBefore.after(now)) {
            if (debug != null) {
                debug.text(16384L, className, "valid", "NotBefore: " + this.notBefore.toString());
            }
            throw new CertificateNotYetValidException("NotBefore: " + this.notBefore.toString());
        }
        if (this.notAfter.before(now)) {
            if (debug != null) {
                debug.text(16384L, className, "valid", "NotAfter: " + this.notAfter.toString());
            }
            throw new CertificateExpiredException("NotAfter: " + this.notAfter.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "valid");
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PrivateKeyUsage_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream in) throws CertificateException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new CertificateException("Method not to be called directly.");
    }

    @Override
    public void set(String name, Object obj) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!(obj instanceof Date)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Date.");
            }
            throw new CertificateException("Attribute must be of type Date.");
        }
        if (name.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = new Date(((Date)obj).getTime());
        } else if (name.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = new Date(((Date)obj).getTime());
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
            }
            throw new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Date get(String name) throws CertificateException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(NOT_BEFORE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", new Date(this.notBefore.getTime()));
            }
            return new Date(this.notBefore.getTime());
        }
        if (name.equalsIgnoreCase(NOT_AFTER)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", new Date(this.notAfter.getTime()));
            }
            return new Date(this.notAfter.getTime());
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
        }
        throw new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
    }

    @Override
    public void delete(String name) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (name.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = null;
        } else if (name.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
            }
            throw new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(NOT_BEFORE);
        elements.addElement(NOT_AFTER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

