/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.Length;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import sun.security.util.ECKeySizeParameterSpec;

public final class KeyUtil {
    public static final int getKeySize(Key key) {
        Object pubk;
        int size = -1;
        if (key instanceof Length) {
            try {
                Length ruler = (Length)((Object)key);
                size = ruler.length();
            }
            catch (UnsupportedOperationException ruler) {
                // empty catch block
            }
            if (size >= 0) {
                return size;
            }
        }
        if (key instanceof SecretKey) {
            SecretKey sk = (SecretKey)key;
            String format = sk.getFormat();
            if ("RAW".equals(format) && sk.getEncoded() != null) {
                size = sk.getEncoded().length * 8;
            }
        } else if (key instanceof RSAKey) {
            pubk = (RSAKey)((Object)key);
            try {
                size = pubk.getModulus().bitLength();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        } else if (key instanceof ECKey) {
            pubk = (ECKey)((Object)key);
            size = pubk.getParams().getOrder().bitLength();
        } else if (key instanceof DSAKey) {
            pubk = (DSAKey)((Object)key);
            try {
                size = pubk.getParams().getP().bitLength();
            }
            catch (NullPointerException nullPointerException) {}
        } else if (key instanceof DHKey) {
            pubk = (DHKey)((Object)key);
            size = pubk.getParams().getP().bitLength();
        }
        return size;
    }

    public static final int getKeySize(AlgorithmParameters parameters) {
        String algorithm;
        switch (algorithm = parameters.getAlgorithm()) {
            case "EC": {
                AlgorithmParameterSpec ps2;
                try {
                    ps2 = parameters.getParameterSpec(ECKeySizeParameterSpec.class);
                    if (ps2 != null) {
                        return ((ECKeySizeParameterSpec)ps2).getKeySize();
                    }
                }
                catch (InvalidParameterSpecException ps2) {
                    // empty catch block
                }
                try {
                    ps2 = parameters.getParameterSpec(ECParameterSpec.class);
                    if (ps2 != null) {
                        return ((ECParameterSpec)ps2).getOrder().bitLength();
                    }
                }
                catch (InvalidParameterSpecException ps3) {}
                break;
            }
            case "DiffieHellman": {
                try {
                    DHParameterSpec ps = parameters.getParameterSpec(DHParameterSpec.class);
                    if (ps != null) {
                        return ps.getP().bitLength();
                    }
                    break;
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    public static final void validate(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("The key to be validated cannot be null");
        }
        if (key instanceof DHPublicKey) {
            KeyUtil.validateDHPublicKey((DHPublicKey)key);
        }
        if (key instanceof ECPublicKey) {
            KeyUtil.validateECPublicKey((ECPublicKey)key);
        }
    }

    public static final void validate(KeySpec keySpec) throws InvalidKeyException {
        if (keySpec == null) {
            throw new NullPointerException("The key spec to be validated cannot be null");
        }
        if (keySpec instanceof DHPublicKeySpec) {
            KeyUtil.validateDHPublicKey((DHPublicKeySpec)keySpec);
        }
        if (keySpec instanceof ECPublicKeySpec) {
            KeyUtil.validateECPublicKey((ECPublicKeySpec)keySpec);
        }
    }

    public static byte[] checkTlsPreMasterSecretKey(int clientVersion, int serverVersion, SecureRandom random, byte[] encoded, boolean isFailOver) throws NoSuchAlgorithmException {
        if (random == null) {
            random = SecureRandom.getInstance("SHA2DRBG");
        }
        byte[] replacer = new byte[48];
        random.nextBytes(replacer);
        if (!isFailOver && encoded != null) {
            if (encoded.length != 48) {
                return replacer;
            }
            int encodedVersion = (encoded[0] & 0xFF) << 8 | encoded[1] & 0xFF;
            if (clientVersion != encodedVersion && (clientVersion > 769 || serverVersion != encodedVersion)) {
                encoded = replacer;
            }
            return encoded;
        }
        return replacer;
    }

    private static void validateDHPublicKey(DHPublicKey publicKey) throws InvalidKeyException {
        DHParameterSpec paramSpec = publicKey.getParams();
        BigInteger p = paramSpec.getP();
        BigInteger g = paramSpec.getG();
        BigInteger y = publicKey.getY();
        KeyUtil.validateDHPublicKey(p, g, y);
    }

    private static void validateDHPublicKey(DHPublicKeySpec publicKeySpec) throws InvalidKeyException {
        KeyUtil.validateDHPublicKey(publicKeySpec.getP(), publicKeySpec.getG(), publicKeySpec.getY());
    }

    private static void validateDHPublicKey(BigInteger p, BigInteger g, BigInteger y) throws InvalidKeyException {
        BigInteger leftOpen = BigInteger.ONE;
        BigInteger rightOpen = p.subtract(BigInteger.ONE);
        if (y.compareTo(leftOpen) <= 0) {
            throw new InvalidKeyException("Diffie-Hellman public key is too small");
        }
        if (y.compareTo(rightOpen) >= 0) {
            throw new InvalidKeyException("Diffie-Hellman public key is too large");
        }
        BigInteger r = p.remainder(y);
        if (r.equals(BigInteger.ZERO)) {
            throw new InvalidKeyException("Invalid Diffie-Hellman parameters");
        }
    }

    private static void validateECPublicKey(ECPublicKey publicKey) throws InvalidKeyException {
        EllipticCurve curve = publicKey.getParams().getCurve();
        ECField field = curve.getField();
        BigInteger p = ((ECFieldFp)field).getP();
        BigInteger a = curve.getA();
        BigInteger b = curve.getB();
        ECPoint pointQ = publicKey.getW();
        BigInteger x = pointQ.getAffineX();
        BigInteger y = pointQ.getAffineY();
        KeyUtil.validateECPublicKey(p, a, b, x, y);
    }

    private static void validateECPublicKey(ECPublicKeySpec publicKeySpec) throws InvalidKeyException {
        EllipticCurve curve = publicKeySpec.getParams().getCurve();
        ECField field = curve.getField();
        BigInteger p = ((ECFieldFp)field).getP();
        BigInteger a = curve.getA();
        BigInteger b = curve.getB();
        ECPoint pointQ = publicKeySpec.getW();
        BigInteger x = pointQ.getAffineX();
        BigInteger y = pointQ.getAffineY();
        KeyUtil.validateECPublicKey(p, a, b, x, y);
    }

    private static void validateECPublicKey(BigInteger p, BigInteger a, BigInteger b, BigInteger x, BigInteger y) throws InvalidKeyException {
        if (x == null || y == null) {
            throw new InvalidKeyException("EC public key is infinity point");
        }
        if (x.compareTo(BigInteger.ZERO) <= -1 || x.compareTo(p) != -1 || y.compareTo(BigInteger.ZERO) <= -1 || y.compareTo(p) != -1) {
            throw new InvalidKeyException("EC public key has an incorrect ECPoint");
        }
        BigInteger left = y.multiply(y).mod(p);
        BigInteger right = x.multiply(x).multiply(x).add(a.multiply(x)).add(b).mod(p);
        if (!left.equals(right)) {
            throw new InvalidKeyException("EC public key is not on the elliptic curve");
        }
    }

    public static byte[] trimZeroes(byte[] b) {
        int i;
        for (i = 0; i < b.length - 1 && b[i] == 0; ++i) {
        }
        if (i == 0) {
            return b;
        }
        byte[] t = new byte[b.length - i];
        System.arraycopy(b, i, t, 0, t.length);
        return t;
    }
}

