/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.pkcs12.MacData;
import com.ibm.security.pkcs12.PKCS12PFX;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Vector;

public class parsePKCS12PFX {
    static final int CERT = 1;
    static final int KEY = 2;
    static final int PWD = 3;
    static final int MAC = 4;
    static final int INP = 5;

    public static void main(String[] argv) {
        int i = 0;
        int j = 0;
        String pfxFile = null;
        char[] hmacPwd = null;
        Vector<char[]> pwdV = new Vector<char[]>();
        String certFile = null;
        String keyFile = null;
        if (argv.length < 2) {
            parsePKCS12PFX.usage();
            System.exit(1);
        }
        try {
            String filename;
            MacData mac;
            int type = 1;
            while (i < argv.length) {
                String arg = argv[i];
                if (arg.equals("-c")) {
                    type = 1;
                    ++i;
                }
                if (arg.equals("-k")) {
                    type = 2;
                    ++i;
                }
                if (arg.equals("-p")) {
                    type = 3;
                    ++i;
                }
                if (arg.equals("-m")) {
                    type = 4;
                    ++i;
                }
                if (arg.equals("-f")) {
                    type = 5;
                    ++i;
                }
                switch (type) {
                    case 1: {
                        if (certFile != null) {
                            System.out.println("ERROR: Certificate has already been specified.");
                            parsePKCS12PFX.usage();
                            System.exit(1);
                        }
                        certFile = argv[i];
                        break;
                    }
                    case 2: {
                        if (keyFile != null) {
                            System.out.println("ERROR: Private key has already been specified.");
                            parsePKCS12PFX.usage();
                            System.exit(1);
                        }
                        keyFile = argv[i];
                        break;
                    }
                    case 3: {
                        System.out.println("adding " + argv[i] + " to pwd vector");
                        pwdV.addElement(argv[i].toCharArray());
                        break;
                    }
                    case 4: {
                        if (hmacPwd != null) {
                            System.out.println("ERROR: HMAC password has already been specified.");
                            parsePKCS12PFX.usage();
                            System.exit(1);
                        }
                        hmacPwd = argv[i].toCharArray();
                        break;
                    }
                    case 5: {
                        if (pfxFile != null) {
                            System.out.println("ERROR: PFX file has already been specified.");
                            parsePKCS12PFX.usage();
                            System.exit(1);
                        }
                        pfxFile = argv[i];
                    }
                }
                ++i;
            }
            if (pfxFile == null) {
                System.out.println("ERROR: PFX file must be specified!");
                parsePKCS12PFX.usage();
                System.exit(1);
            }
            System.out.println("Creating a PKCS #12 PFX from " + pfxFile);
            FileInputStream fis = new FileInputStream(pfxFile);
            byte[] data = new byte[fis.available()];
            fis.read(data);
            fis.close();
            PKCS12PFX pfx = new PKCS12PFX(data);
            X509CertImpl rcvrCert = null;
            PrivateKey rcvrKey = null;
            if (certFile != null) {
                System.out.println("Creating certificate from " + certFile);
                fis = new FileInputStream(certFile);
                rcvrCert = new X509CertImpl(fis);
            }
            if (keyFile != null) {
                System.out.println("Creating private key from " + keyFile);
                fis = new FileInputStream(keyFile);
                byte[] keyBytes = new byte[fis.available()];
                fis.read(keyBytes);
                rcvrKey = parsePKCS12PFX.convertPrivateKey(keyBytes);
            }
            if ((mac = pfx.getMacData()) != null) {
                System.out.println("Verifying HMAC.");
                if (pfx.verifyMac(hmacPwd)) {
                    System.out.println("HMAC is verified.");
                } else {
                    System.out.println("HMAC is not verified.");
                    System.exit(2);
                }
            } else if (pfx.hasDigitalSignature()) {
                System.out.println("Verifying digital signature.");
                if (pfx.verifySignature(rcvrCert)) {
                    System.out.println("Signature is verified.");
                } else {
                    System.out.println("Signature is not verified.");
                    System.exit(2);
                }
            }
            System.out.println("Getting all certificates.");
            Vector<Certificate> certV = new Vector<Certificate>();
            Certificate[] tmpCerts = null;
            Certificate[] certs = null;
            tmpCerts = pfx.getCertificates(null, null, null);
            if (tmpCerts != null) {
                System.out.println("Found " + tmpCerts.length + " unprotected certificates.");
                for (j = 0; j < tmpCerts.length; ++j) {
                    certV.addElement(tmpCerts[j]);
                }
            }
            if (pwdV.size() > 0) {
                for (i = 0; i < pwdV.size(); ++i) {
                    char[] pwd = (char[])pwdV.elementAt(i);
                    tmpCerts = pfx.getCertificates(pwd, null, null);
                    if (tmpCerts == null) continue;
                    System.out.println("Found " + tmpCerts.length + " password-protected certificates.");
                    for (j = 0; j < tmpCerts.length; ++j) {
                        certV.addElement(tmpCerts[j]);
                    }
                }
            }
            if (rcvrCert != null && rcvrKey != null && (tmpCerts = pfx.getCertificates(null, rcvrKey, rcvrCert)) != null) {
                System.out.println("Found " + tmpCerts.length + " pubkey-protected certificates.");
                for (j = 0; j < tmpCerts.length; ++j) {
                    certV.addElement(tmpCerts[j]);
                }
            }
            if (certV.size() > 0) {
                certs = new Certificate[certV.size()];
                for (i = 0; i < certV.size(); ++i) {
                    certs[i] = (Certificate)certV.elementAt(i);
                }
            }
            System.out.println("Getting all shrouded keys.");
            Vector<EncryptedPrivateKeyInfo> skeyV = new Vector<EncryptedPrivateKeyInfo>();
            EncryptedPrivateKeyInfo[] tmpSkeys = null;
            EncryptedPrivateKeyInfo[] skeys = null;
            tmpSkeys = pfx.getShroudedKeys(null, null, null);
            if (tmpSkeys != null) {
                System.out.println("Found " + tmpSkeys.length + " unprotected shrouded keys.");
                for (j = 0; j < tmpSkeys.length; ++j) {
                    skeyV.addElement(tmpSkeys[j]);
                }
            }
            if (pwdV.size() > 0) {
                for (i = 0; i < pwdV.size(); ++i) {
                    char[] pwd = (char[])pwdV.elementAt(i);
                    tmpSkeys = pfx.getShroudedKeys(pwd, null, null);
                    if (tmpSkeys == null) continue;
                    System.out.println("Found " + tmpSkeys.length + " password-protected shrouded keys.");
                    for (j = 0; j < tmpSkeys.length; ++j) {
                        skeyV.addElement(tmpSkeys[j]);
                    }
                }
            }
            if (rcvrCert != null && rcvrKey != null && (tmpSkeys = pfx.getShroudedKeys(null, rcvrKey, rcvrCert)) != null) {
                System.out.println("Found " + tmpSkeys.length + " pubkey-protected shrouded keys.");
                for (j = 0; j < tmpSkeys.length; ++j) {
                    skeyV.addElement(tmpSkeys[j]);
                }
            }
            if (skeyV.size() > 0) {
                skeys = new EncryptedPrivateKeyInfo[skeyV.size()];
                for (i = 0; i < skeyV.size(); ++i) {
                    skeys[i] = (EncryptedPrivateKeyInfo)skeyV.elementAt(i);
                }
            }
            System.out.println("Getting all private keys.");
            Vector<PrivateKeyInfo> keyV = new Vector<PrivateKeyInfo>();
            PrivateKeyInfo[] tmpKeys = null;
            PrivateKeyInfo[] keys = null;
            if (skeys != null) {
                System.out.println("Converting " + skeys.length + " shrouded keys to private keys.");
                for (i = 0; i < skeys.length; ++i) {
                    try {
                        byte[] keyBytes = skeys[i].decrypt(hmacPwd);
                        PrivateKeyInfo pkey = new PrivateKeyInfo(keyBytes);
                        keyV.addElement(pkey);
                        continue;
                    }
                    catch (Exception keyBytes) {
                        // empty catch block
                    }
                }
            }
            if ((tmpKeys = pfx.getPrivateKeys(null, null, null)) != null) {
                System.out.println("Found " + tmpKeys.length + " unprotected private keys.");
                for (j = 0; j < tmpKeys.length; ++j) {
                    keyV.addElement(tmpKeys[j]);
                }
            }
            if (pwdV.size() > 0) {
                for (i = 0; i < pwdV.size(); ++i) {
                    char[] pwd = (char[])pwdV.elementAt(i);
                    tmpKeys = pfx.getPrivateKeys(pwd, null, null);
                    if (tmpKeys == null) continue;
                    System.out.println("Found " + tmpKeys.length + " password-protected private keys.");
                    for (j = 0; j < tmpKeys.length; ++j) {
                        keyV.addElement(tmpKeys[j]);
                    }
                }
            }
            if (rcvrCert != null && rcvrKey != null && (tmpKeys = pfx.getPrivateKeys(null, rcvrKey, rcvrCert)) != null) {
                System.out.println("Found " + tmpKeys.length + " pubkey-protected private keys.");
                for (j = 0; j < tmpKeys.length; ++j) {
                    keyV.addElement(tmpKeys[j]);
                }
            }
            if (keyV.size() > 0) {
                keys = new PrivateKeyInfo[keyV.size()];
                for (i = 0; i < keyV.size(); ++i) {
                    keys[i] = (PrivateKeyInfo)keyV.elementAt(i);
                }
            }
            if (certs != null) {
                System.out.println("Found " + certs.length + " certificates.");
                for (i = 0; i < certs.length; ++i) {
                    filename = "p12pfx" + i + ".cer";
                    System.out.println("Writing certificate to " + filename);
                    byte[] certBytes = certs[i].getEncoded();
                    FileOutputStream fos = new FileOutputStream(filename);
                    fos.write(certBytes);
                    fos.close();
                }
            } else {
                System.out.println("Found no certificates.");
            }
            if (skeys != null) {
                System.out.println("Found " + skeys.length + " shrouded keys.");
                for (i = 0; i < skeys.length; ++i) {
                    filename = "p12pfx" + i + ".epri";
                    System.out.println("Writing shrouded key to " + filename);
                    skeys[i].write(filename, false);
                }
            } else {
                System.out.println("Found no shrouded keys.");
            }
            if (keys != null) {
                System.out.println("Found " + keys.length + " private keys.");
                for (i = 0; i < keys.length; ++i) {
                    filename = "p12pfx" + i + ".pri";
                    System.out.println("Writing private key to " + filename);
                    keys[i].write(filename, false);
                }
            } else {
                System.out.println("Found no private keys.");
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.toString());
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: parsePKCS12PFX -f PFX_file [-m mac_pwd] [-p pwd1 pwd2...]");
        System.out.println("                      [-c cf] [-k kf]");
        System.out.println("  where PFX_file is the PFX-containing file");
        System.out.println("        mac_pwd is the password used for data integrity");
        System.out.println("        -p is followed by one or more passwords to decrypt data with ");
        System.out.println("        -c is followed by a certificate file used to decrypt data ");
        System.out.println("           or verify a digital signature");
        System.out.println("        -k is followed by a private key file corresponding to the");
        System.out.println("           certificate's public key");
    }

    private static PrivateKey convertPrivateKey(byte[] bytes) throws PKCSException {
        PrivateKey privateKey = null;
        try {
            System.out.println("Trying to create the private key as a PKCS8EncodedKeySpec.");
            PKCS8EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            privateKey = factory.generatePrivate(keyspec);
        }
        catch (Exception e) {
            try {
                System.out.println("Trying to create the private key as a PrivateKeyInfo.");
                privateKey = new PrivateKeyInfo(bytes);
            }
            catch (Exception e2) {
                throw new PKCSException(e2, "Couldn't create private key.");
            }
        }
        if (privateKey == null) {
            throw new PKCSException("ERROR:  Could not create private key.");
        }
        return privateKey;
    }
}

