/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs12.CertBag;
import com.ibm.security.pkcs12.KeyBag;
import com.ibm.security.pkcs12.PKCS12PFX;
import com.ibm.security.pkcs12.SafeBag;
import com.ibm.security.pkcs12.ShroudedKeyBag;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Vector;

public class genPKCS12PFX {
    static final int CERT = 1;
    static final int KEY = 2;
    static final int SKEY = 3;
    static final int PWD = 4;
    static final int MAC = 5;

    public static void main(String[] argv) {
        String alg = "40BitRC2";
        char[] passwd = null;
        boolean noPwd = true;
        boolean noCerts = true;
        boolean noKeys = true;
        boolean noSkeys = true;
        boolean usePwdPrivacy = false;
        String outfile = "genPKCS12PFX.p12";
        HexDumpEncoder hd = new HexDumpEncoder();
        System.out.println("Creating PFX from input files.");
        Vector<String> certFiles = new Vector<String>();
        Vector<String> keyFiles = new Vector<String>();
        Vector<String> shroudedKeyFiles = new Vector<String>();
        if (argv.length < 4) {
            genPKCS12PFX.usage();
            System.exit(1);
        }
        try {
            String fName;
            PKCSAttribute[] attrs;
            SafeBag sb;
            PKCSDerObject bag;
            PKCSDerObject key;
            byte[] encoding;
            FileInputStream fis;
            String filename;
            String s;
            int i;
            X509CertImpl cert = null;
            int type = 1;
            block15: for (i = 0; i < argv.length; ++i) {
                String arg = argv[i];
                if (arg.equals("-c")) {
                    type = 1;
                    ++i;
                }
                if (arg.equals("-k")) {
                    type = 2;
                    ++i;
                }
                if (arg.equals("-s")) {
                    type = 3;
                    ++i;
                }
                if (arg.equals("-p")) {
                    type = 4;
                    ++i;
                }
                if (arg.equals("-m")) {
                    type = 5;
                    ++i;
                }
                switch (type) {
                    case 1: {
                        System.out.println("Adding " + argv[i] + " to cert files");
                        certFiles.add(argv[i]);
                        noCerts = false;
                        continue block15;
                    }
                    case 2: {
                        System.out.println("Adding " + argv[i] + " to key files");
                        keyFiles.add(argv[i]);
                        noKeys = false;
                        continue block15;
                    }
                    case 3: {
                        System.out.println("Adding " + argv[i] + " to shrouded key files");
                        shroudedKeyFiles.add(argv[i]);
                        noSkeys = false;
                        continue block15;
                    }
                    case 4: {
                        alg = argv[i];
                        String tmpAlg = "PBEWithSHAAnd" + alg;
                        System.out.println("Algorithm to protect PFX is " + tmpAlg);
                        usePwdPrivacy = true;
                        continue block15;
                    }
                    case 5: {
                        passwd = argv[i].toCharArray();
                        noPwd = false;
                        System.out.println("Using password \"" + argv[i] + "\" for PFX integrity and protection");
                    }
                }
            }
            if (usePwdPrivacy && noPwd) {
                System.out.println("ERROR: Password must be specified!");
                genPKCS12PFX.usage();
                System.exit(1);
            }
            if (noCerts && noKeys && noSkeys) {
                System.out.println("ERROR: Must specify at least one certificate, key or shrouded key file!");
                genPKCS12PFX.usage();
                System.exit(1);
            }
            System.out.print("Got the following cert files: ");
            for (i = 0; i < certFiles.size(); ++i) {
                s = (String)certFiles.elementAt(i);
                System.out.print(s + " ");
            }
            System.out.println("\r\n");
            System.out.print("Got the following key files: ");
            for (i = 0; i < keyFiles.size(); ++i) {
                s = (String)keyFiles.elementAt(i);
                System.out.print(s + " ");
            }
            System.out.println("\r\n");
            System.out.print("Got the following shrouded key files: ");
            for (i = 0; i < shroudedKeyFiles.size(); ++i) {
                s = (String)shroudedKeyFiles.elementAt(i);
                System.out.print(s + " ");
            }
            System.out.println("\r\n");
            Vector<CertBag> certBags = new Vector<CertBag>();
            Vector<KeyBag> keyBags = new Vector<KeyBag>();
            Vector<KeyBag> skeyBags = new Vector<KeyBag>();
            if (certFiles.size() > 0) {
                System.out.println("Creating CertBags");
            }
            for (i = 0; i < certFiles.size(); ++i) {
                filename = (String)certFiles.elementAt(i);
                try {
                    fis = new FileInputStream(filename);
                    cert = new X509CertImpl(fis);
                    CertBag bag2 = new CertBag(cert);
                    certBags.add(bag2);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Couldn't create CertBag from " + filename);
                    e.printStackTrace();
                }
            }
            if (keyFiles.size() > 0) {
                System.out.println("Creating KeyBags");
            }
            for (i = 0; i < keyFiles.size(); ++i) {
                filename = (String)keyFiles.elementAt(i);
                try {
                    fis = new FileInputStream(filename);
                    encoding = new byte[fis.available()];
                    fis.read(encoding);
                    key = new PrivateKeyInfo(encoding);
                    bag = new KeyBag((PrivateKeyInfo)key);
                    keyBags.add((KeyBag)bag);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Couldn't create KeyBag from " + filename);
                    e.printStackTrace();
                }
            }
            if (shroudedKeyFiles.size() > 0) {
                System.out.println("Creating ShroudedKeyBags");
            }
            for (i = 0; i < shroudedKeyFiles.size(); ++i) {
                filename = (String)shroudedKeyFiles.elementAt(i);
                try {
                    fis = new FileInputStream(filename);
                    encoding = new byte[fis.available()];
                    fis.read(encoding);
                    key = new EncryptedPrivateKeyInfo(encoding);
                    bag = new ShroudedKeyBag((EncryptedPrivateKeyInfo)key);
                    skeyBags.add((KeyBag)bag);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Couldn't create ShroudedKeyBag from " + filename);
                    e.printStackTrace();
                }
            }
            MessageDigest md = MessageDigest.getInstance("SHA1");
            PublicKey pubKey = ((Certificate)cert).getPublicKey();
            md.update(pubKey.getEncoded());
            byte[] keyId = md.digest();
            Vector<SafeBag> safeBags = new Vector<SafeBag>();
            for (i = 0; i < certBags.size(); ++i) {
                sb = new SafeBag((CertBag)certBags.elementAt(i), null);
                attrs = new PKCSAttribute[2];
                fName = "IBM test cert " + i;
                attrs[0] = new PKCSAttribute(PKCSOID.FRIENDLY_NAME_OID, (Object)fName);
                attrs[1] = new PKCSAttribute(PKCSOID.LOCAL_KEY_ID_OID, keyId);
                sb.addAttributes(attrs);
                safeBags.add(sb);
            }
            for (i = 0; i < keyBags.size(); ++i) {
                sb = new SafeBag((KeyBag)keyBags.elementAt(i), null);
                attrs = new PKCSAttribute[2];
                fName = "IBM test key " + i;
                attrs[0] = new PKCSAttribute(PKCSOID.FRIENDLY_NAME_OID, (Object)fName);
                attrs[1] = new PKCSAttribute(PKCSOID.LOCAL_KEY_ID_OID, keyId);
                sb.addAttributes(attrs);
                safeBags.add(sb);
            }
            for (i = 0; i < skeyBags.size(); ++i) {
                sb = new SafeBag((ShroudedKeyBag)skeyBags.elementAt(i), null);
                safeBags.add(sb);
            }
            PKCS12PFX pfx1 = new PKCS12PFX();
            for (i = 0; i < safeBags.size(); ++i) {
                SafeBag[] bags = new SafeBag[]{(SafeBag)safeBags.elementAt(i)};
                if (usePwdPrivacy) {
                    pfx1.addSafeBagsWithPasswordPrivacy(bags, alg, passwd);
                    continue;
                }
                pfx1.addSafeBags(bags);
            }
            if (noPwd) {
                System.out.println("No data integrity applied.");
            } else {
                System.out.println("Applying HMAC (password integrity)");
                pfx1.applyMac(passwd);
            }
            System.out.println("Writing PFX to file " + outfile);
            pfx1.write(outfile, false);
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.toString());
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: genPKCS12PFX [-m mac_pwd] [-c cf1 cf2...] [-k kf1 kf2...] [-s skf1 skf2...] [-p alg]");
        System.out.println("  where -m is followed by the HMAC password");
        System.out.println("        -c is followed by one or more cert files");
        System.out.println("        -k is followed by one or more key files");
        System.out.println("        -s is followed by one or more shrouded key files");
        System.out.println("        -p is followed by the algorithm used for bag privacy, e.g. 40BitRC2,");
        System.out.println("           128BitRC2, 40BitRC4, 128BitRC4, 2KeyTripleDES or 3KeyTripleDES.");
        System.out.println("           If not specified, no bag privacy is used.");
        System.out.println("  at least one of -c, -s or -k must be specified");
        System.out.println("  if -p is specified, then -m must be specified");
    }
}

