/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.rfc5915;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.Arrays;

public class ECPrivateKey
extends PKCSDerObject
implements PrivateKey {
    public static final BigInteger version_1 = BigInteger.ONE;
    protected byte[] key;
    protected ObjectIdentifier namedCurve;
    protected byte[] publicKey;
    private static final byte TAG_PARAMETERS_ATTRS = 0;
    private static final byte TAG_PUBLIC_KEY_ATTRS = 1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.rfc5915.ECPrivateKey";

    public ECPrivateKey(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ECPrivateKey", (Object)der);
            debug.exit(16384L, className, "ECPrivateKey");
        }
    }

    public ECPrivateKey(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "ECPrivateKey", der, provider);
            debug.exit(16384L, className, "ECPrivateKey");
        }
    }

    public ECPrivateKey(byte[] key, ObjectIdentifier namedCurve, byte[] publicKey) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{key, namedCurve, publicKey};
            debug.entry(16384L, (Object)className, "ECPrivateKey", parms);
        }
        this.key = (byte[])key.clone();
        this.namedCurve = namedCurve;
        byte[] byArray = this.publicKey = publicKey == null ? null : (byte[])publicKey.clone();
        if (debug != null) {
            debug.exit(16384L, className, "ECPrivateKey");
        }
    }

    public ECPrivateKey(byte[] key, ObjectIdentifier namedCurve, byte[] publicKey, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{key, namedCurve, publicKey, provider};
            debug.entry(16384L, (Object)className, "ECPrivateKey", parms);
        }
        this.key = (byte[])key.clone();
        this.namedCurve = namedCurve;
        byte[] byArray = this.publicKey = publicKey == null ? null : (byte[])publicKey.clone();
        if (debug != null) {
            debug.exit(16384L, className, "ECPrivateKey");
        }
    }

    public ECPrivateKey(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "ECPrivateKey", filename, new Boolean(base64));
            debug.exit(16384L, className, "ECPrivateKey");
        }
    }

    public ECPrivateKey(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "ECPrivateKey", parms);
            debug.exit(16384L, className, "ECPrivateKey");
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        DerOutputStream tmpout;
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        bytes.putInteger(version_1);
        if (this.key != null) {
            bytes.putOctetString(this.key);
        }
        if (this.namedCurve != null) {
            tmpout = new DerOutputStream();
            tmpout.putOID(this.namedCurve);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
        }
        if (this.publicKey != null) {
            tmpout = new DerOutputStream();
            tmpout.putBitString(this.publicKey);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), tmpout);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgorithm");
            debug.exit(16384L, (Object)className, "getAlgorithm", "EC");
        }
        return "EC";
    }

    @Override
    public synchronized byte[] getEncoded() {
        byte[] result;
        block4: {
            result = null;
            if (debug != null) {
                debug.entry(16384L, className, "getEncoded");
            }
            try {
                result = this.encode();
            }
            catch (IOException e) {
                if (debug == null) break block4;
                debug.exception(16384L, className, "getEncoded", e);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncoded", result);
        }
        return result;
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.entry(16384L, className, "getFormat");
            debug.exit(16384L, (Object)className, "getFormat", "ECPrivateKey");
        }
        return "ECPrivateKey";
    }

    public byte[] getKeyBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyBytes");
        }
        if (this.key == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getKeyBytes", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "getKeyBytes");
        }
        return (byte[])this.key.clone();
    }

    public ObjectIdentifier getNamedCurve() {
        if (debug != null) {
            debug.entry(16384L, className, "getNamedCurve");
            debug.exit(16384L, (Object)className, "getNamedCurve", this.namedCurve);
        }
        return this.namedCurve;
    }

    public byte[] getPublicKeyBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getPublicKeyBytes");
        }
        if (this.publicKey == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPublicKeyBytes", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "getPublicKeyBytes");
        }
        return (byte[])this.publicKey.clone();
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other instanceof ECPrivateKey) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((ECPrivateKey)other));
            }
            return this.equals((ECPrivateKey)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", false);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
    }

    @Override
    public int hashCode() {
        int retval = 0;
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        byte[] b1 = this.getEncoded();
        for (int i = 1; i < b1.length; ++i) {
            retval += b1[i] * i;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hashCode", retval);
        }
        return retval;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            ECPrivateKey retobj = new ECPrivateKey(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PrivateKey parsing error.");
            }
            throw new IOException("ECPrivateKey parsing error.");
        }
        DerInputStream myDerInputStream = encoding.getData();
        BigInteger version = myDerInputStream.getInteger();
        if (!version.equals(version_1)) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Version mismatch: (supported: " + version_1 + ", parsed: " + version);
            }
            throw new IOException("Version mismatch: (supported: " + version_1 + ", parsed: " + version);
        }
        this.key = myDerInputStream.getOctetString();
        while (myDerInputStream.available() != 0) {
            DerValue optionalData;
            DerValue value = myDerInputStream.getDerValue();
            if (value.isContextSpecific((byte)0)) {
                optionalData = new DerValue(value.getDataBytes());
                this.namedCurve = optionalData.getOID();
                continue;
            }
            if (value.isContextSpecific((byte)1)) {
                optionalData = new DerValue(value.getDataBytes());
                this.publicKey = optionalData.getBitString();
                continue;
            }
            throw new IOException("Unexpected value");
        }
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "writeObject", stream);
        }
        stream.write(this.getEncoded());
        if (debug != null) {
            debug.exit(8192L, className, "writeObject");
        }
    }

    private synchronized void readObject(ObjectInputStream stream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "readObject", stream);
        }
        if (stream == null) {
            if (debug != null) {
                debug.text(8192L, className, "readObject", "stream not specified.");
            }
            throw new IllegalArgumentException("stream not specified.");
        }
        try {
            DerValue der = new DerValue(stream);
            this.decode(der);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(8192L, className, "readObject", e);
            }
            throw new IOException("Deserialized key is invalid: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(8192L, className, "readObject");
        }
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(16384L, className, "finalize");
        }
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "finalize");
        }
    }

    private boolean equals(ECPrivateKey other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e);
                debug.exit(8192L, (Object)className, "equals_2", true);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

