/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.IssuerAndSerialNumber;
import com.ibm.security.pkcs7.RecipientInfo;
import com.ibm.security.pkcs7.SignerInfo;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class SignedAndEnvelopedData
extends Content
implements Cloneable {
    private static final byte TAG_CERTS = 0;
    private static final byte TAG_CRLS = 1;
    private BigInteger version;
    private RecipientInfo[] recipientInfos;
    private AlgorithmId[] digestAlgorithms;
    private EncryptedContentInfo encryptedContentInfo;
    private Certificate[] certs;
    private CRL[] crls;
    private SignerInfo[] signers;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.SignedAndEnvelopedData";
    private volatile int cachedHashVal = 0;

    public SignedAndEnvelopedData(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignedAndEnvelopedData", (Object)der);
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public SignedAndEnvelopedData(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "SignedAndEnvelopedData", der, provider);
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public SignedAndEnvelopedData(RecipientInfo[] recipientInfos, AlgorithmId[] digestAlgorithms, EncryptedContentInfo encryptedContentInfo, X509Certificate[] certsIn, X509CRL[] crlsIn, SignerInfo[] signersIn) {
        if (debug != null) {
            Object[] parms = new Object[]{recipientInfos, digestAlgorithms, encryptedContentInfo, certsIn, crlsIn, signersIn};
            debug.entry(16384L, (Object)className, "SignedAndEnvelopedData", parms);
        }
        this.recipientInfos = recipientInfos;
        this.digestAlgorithms = digestAlgorithms;
        this.encryptedContentInfo = encryptedContentInfo;
        this.certs = certsIn;
        this.crls = crlsIn;
        this.signers = signersIn;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public SignedAndEnvelopedData(RecipientInfo[] recipientInfos, AlgorithmId[] digestAlgorithms, EncryptedContentInfo encryptedContentInfo, X509Certificate[] certsIn, X509CRL[] crlsIn, SignerInfo[] signersIn, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{recipientInfos, digestAlgorithms, encryptedContentInfo, certsIn, crlsIn, signersIn, provider};
            debug.entry(16384L, (Object)className, "SignedAndEnvelopedData", parms);
        }
        this.recipientInfos = recipientInfos;
        this.digestAlgorithms = digestAlgorithms;
        this.encryptedContentInfo = encryptedContentInfo;
        this.certs = certsIn;
        this.crls = crlsIn;
        this.signers = signersIn;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public SignedAndEnvelopedData(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "SignedAndEnvelopedData", filename, new Boolean(base64));
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public SignedAndEnvelopedData(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "SignedAndEnvelopedData", parms);
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SignedAndEnvelopedData result = new SignedAndEnvelopedData(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.SIGNED_AND_ENVELOPED_DATA_OID);
        }
        return PKCSOID.SIGNED_AND_ENVELOPED_DATA_OID;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public RecipientInfo[] getRecipientInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getRecipientInfos");
        }
        if (this.recipientInfos == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfos", null);
            }
            return null;
        }
        RecipientInfo[] result = (RecipientInfo[])this.recipientInfos.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRecipientInfos", result);
        }
        return result;
    }

    public AlgorithmId[] getDigestAlgorithms() {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithms");
        }
        if (this.digestAlgorithms == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithms", null);
            }
            return null;
        }
        AlgorithmId[] result = (AlgorithmId[])this.digestAlgorithms.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithms", result);
        }
        return result;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedContentInfo");
        }
        if (this.encryptedContentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncryptedContentInfo", null);
            }
            return null;
        }
        EncryptedContentInfo result = (EncryptedContentInfo)this.encryptedContentInfo.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptedContentInfo", result);
        }
        return result;
    }

    public Certificate[] getCertificates() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificates");
        }
        if (this.certs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificates", null);
            }
            return null;
        }
        Certificate[] result = (Certificate[])this.certs.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificates", result);
        }
        return result;
    }

    public CRL[] getCRLs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCRLs");
        }
        if (this.crls == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCRLs", null);
            }
            return null;
        }
        CRL[] result = (CRL[])this.crls.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCRLs", result);
        }
        return result;
    }

    public SignerInfo[] getSignerInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignerInfos");
        }
        SignerInfo[] result = null;
        if (this.signers != null) {
            result = (SignerInfo[])this.signers.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignerInfos", result);
        }
        return result;
    }

    public SignerInfo getSignerInfo(Certificate cert) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSignerInfo", cert);
        }
        if (this.signers == null || cert == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignerInfo_1", null);
            }
            return null;
        }
        for (int i = 0; i < this.signers.length; ++i) {
            if (!this.signers[i].hasCertificate(cert)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignerInfo_2", this.signers[i].clone());
            }
            return (SignerInfo)this.signers[i].clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignerInfo", null);
        }
        return null;
    }

    public Certificate getCertificate(IssuerAndSerialNumber issuer) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getCertificate", issuer);
        }
        if (this.certs == null || issuer == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificate_1", null);
            }
            return null;
        }
        for (int i = 0; i < this.certs.length; ++i) {
            BigInteger sn;
            X509Certificate x509cert = (X509Certificate)this.certs[i];
            Principal princ = x509cert.getIssuerDN();
            X500Name xname = new X500Name(princ.getName());
            if (!xname.equals(issuer.getIssuer()) || (sn = x509cert.getSerialNumber()).equals(issuer.getSerialNumber())) continue;
            try {
                byte[] bytes = this.certs[i].getEncoded();
                X509CertImpl result = new X509CertImpl(bytes);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getCertificate_1", result);
                }
                return result;
            }
            catch (CertificateException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "getCertificate", e);
                }
                throw new IOException(e.toString());
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificate", null);
        }
        return null;
    }

    public boolean hasCertificate(Certificate cert) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasCertificate", cert);
        }
        boolean result = false;
        if (this.certs != null && cert != null) {
            for (int i = 0; i < this.certs.length; ++i) {
                if (!cert.equals(this.certs[i])) continue;
                result = true;
                break;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCertificate", result);
        }
        return result;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        int i;
        DerEncoder[] temps;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(this.version);
        if (this.recipientInfos != null && this.recipientInfos.length > 0) {
            temps = new DerOutputStream[this.recipientInfos.length];
            for (i = 0; i < this.recipientInfos.length; ++i) {
                temps[i] = new DerOutputStream();
                this.recipientInfos[i].encode((OutputStream)((Object)temps[i]));
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding recipientInfos.");
            }
            throw new IOException("Error encoding recipientInfos.");
        }
        bytes.putOrderedSetOf((byte)49, temps);
        if (this.digestAlgorithms != null && this.digestAlgorithms.length > 0) {
            temps = new DerOutputStream[this.digestAlgorithms.length];
            for (i = 0; i < this.digestAlgorithms.length; ++i) {
                temps[i] = new DerOutputStream();
                this.digestAlgorithms[i].encode((DerOutputStream)temps[i]);
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding digest algorithms.");
            }
            throw new IOException("Error encoding digest algorithms.");
        }
        bytes.putOrderedSetOf((byte)49, temps);
        this.encryptedContentInfo.encode(bytes);
        try {
            if (this.certs != null && this.certs.length > 0) {
                temps = new DerOutputStream[this.certs.length];
                for (i = 0; i < this.certs.length; ++i) {
                    if (!(this.certs[i] instanceof X509Certificate)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element certs[" + i + "] has a type of " + this.certs[i].getClass().getName() + ".  Only instances of java.security.cert.X509Certificate are supported.");
                        }
                        throw new IOException("Element certs[" + i + "] has a type of " + this.certs[i].getClass().getName() + ".  Only instances of java.security.cert.X509Certificate are supported.");
                    }
                    temps[i] = new DerOutputStream();
                    ((OutputStream)((Object)temps[i])).write(this.certs[i].getEncoded());
                }
                DerOutputStream tmpout = new DerOutputStream();
                tmpout.putOrderedSetOf((byte)49, temps);
                bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
            }
        }
        catch (CertificateEncodingException e) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding certificates.  " + e.toString());
            }
            throw new IOException("Error encoding certificates.  " + e.toString());
        }
        try {
            if (this.crls != null && this.crls.length > 0) {
                temps = new DerOutputStream[this.crls.length];
                for (int i2 = 0; i2 < this.crls.length; ++i2) {
                    if (!(this.crls[i2] instanceof X509CRL)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element crls[" + i2 + "] has a type of " + this.crls[i2].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                        }
                        throw new IOException("Element crls[" + i2 + "] has a type of " + this.crls[i2].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                    }
                    temps[i2] = new DerOutputStream();
                    X509CRL x509crl = (X509CRL)this.crls[i2];
                    ((OutputStream)((Object)temps[i2])).write(x509crl.getEncoded());
                }
                DerOutputStream tmpout = new DerOutputStream();
                tmpout.putOrderedSetOf((byte)49, temps);
                bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmpout);
            }
        }
        catch (CRLException e) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding crls.  " + e.toString());
            }
            throw new IOException("Error encoding crls.  " + e.toString());
        }
        if (this.signers != null && this.signers.length > 0) {
            temps = new DerOutputStream[this.signers.length];
            for (int i3 = 0; i3 < this.signers.length; ++i3) {
                temps[i3] = new DerOutputStream();
                this.signers[i3].encode((OutputStream)((Object)temps[i3]));
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encode", "error encoding signer information");
            }
            throw new IOException("error encoding signer information");
        }
        bytes.putOrderedSetOf((byte)49, temps);
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (SignedAndEnvelopedData.debug != null) {
            SignedAndEnvelopedData.debug.entry(16384L, (Object)SignedAndEnvelopedData.className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (SignedAndEnvelopedData.debug != null) {
                SignedAndEnvelopedData.debug.text(16384L, SignedAndEnvelopedData.className, "decode", "SignedData parsing error");
            }
            throw new IOException("SignedData parsing error");
        }
        this.version = encoding.getData().getInteger();
        rders = encoding.getData().getSet(1);
        this.recipientInfos = new RecipientInfo[rders.length];
        for (i = 0; i < rders.length; ++i) {
            this.recipientInfos[i] = new RecipientInfo(rders[i].toByteArray(), this.provider);
        }
        ders = encoding.getData().getSet(1);
        this.digestAlgorithms = new AlgorithmId[ders.length];
        for (i = 0; i < ders.length; ++i) {
            this.digestAlgorithms[i] = AlgorithmId.parse(ders[i]);
        }
        opt = encoding.getData().getDerValue();
        this.encryptedContentInfo = new EncryptedContentInfo(opt.toByteArray(), this.provider);
lbl20:
        // 3 sources

        try {
            while (encoding.getData().available() != 0) {
                block17: {
                    block16: {
                        opt = encoding.getData().getDerValue();
                        if (!opt.isContextSpecific((byte)0) || !opt.isConstructed()) break block16;
                        derin = new DerInputStream(opt.toByteArray());
                        ders = derin.getSet(1, true);
                        this.certs = new X509Certificate[ders.length];
                        for (i = 0; i < ders.length; ++i) {
                            this.certs[i] = new X509CertImpl(ders[i].toByteArray());
                        }
                        ** GOTO lbl20
                    }
                    if (!opt.isContextSpecific((byte)1) || !opt.isConstructed()) break block17;
                    derin = new DerInputStream(opt.toByteArray());
                    ders = derin.getSet(1, true);
                    this.crls = new X509CRL[ders.length];
                    for (i = 0; i < ders.length; ++i) {
                        this.crls[i] = new X509CRLImpl(ders[i].toByteArray());
                    }
                    ** GOTO lbl20
                }
                if (opt.getTag() == 49) break;
                if (SignedAndEnvelopedData.debug != null) {
                    SignedAndEnvelopedData.debug.text(16384L, SignedAndEnvelopedData.className, "decode", "error decoding SignedData");
                }
                throw new IOException("error decoding SignedData");
            }
        }
        catch (CertificateException e) {
            if (SignedAndEnvelopedData.debug != null) {
                SignedAndEnvelopedData.debug.exception(16384L, SignedAndEnvelopedData.className, "decode", e);
                SignedAndEnvelopedData.debug.text(16384L, SignedAndEnvelopedData.className, "decode", "error decoding certificates");
            }
            throw new IOException("error decoding certificates");
        }
        catch (CRLException e2) {
            if (SignedAndEnvelopedData.debug != null) {
                SignedAndEnvelopedData.debug.exception(16384L, SignedAndEnvelopedData.className, "decode", e2);
                SignedAndEnvelopedData.debug.text(16384L, SignedAndEnvelopedData.className, "decode", "error decoding crls");
            }
            throw new IOException("error decoding crls");
        }
        derin = new DerInputStream(opt.toByteArray());
        ders = derin.getSet(1, true);
        this.signers = new SignerInfo[ders.length];
        for (i = 0; i < ders.length; ++i) {
            this.signers[i] = new SignerInfo(ders[i].toByteArray(), this.provider);
        }
        if (SignedAndEnvelopedData.debug != null) {
            SignedAndEnvelopedData.debug.exit(16384L, SignedAndEnvelopedData.className, "decode");
        }
    }

    @Override
    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof SignedAndEnvelopedData)) {
            boolean result = this.equals((SignedAndEnvelopedData)other);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(result));
            }
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((SignedAndEnvelopedData)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public String toString() {
        int i;
        String out = "";
        out = out + "\tversion; " + this.version.intValue();
        out = out + "\r\n\trecipientInfos: ";
        for (i = 0; i < this.recipientInfos.length; ++i) {
            out = out + "\r\n\t" + this.recipientInfos[i];
        }
        out = out + "\r\n\tdigestAlgorithms: ";
        for (i = 0; i < this.digestAlgorithms.length; ++i) {
            out = out + "\r\n\t" + this.digestAlgorithms[i];
        }
        out = out + "\r\n\tencrypted content info: \n";
        out = out + this.encryptedContentInfo;
        out = out + "\tcertificates: ";
        if (this.certs == null || this.certs.length == 0) {
            out = out + "null";
        } else {
            for (i = 0; i < this.certs.length; ++i) {
                out = out + "\r\n\t" + this.certs[i];
            }
        }
        out = out + "\r\n\tcertificate revocation lists: ";
        if (this.crls == null || this.crls.length == 0) {
            out = out + "null";
        } else {
            for (i = 0; i < this.crls.length; ++i) {
                out = out + "\r\n\t" + this.crls[i];
            }
        }
        out = out + "\r\n\tsigners: ";
        for (i = 0; i < this.signers.length; ++i) {
            out = out + "\r\n\t" + this.signers[i];
        }
        return out;
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "calculateVersion");
        }
        this.version = BigInteger.ONE;
        if (debug != null) {
            debug.exit(8192L, className, "calculateVersion");
        }
    }
}

