/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.security.pkcs7.ParsingException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;

public class ContentInfoOracle {
    private static int[] pkcs7 = new int[]{1, 2, 840, 113549, 1, 7};
    private static int[] data = new int[]{1, 2, 840, 113549, 1, 7, 1};
    private static int[] sdata = new int[]{1, 2, 840, 113549, 1, 7, 2};
    private static int[] edata = new int[]{1, 2, 840, 113549, 1, 7, 3};
    private static int[] sedata = new int[]{1, 2, 840, 113549, 1, 7, 4};
    private static int[] ddata = new int[]{1, 2, 840, 113549, 1, 7, 5};
    private static int[] crdata = new int[]{1, 2, 840, 113549, 1, 7, 6};
    private static int[] nsdata = new int[]{2, 16, 840, 1, 113730, 2, 5};
    private static int[] tstInfo = new int[]{1, 2, 840, 113549, 1, 9, 16, 1, 4};
    private static final int[] OLD_SDATA = new int[]{1, 2, 840, 1113549, 1, 7, 2};
    private static final int[] OLD_DATA = new int[]{1, 2, 840, 1113549, 1, 7, 1};
    public static ObjectIdentifier PKCS7_OID = ObjectIdentifier.newInternal(pkcs7);
    public static ObjectIdentifier DATA_OID = ObjectIdentifier.newInternal(data);
    public static ObjectIdentifier SIGNED_DATA_OID = ObjectIdentifier.newInternal(sdata);
    public static ObjectIdentifier ENVELOPED_DATA_OID = ObjectIdentifier.newInternal(edata);
    public static ObjectIdentifier SIGNED_AND_ENVELOPED_DATA_OID = ObjectIdentifier.newInternal(sedata);
    public static ObjectIdentifier DIGESTED_DATA_OID = ObjectIdentifier.newInternal(ddata);
    public static ObjectIdentifier ENCRYPTED_DATA_OID = ObjectIdentifier.newInternal(crdata);
    public static ObjectIdentifier OLD_SIGNED_DATA_OID = ObjectIdentifier.newInternal(OLD_SDATA);
    public static ObjectIdentifier OLD_DATA_OID = ObjectIdentifier.newInternal(OLD_DATA);
    public static ObjectIdentifier NETSCAPE_CERT_SEQUENCE_OID = ObjectIdentifier.newInternal(nsdata);
    public static ObjectIdentifier TIMESTAMP_TOKEN_INFO_OID = ObjectIdentifier.newInternal(tstInfo);
    ObjectIdentifier contentType;
    DerValue content;

    public ContentInfoOracle(ObjectIdentifier contentType, DerValue content) {
        this.contentType = contentType;
        this.content = content;
    }

    public ContentInfoOracle(byte[] bytes) {
        DerValue octetString = new DerValue(4, bytes);
        this.contentType = DATA_OID;
        this.content = octetString;
    }

    public ContentInfoOracle(DerInputStream derin) throws IOException, ParsingException {
        this(derin, false);
    }

    public ContentInfoOracle(DerInputStream derin, boolean oldStyle) throws IOException, ParsingException {
        DerValue[] typeAndContent = derin.getSequence(2);
        if (typeAndContent.length < 1 || typeAndContent.length > 2) {
            throw new ParsingException("Invalid length for ContentInfo");
        }
        DerValue type = typeAndContent[0];
        DerInputStream disType = new DerInputStream(type.toByteArray());
        this.contentType = disType.getOID();
        if (oldStyle) {
            if (typeAndContent.length > 1) {
                this.content = typeAndContent[1];
            }
        } else if (typeAndContent.length > 1) {
            DerValue taggedContent = typeAndContent[1];
            DerInputStream disTaggedContent = new DerInputStream(taggedContent.toByteArray());
            DerValue[] contents = disTaggedContent.getSet(1, true);
            if (contents.length != 1) {
                throw new ParsingException("ContentInfo encoding error");
            }
            this.content = contents[0];
        }
    }

    public DerValue getContent() {
        return this.content;
    }

    public ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public byte[] getData() throws IOException {
        if (this.contentType.equals((Object)DATA_OID) || this.contentType.equals((Object)OLD_DATA_OID) || this.contentType.equals((Object)TIMESTAMP_TOKEN_INFO_OID)) {
            if (this.content == null) {
                return null;
            }
            return this.content.getOctetString();
        }
        throw new IOException("content type is not DATA: " + this.contentType);
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream seq = new DerOutputStream();
        seq.putOID(this.contentType);
        if (this.content != null) {
            DerValue taggedContent = null;
            DerOutputStream contentDerCode = new DerOutputStream();
            this.content.encode(contentDerCode);
            taggedContent = new DerValue(-96, contentDerCode.toByteArray());
            seq.putDerValue(taggedContent);
        }
        out.write((byte)48, seq);
    }

    public byte[] getContentBytes() throws IOException {
        if (this.content == null) {
            return null;
        }
        DerInputStream dis = new DerInputStream(this.content.toByteArray());
        return dis.getOctetString();
    }

    public String toString() {
        String out = "";
        out = out + "Content Info Sequence\n\tContent type: " + this.contentType + "\n";
        out = out + "\tContent: " + this.content;
        return out;
    }
}

