/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.security.pkcs7.ParsingException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;

public final class MacDataOracle {
    private String digestAlgorithmName;
    private byte[] digest;
    private byte[] macSalt;
    private int iterations;
    private byte[] encoded = null;

    public MacDataOracle(DerInputStream derin) throws IOException, ParsingException {
        DerValue[] macData = derin.getSequence(2);
        DerInputStream digestIn = new DerInputStream(macData[0].toByteArray());
        DerValue[] digestInfo = digestIn.getSequence(2);
        AlgorithmId digestAlgorithmId = AlgorithmId.parse(digestInfo[0]);
        this.digestAlgorithmName = digestAlgorithmId.getName();
        this.digest = digestInfo[1].getOctetString();
        this.macSalt = macData[1].getOctetString();
        this.iterations = macData.length > 2 ? macData[2].getInteger().intValue() : 1;
    }

    public MacDataOracle(String algName, byte[] digest, byte[] salt, int iterations) throws NoSuchAlgorithmException {
        if (algName == null) {
            throw new NullPointerException("the algName parameter must be non-null");
        }
        AlgorithmId algid = AlgorithmId.get(algName);
        this.digestAlgorithmName = algid.getName();
        if (digest == null) {
            throw new NullPointerException("the digest parameter must be non-null");
        }
        if (digest.length == 0) {
            throw new IllegalArgumentException("the digest parameter must not be empty");
        }
        this.digest = (byte[])digest.clone();
        this.macSalt = salt;
        this.iterations = iterations;
        this.encoded = null;
    }

    public MacDataOracle(AlgorithmParameters algParams, byte[] digest, byte[] salt, int iterations) throws NoSuchAlgorithmException {
        if (algParams == null) {
            throw new NullPointerException("the algParams parameter must be non-null");
        }
        AlgorithmId algid = AlgorithmId.get(algParams);
        this.digestAlgorithmName = algid.getName();
        if (digest == null) {
            throw new NullPointerException("the digest parameter must be non-null");
        }
        if (digest.length == 0) {
            throw new IllegalArgumentException("the digest parameter must not be empty");
        }
        this.digest = (byte[])digest.clone();
        this.macSalt = salt;
        this.iterations = iterations;
        this.encoded = null;
    }

    public String getDigestAlgName() {
        return this.digestAlgorithmName;
    }

    public byte[] getSalt() {
        return this.macSalt;
    }

    public int getIterations() {
        return this.iterations;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public byte[] getEncoded() throws NoSuchAlgorithmException, IOException {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        DerOutputStream out = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        DerOutputStream tmp2 = new DerOutputStream();
        AlgorithmId algid = AlgorithmId.get(this.digestAlgorithmName);
        algid.encode(tmp2);
        tmp2.putOctetString(this.digest);
        tmp.write((byte)48, tmp2);
        tmp.putOctetString(this.macSalt);
        tmp.putInteger(this.iterations);
        out.write((byte)48, tmp);
        this.encoded = out.toByteArray();
        return (byte[])this.encoded.clone();
    }
}

