/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class CertBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid;
    private Object value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.CertBag";
    private volatile int cachedHashVal = 0;

    public CertBag(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertBag", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "CertBag", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(Certificate cert) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertBag", cert);
        }
        this.oid = cert instanceof X509Certificate ? PKCSOID.X509_CERT_OID : PKCSOID.SDSI_CERT_OID;
        this.value = cert;
        if (debug != null) {
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(Certificate cert, String provider) throws PKCSException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "CertBag", cert, provider);
        }
        this.oid = cert instanceof X509Certificate ? PKCSOID.X509_CERT_OID : PKCSOID.SDSI_CERT_OID;
        this.value = cert;
        if (debug != null) {
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(ObjectIdentifier oid, byte[] encoding) {
        this(oid, encoding, null);
        if (debug != null) {
            debug.entry(16384L, className, "CertBag", oid, encoding);
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(ObjectIdentifier oid, byte[] encoding, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{oid, encoding, provider};
            debug.entry(16384L, (Object)className, "CertBag", parms);
        }
        if (!(oid.equals(PKCSOID.X509CERTBAG_OID) || oid.equals(PKCSOID.SDSICERTBAG_OID) || oid.equals(PKCSOID.X509_CERT_OID) || oid.equals(PKCSOID.SDSI_CERT_OID))) {
            if (debug != null) {
                debug.text(16384L, className, "CertBag", "Invalid input object identifier.");
            }
            throw new IllegalArgumentException("Invalid input object identifier.");
        }
        this.oid = oid;
        try {
            if (oid.equals(PKCSOID.X509CERTBAG_OID) || oid.equals(PKCSOID.X509_CERT_OID)) {
                this.value = new X509CertImpl(encoding);
            } else if (oid.equals(PKCSOID.SDSICERTBAG_OID) || oid.equals(PKCSOID.SDSI_CERT_OID)) {
                DerValue der = new DerValue(encoding);
                this.value = der.getIA5String();
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "CertBag", e);
            }
            throw new IllegalArgumentException("Invalid certificate encoding.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "CertBag", parms);
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "CertBag", parms);
            debug.exit(16384L, className, "CertBag");
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        bytes.putOID(this.oid);
        DerOutputStream tmpout = new DerOutputStream();
        DerOutputStream tmpout2 = new DerOutputStream();
        if (this.oid.equals(PKCSOID.X509CERTBAG_OID) || this.oid.equals(PKCSOID.X509_CERT_OID)) {
            X509Certificate cert = (X509Certificate)this.value;
            try {
                byte[] certBytes = cert.getEncoded();
                tmpout2.putOctetString(certBytes);
                bytes.write(DerValue.createTag((byte)-128, true, (byte)0), tmpout2);
            }
            catch (CertificateEncodingException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "encode", e);
                }
                throw new IOException("Error encoding X.509 CRL.");
            }
        } else {
            tmpout.putIA5String((String)this.value);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)0), tmpout);
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
        }
        ObjectIdentifier myoid = null;
        try {
            myoid = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception e) {
            myoid = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getObjectIdentifier", myoid);
        }
        return myoid;
    }

    @Override
    public Object getValue() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "getValue");
            }
            if (this.oid.equals(PKCSOID.X509CERTBAG_OID) || this.oid.equals(PKCSOID.X509_CERT_OID)) {
                X509CertImpl retobj = new X509CertImpl(this.getEncodedValue());
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getValue_1", retobj);
                }
                return retobj;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getValue_2", new String((String)this.value));
            }
            return new String((String)this.value);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getValue", e);
                debug.exit(16384L, (Object)className, "getValue_3", null);
            }
            return null;
        }
    }

    @Override
    public byte[] getEncodedValue() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "getEncodedValue");
            }
            if (this.oid.equals(PKCSOID.X509CERTBAG_OID) || this.oid.equals(PKCSOID.X509_CERT_OID)) {
                X509Certificate cert = (X509Certificate)this.value;
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getEncodedValue_1", cert.getEncoded());
                }
                return cert.getEncoded();
            }
            DerOutputStream derout = new DerOutputStream();
            derout.putIA5String((String)this.value);
            byte[] retval = derout.toByteArray();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedValue_2", retval);
            }
            return retval;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedValue", e);
                debug.exit(16384L, (Object)className, "getEncodedValue_3", null);
            }
            return null;
        }
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "CertBag");
        }
        return "CertBag";
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (other instanceof CertBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((CertBag)other));
            }
            return this.equals((CertBag)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            CertBag retobj = new CertBag(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        Object obj = this.getValue();
        String out = "CertBag:";
        out = out + "\r\nobject identifier: " + this.oid;
        out = out + "\r\ncertificate:\r\n";
        out = out + obj.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CertBag parsing error, not a SEQUENCE.");
            }
            throw new IOException("CertBag parsing error, not a SEQUENCE.");
        }
        this.oid = encoding.getData().getOID();
        if (!(this.oid.equals(PKCSOID.X509CERTBAG_OID) || this.oid.equals(PKCSOID.SDSICERTBAG_OID) || this.oid.equals(PKCSOID.X509_CERT_OID) || this.oid.equals(PKCSOID.SDSI_CERT_OID))) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid CertBag object identifier in encoding.");
            }
            throw new IllegalArgumentException("Invalid CertBag object identifier in encoding.");
        }
        DerValue tmpDer = encoding.getData().getDerValue();
        DerValue der = tmpDer.isContextSpecific((byte)0) ? tmpDer.getData().getDerValue() : tmpDer;
        if (this.oid.equals(PKCSOID.X509CERTBAG_OID) || this.oid.equals(PKCSOID.X509_CERT_OID)) {
            try {
                byte[] enc = der.getOctetString();
                this.value = new X509CertImpl(enc);
            }
            catch (CertificateException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "decode", e);
                }
                throw new IOException("Error decoding X.509 CRL from encoding.");
            }
        } else if (this.oid.equals(PKCSOID.SDSICERTBAG_OID) || this.oid.equals(PKCSOID.SDSI_CERT_OID)) {
            this.value = der.getIA5String();
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid encoded OID");
            }
            throw new IllegalArgumentException("Invalid encoded OID");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(CertBag other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

