/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs10;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;

public final class CertificationRequestInfo
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_ATTRIBUTES = 0;
    private static final BigInteger version = BigInteger.ZERO;
    private X500Name subject;
    private PublicKey spki;
    private PKCSAttributes attributeSet;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs10.CertificationRequestInfo";
    private volatile int cachedHashVal = 0;

    public CertificationRequestInfo(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificationRequestInfo", (Object)der);
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    public CertificationRequestInfo(byte[] der, String provname) throws IOException {
        super(der, provname);
        if (debug != null) {
            debug.entry(16384L, className, "CertificationRequestInfo", der, provname);
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    public CertificationRequestInfo(X500Name subject, PublicKey key, PKCSAttributes attrs) {
        if (debug != null) {
            Object[] parms = new Object[]{subject, key, attrs};
            debug.entry(16384L, (Object)className, "CertificationRequestInfo", parms);
        }
        if (subject == null) {
            if (debug != null) {
                debug.text(16384L, className, "CertificationRequestInfo", "No subject specified");
            }
            throw new IllegalArgumentException("No subject specified");
        }
        if (key == null) {
            if (debug != null) {
                debug.text(16384L, className, "CertificationRequestInfo", "No public key specified");
            }
            throw new IllegalArgumentException("No public key specified");
        }
        this.subject = subject;
        this.spki = key;
        this.attributeSet = attrs != null ? attrs : new PKCSAttributes((PKCSAttribute[])null);
        if (debug != null) {
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    public CertificationRequestInfo(X500Name subject, PublicKey key, PKCSAttributes attrs, String provname) {
        super(provname);
        if (debug != null) {
            Object[] parms = new Object[]{subject, key, attrs, provname};
            debug.entry(16384L, (Object)className, "CertificationRequestInfo", parms);
        }
        if (subject == null) {
            if (debug != null) {
                debug.text(16384L, className, "CertificationRequestInfo", "No subject specified");
            }
            throw new IllegalArgumentException("No subject specified");
        }
        if (key == null) {
            if (debug != null) {
                debug.text(16384L, className, "CertificationRequestInfo", "No public key specified");
            }
            throw new IllegalArgumentException("No public key specified");
        }
        this.subject = subject;
        this.spki = key;
        this.attributeSet = attrs != null ? attrs : new PKCSAttributes((PKCSAttribute[])null, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    public CertificationRequestInfo(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "CertificationRequestInfo", parms);
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    public CertificationRequestInfo(String filename, boolean base64, String provname) throws IOException {
        super(filename, base64, provname);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provname};
            debug.entry(16384L, (Object)className, "CertificationRequestInfo", parms);
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(version);
        this.subject.encode(bytes);
        bytes.write(this.spki.getEncoded());
        DerOutputStream derout = new DerOutputStream();
        this.attributeSet.encode(derout);
        bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derout);
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (other instanceof CertificationRequestInfo) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", this.equals((CertificationRequestInfo)other));
            }
            return this.equals((CertificationRequestInfo)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public String toString() {
        String out = "";
        out = out + "PKCS #10 Certification request info:";
        out = out + "\r\n\tversion: " + version;
        out = out + "\r\n\tsubject: " + this.subject;
        out = out + "\r\n\tpublic key info: \r\n" + this.spki.toString();
        out = out + "\r\n\tattributes: " + this.attributeSet.toString();
        return out;
    }

    public Object clone() {
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            return new CertificationRequestInfo(derout.toByteArray(), this.provider);
        }
        catch (Exception e) {
            return null;
        }
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", version);
        }
        return version;
    }

    public X500Name getSubjectName() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectName");
            debug.exit(16384L, (Object)className, "getSubjectName", this.subject);
        }
        return this.subject;
    }

    public PublicKey getSubjectPublicKeyInfo() throws InvalidKeyException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectPublicKeyInfo");
        }
        if (this.spki == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectPublicKeyInfo", null);
            }
            return null;
        }
        DerValue der = new DerValue(this.spki.getEncoded());
        PublicKey result = X509Key.parse(der);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSubjectPublicKeyInfo", result);
        }
        return result;
    }

    public PKCSAttributes getAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributes");
            debug.exit(16384L, (Object)className, "getAttributes", this.attributeSet);
        }
        return this.attributeSet;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CertificationRequestInfo parsing error");
            }
            throw new IOException("CertificationRequestInfo parsing error");
        }
        BigInteger parsedVersion = encoding.getData().getInteger();
        if (!parsedVersion.equals(version)) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Version mismatch: (supported: " + version + ", parsed: " + parsedVersion);
            }
            throw new IOException("Version mismatch: (supported: " + version + ", parsed: " + parsedVersion);
        }
        this.subject = new X500Name(encoding.getData().getDerValue());
        this.spki = X509Key.parse(encoding.getData().getDerValue());
        this.attributeSet = encoding.getData().available() != 0 ? new PKCSAttributes(encoding.getData(), this.provider) : new PKCSAttributes((PKCSAttribute[])null, this.provider);
        if (encoding.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CertificationRequestInfo parsing error - data overrun, bytes = " + encoding.getData().available());
            }
            throw new IOException("CertificationRequestInfo parsing error - data overrun, bytes = " + encoding.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(CertificationRequestInfo other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

