/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.ConstructKeys;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public final class RSACipher
extends CipherSpi {
    private boolean decrypting = false;
    SecureRandom random = null;
    PKCS11Cipher cipher = null;
    private PKCS11Key hw_key_to_delete = null;
    private int mechanism;
    private Session session = null;
    private SessionManager sessionManager;
    private Provider provider = null;
    private Config config = null;
    private OAEPParameterSpec spec = null;
    private int paddingIndicator = 0;
    private String oaepHashAlgorithm = "SHA-1";
    private static final boolean defaultMGF1isSHA1 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return "true".equalsIgnoreCase(System.getProperty(RSACipher.DEFAULT_RSA_OAEP_MGF1_IS_SHA1, "false"));
        }
    });
    private static final String DEFAULT_RSA_OAEP_MGF1_IS_SHA1 = "com.ibm.crypto.provider.Default_RSA_OAEP_MGF1_is_SHA1";
    int CKZ_DATA_SPECIFIED = 1;
    private BigInteger modulus;
    private byte[] data = null;
    private int dataUsed = 0;
    private int opmode;
    private Key key;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSACipher";

    public RSACipher(Provider provider) {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.provider = provider;
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        if (debug != null) {
            System.out.println("RSACipher.java:  CONSTRUCTOR:  Setting the mechanism to RSA_PKCS (RSA/ /PKCS1Padding) by default");
        }
        this.mechanism = 1;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode != null && (mode.equals(" ") || mode.equals("ECB") || mode.equals("SSL"))) {
            return;
        }
        if (mode != null) {
            throw new NoSuchAlgorithmException("Mode: " + mode + " not implemented");
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (debug != null) {
            System.out.println("RSACipher.java:  engineSetPadding():  The paddingScheme argument passed in is:  " + paddingScheme);
        }
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetPadding", (Object)("." + paddingScheme + "."));
        }
        if ((paddingScheme.equalsIgnoreCase("PKCS1Padding") || paddingScheme.equalsIgnoreCase("PKCS")) && this.config != null && this.config.supportMechanism(1)) {
            this.paddingIndicator = 0;
            if (debug != null) {
                System.out.println("RSACipher.java:  engineSetPadding():  Setting mechanism to RSA_PKCS (RSA/ /PKCS1Padding)");
            }
            this.mechanism = 1;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"PKCS");
            }
            return;
        }
        if ((paddingScheme.equals(" ") || paddingScheme.equalsIgnoreCase("NoPadding") || paddingScheme == null) && this.config != null && this.config.supportMechanism(3)) {
            this.paddingIndicator = 1;
            if (debug != null) {
                System.out.println("RSACipher.java:  engineSetPadding():  Setting mechanism to RSA_X_509 (RSA/ /NoPadding)");
            }
            this.mechanism = 3;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"RAW RSA");
            }
            return;
        }
        if (paddingScheme.startsWith("OAEP") || paddingScheme.startsWith("oaep")) {
            String lowerPadding = paddingScheme.toLowerCase(Locale.ENGLISH);
            if (debug != null) {
                System.out.println("RSACipher.java:  engineSetPadding():  The lowerpadding is:  " + lowerPadding);
            }
            if (lowerPadding.equals("oaeppadding")) {
                this.paddingIndicator = 2;
            } else if (lowerPadding.startsWith("oaeppadding")) {
                this.paddingIndicator = 2;
                this.oaepHashAlgorithm = paddingScheme.substring(11, paddingScheme.length());
            } else if (lowerPadding.startsWith("oaepwith") && lowerPadding.endsWith("andmgf1padding")) {
                this.paddingIndicator = 2;
                this.oaepHashAlgorithm = paddingScheme.substring(8, paddingScheme.length() - 14);
                if (debug != null) {
                    System.out.println("RSACipher.java:  engineSetPadding():  The hash algorithm lifted from the padding scheme passed in is:  " + this.oaepHashAlgorithm);
                }
            } else {
                throw new NoSuchPaddingException("Padding " + paddingScheme + " not supported");
            }
            if (debug != null) {
                System.out.println("RSACipher.java:  engineSetPadding():  The oaepHashAlgorithm lifted from the paddingScheme is:  " + this.oaepHashAlgorithm);
                System.out.println("RSACipher.java:  engineSetPadding():  Setting mechanism to PKCS11Mechanism.RSA_PKCS_OAEP (RSA//OAEPPadding) ");
            }
            this.mechanism = 9;
            Provider[] providers = Security.getProviders();
            boolean foundService = false;
            for (int i = 0; i < providers.length; ++i) {
                if (providers[i].getService("MessageDigest", this.oaepHashAlgorithm) == null) continue;
                foundService = true;
                break;
            }
            if (!foundService) {
                throw new NoSuchPaddingException("MessageDigest not available for " + paddingScheme);
            }
            return;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"No such padding.");
        }
        throw new NoSuchPaddingException("Padding: " + paddingScheme + " not implemented");
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.modulus.toByteArray().length;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.spec != null) {
            try {
                Provider[] providers;
                Provider IBMPKCS11Impl_provider = null;
                for (Provider provider : providers = Security.getProviders()) {
                    if (provider.getName().indexOf("IBMPKCS11Impl") == -1) continue;
                    IBMPKCS11Impl_provider = provider;
                    break;
                }
                if (IBMPKCS11Impl_provider == null) {
                    throw new RuntimeException("Cannot find the IBMPKCS11Impl provider.");
                }
                AlgorithmParameters params = AlgorithmParameters.getInstance("OAEP", IBMPKCS11Impl_provider);
                params.init(this.spec);
                return params;
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("Cannot find OAEP  AlgorithmParameters implementation in IBMPKCS11Impl provider");
            }
            catch (InvalidParameterSpecException ipse) {
                throw new RuntimeException("OAEPParameterSpec not supported");
            }
        }
        return null;
    }

    private void cancelOperation() {
        block13: {
            if (debug != null) {
                debug.entry(16384L, (Object)"RSACipher", "cancelOperation");
            }
            if (this.session == null) {
                if (debug != null) {
                    debug.text(16384L, (Object)"RSACipher", "cancelOperation", "session is null");
                }
                this.cipher = null;
                this.key = null;
                if (this.hw_key_to_delete != null) {
                    this.hw_key_to_delete.rm();
                    this.hw_key_to_delete = null;
                }
                return;
            }
            if (!this.session.hasObjects()) {
                if (debug != null) {
                    debug.text(16384L, (Object)"RSACipher", "cancelOperation", "session has no objects, close session handle = " + this.session.getID());
                }
                this.sessionManager.closeSession(this.session);
                this.session = null;
                this.cipher = null;
                this.key = null;
                if (this.hw_key_to_delete != null) {
                    this.hw_key_to_delete.rm();
                    this.hw_key_to_delete = null;
                }
                return;
            }
            int blocksize = this.engineGetBlockSize();
            if (blocksize == 0) {
                blocksize = 8;
            }
            byte[] data = new byte[blocksize];
            try {
                if (debug != null) {
                    debug.text(16384L, (Object)"RSACipher", "cancelOperation", "call do final to clean up buffered data");
                }
                this.cipher.engineDoFinal(this.session, data, 0, blocksize);
            }
            catch (Exception ex) {
                if (debug == null) break block13;
                debug.exception(16384L, (Object)"RSACipher", "cancelOperation", (Throwable)ex);
            }
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        this.cipher = null;
        this.key = null;
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"RSACipher", "cancelOperation");
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.dataUsed + inputLen > this.data.length) {
            this.cancelOperation();
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    this.engineInit(this.opmode, this.key, null);
                }
                catch (Exception ex) {
                    this.cancelOperation();
                    throw new IllegalArgumentException(ex);
                }
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        this.dataUsed += inputLen;
        if (debug != null) {
            debug.text(16384L, (Object)"RSACipher", "engineUpdate1", "dataUsed=" + this.dataUsed + ", input len= " + inputLen);
        }
        return new byte[0];
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (this.dataUsed + inputLen > this.data.length) {
            this.cancelOperation();
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    this.engineInit(this.opmode, this.key, null);
                }
                catch (Exception ex) {
                    this.cancelOperation();
                    throw new IllegalArgumentException(ex);
                }
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        this.dataUsed += inputLen;
        if (debug != null) {
            debug.text(16384L, (Object)"RSACipher", "engineUpdate2", "dataUsed=" + this.dataUsed + ", input len= " + inputLen);
        }
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] saved_rc = new byte[]{};
        if (this.dataUsed + inputLen > this.data.length) {
            this.cancelOperation();
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    this.engineInit(this.opmode, this.key, null);
                }
                catch (Exception ex) {
                    this.cancelOperation();
                    throw new IllegalArgumentException(ex);
                }
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        if (inputLen != 0) {
            System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        }
        try {
            if (debug != null) {
                debug.text(16384L, (Object)"RSACipher", "engineDoFinal1", "dataUsed=" + this.dataUsed + ", input len= " + inputLen);
            }
            if (this.dataUsed + inputLen == 0) {
                this.data = null;
            }
            saved_rc = this.cipher.engineDoFinal(this.session, this.data, 0, this.dataUsed + inputLen);
            this.dataUsed = 0;
            if (!this.decrypting && this.data != null) {
                Arrays.fill(this.data, (byte)0);
            }
        }
        catch (PKCS11Exception ex) {
            if (!this.decrypting) {
                if (this.data != null) {
                    Arrays.fill(this.data, (byte)0);
                }
            } else if (saved_rc != null) {
                Arrays.fill(saved_rc, (byte)0);
            }
            this.cancelOperation();
            throw ex;
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        return saved_rc;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int saved_rc;
        if (this.dataUsed + inputLen > this.data.length) {
            this.cancelOperation();
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    this.engineInit(this.opmode, this.key, null);
                }
                catch (Exception ex) {
                    this.cancelOperation();
                    throw new IllegalArgumentException(ex);
                }
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        if (inputLen != 0) {
            System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        }
        try {
            if (debug != null) {
                debug.text(16384L, (Object)"RSACipher", "engineDoFinal2", "dataUsed=" + this.dataUsed + ", input len= " + inputLen);
            }
            if (this.dataUsed + inputLen == 0) {
                this.data = null;
            }
            saved_rc = this.cipher.engineDoFinal(this.session, this.data, 0, this.dataUsed + inputLen, output, outputOffset);
            this.dataUsed = 0;
            if (!this.decrypting && this.data != null) {
                Arrays.fill(this.data, (byte)0);
            }
        }
        catch (PKCS11Exception ex) {
            if (!this.decrypting) {
                if (this.data != null) {
                    Arrays.fill(this.data, (byte)0);
                }
            } else if (output != null) {
                Arrays.fill(output, (byte)0);
            }
            this.cancelOperation();
            throw ex;
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        return saved_rc;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PublicKey) {
            try {
                BigInteger n = ((RSAPublicKey)key).getModulus();
                return n.bitLength();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        }
        if (key instanceof PrivateKey) {
            try {
                RSAPrivateKey priv = (RSAPrivateKey)key;
                BigInteger n = priv.getModulus();
                return n.bitLength();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        }
        throw new InvalidKeyException("Must be either public key or private key.");
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] saved_rc;
        int len = 0;
        len = (this.modulus.bitLength() + 7) / 8;
        if (this.session == null) {
            if (this.key != null) {
                this.engineInit(this.opmode, this.key, null);
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        try {
            saved_rc = this.cipher.engineWrap(this.session, ((PKCS11Key)((Object)key)).getObject(), len);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        return saved_rc;
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        Key result = null;
        int[] attrTypes = null;
        Object[] attrValues = null;
        Object[] attrs = new Object[2];
        PKCS11Object objKey = null;
        if (this.session == null) {
            if (this.key != null) {
                this.engineInit(this.opmode, this.key, null);
            } else {
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        try {
            switch (wrappedKeyType) {
                case 3: {
                    attrs = ConstructKeys.constructSecretKeyAttrs(wrappedKeyAlgorithm, this.config);
                    attrTypes = (int[])attrs[0];
                    attrValues = (Object[])attrs[1];
                    objKey = this.cipher.engineUnwrap(this.session, wrappedKey, attrTypes, attrValues);
                    result = ConstructKeys.constructSecretKey(objKey, wrappedKeyAlgorithm, this.provider);
                    break;
                }
                case 2: {
                    attrs = ConstructKeys.constructPrivateKeyAttrs(wrappedKeyAlgorithm, this.config);
                    attrTypes = (int[])attrs[0];
                    attrValues = (Object[])attrs[1];
                    objKey = this.cipher.engineUnwrap(this.session, wrappedKey, attrTypes, attrValues);
                    result = ConstructKeys.constructPrivateKey(objKey, wrappedKeyAlgorithm, this.provider);
                    break;
                }
                case 1: {
                    attrs = ConstructKeys.constructPublicKeyAttrs(wrappedKeyAlgorithm, this.config);
                    attrTypes = (int[])attrs[0];
                    attrValues = (Object[])attrs[1];
                    objKey = this.cipher.engineUnwrap(this.session, wrappedKey, attrTypes, attrValues);
                    result = ConstructKeys.constructPublicKey(objKey, wrappedKeyAlgorithm, this.provider);
                }
            }
        }
        catch (NoSuchAlgorithmException ex) {
            this.cancelOperation();
            throw ex;
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        return result;
    }

    private PKCS11Key translateToP11Key(Key key) throws InvalidKeyException {
        PKCS11Key p11key = null;
        if (key instanceof PublicKey) {
            if (this.decrypting) {
                throw new InvalidKeyException("Public Key cannot be used to decrypt.");
            }
            if (key instanceof PKCS11Key) {
                p11key = (PKCS11Key)((Object)key);
            } else if (key instanceof RSAPublicKey) {
                KeyFactory kf = null;
                try {
                    kf = KeyFactory.getInstance("RSA", this.provider);
                    this.hw_key_to_delete = p11key = (PKCS11Key)((Object)kf.translateKey(key));
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("not RSA key"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("not RSA key: " + key);
            }
            try {
                RSAPublicKey pub = (RSAPublicKey)key;
                this.modulus = pub.getModulus();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        } else if (key instanceof PrivateKey) {
            if (!this.decrypting) {
                throw new InvalidKeyException("Private key cannot be used to encrypt.");
            }
            if (key instanceof PKCS11Key) {
                p11key = (PKCS11Key)((Object)key);
            } else if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey) {
                KeyFactory kf = null;
                try {
                    kf = KeyFactory.getInstance("RSA", this.provider);
                    this.hw_key_to_delete = p11key = (PKCS11Key)((Object)kf.translateKey(key));
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("not RSA key"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("not RSA key: " + key);
            }
            try {
                RSAPrivateKey priv = (RSAPrivateKey)key;
                this.modulus = priv.getModulus();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        } else {
            throw new InvalidKeyException("Must be either public key or private key.");
        }
        return p11key;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.init(opmode, key, random, null);
        }
        catch (InvalidAlgorithmParameterException iape) {
            InvalidKeyException ike = new InvalidKeyException("Wrong parameters");
            ike.initCause(iape);
            throw ike;
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key, random, params);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params == null) {
            this.init(opmode, key, random, null);
        } else {
            try {
                OAEPParameterSpec spec = params.getParameterSpec(OAEPParameterSpec.class);
                this.init(opmode, key, random, spec);
            }
            catch (InvalidParameterSpecException ipse) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Wrong parameter");
                iape.initCause(ipse);
                throw iape;
            }
        }
    }

    private void init(int opmode, Key key, SecureRandom random, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.spec = (OAEPParameterSpec)params;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "init");
        }
        if (opmode == 2 || opmode == 4) {
            this.decrypting = true;
        } else if (opmode == 1 || opmode == 3) {
            this.decrypting = false;
        } else {
            throw new InvalidKeyException("Unknown mode: " + opmode);
        }
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        PKCS11Key p11key = this.translateToP11Key(key);
        String pszkey = key.getAlgorithm();
        if (!pszkey.equals("RSA")) {
            throw new InvalidKeyException("Not a RSA key.  Key algorithm is " + pszkey + ".");
        }
        if (this.decrypting) {
            if (!(key instanceof RSAPrivateKey) && !(key instanceof RSAPrivateCrtKey)) {
                throw new InvalidKeyException("Decryption key is not an RSAPrivateKey.");
            }
        } else if (!(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Encryption key is not a RSAPublicKey.");
        }
        if (this.data != null && !this.decrypting) {
            Arrays.fill(this.data, (byte)0);
        }
        this.data = new byte[(this.modulus.bitLength() + 7) / 8];
        this.dataUsed = 0;
        OAEPParameterSpec myParams = null;
        if (this.mechanism == 9) {
            if (params != null) {
                if (debug != null) {
                    System.out.println("==================================================================================");
                    System.out.println("RSACipher.java:  init( ):  An OAEPParameterSpec object was supplied by the caller.");
                    System.out.println("==================================================================================");
                }
                if (!(params instanceof OAEPParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Wrong Parameters for OAEP Padding");
                }
                String oaepParameterSpecHashAlgorithm = ((OAEPParameterSpec)params).getDigestAlgorithm();
                if (oaepParameterSpecHashAlgorithm.equalsIgnoreCase("SHA-512/256") || oaepParameterSpecHashAlgorithm.equalsIgnoreCase("SHA512/256") || oaepParameterSpecHashAlgorithm.equalsIgnoreCase("SHA-512/224") || oaepParameterSpecHashAlgorithm.equalsIgnoreCase("SHA512/224")) {
                    throw new InvalidAlgorithmParameterException("The message digest \"" + oaepParameterSpecHashAlgorithm + "\" specified on the OAEPParameterSpec is not supported.");
                }
                MGF1ParameterSpec mgfParameters = (MGF1ParameterSpec)((OAEPParameterSpec)params).getMGFParameters();
                String mgf1ParameterSpecHashAlgorithm = mgfParameters.getDigestAlgorithm();
                if (mgf1ParameterSpecHashAlgorithm.equalsIgnoreCase("SHA-512/256") || mgf1ParameterSpecHashAlgorithm.equalsIgnoreCase("SHA512/256") || mgf1ParameterSpecHashAlgorithm.equalsIgnoreCase("SHA-512/224") || mgf1ParameterSpecHashAlgorithm.equalsIgnoreCase("SHA512/224")) {
                    throw new InvalidAlgorithmParameterException("The message digest \"" + mgf1ParameterSpecHashAlgorithm + "\" specified on the MGF1ParameterSpec is not supported.");
                }
                myParams = (OAEPParameterSpec)params;
            } else {
                if (debug != null) {
                    System.out.println("==================================================================================");
                    System.out.println("RSACipher.java:  init( ):  No OAEPParameterSpec object was supplied by the caller.");
                    System.out.println("                           The following OAEP parameters are inferred from the supplied RSA/OAEP cipher transformation string:");
                    System.out.println("                           hashAlg = " + this.oaepHashAlgorithm);
                }
                MGF1ParameterSpec mgfSpec = MGF1ParameterSpec.SHA1;
                if (!defaultMGF1isSHA1) {
                    if (debug != null) {
                        System.out.println("RSACipher.java:  init():  -Dcom.ibm.crypto.provider.Default_RSA_OAEP_MGF1_is_SHA1=false");
                    }
                    if (this.oaepHashAlgorithm.equals("SHA-256") || this.oaepHashAlgorithm.equals("SHA256")) {
                        mgfSpec = MGF1ParameterSpec.SHA256;
                        if (debug != null) {
                            System.out.println("                           mgf = SHA-256");
                        }
                    } else if (this.oaepHashAlgorithm.equals("SHA-384") || this.oaepHashAlgorithm.equals("SHA384")) {
                        mgfSpec = MGF1ParameterSpec.SHA384;
                        if (debug != null) {
                            System.out.println("                           mgf = SHA-384");
                        }
                    } else if (this.oaepHashAlgorithm.equals("SHA-512") || this.oaepHashAlgorithm.equals("SHA512")) {
                        mgfSpec = MGF1ParameterSpec.SHA512;
                        if (debug != null) {
                            System.out.println("                           mgf = SHA-512");
                        }
                    } else if (this.oaepHashAlgorithm.equals("SHA-224") || this.oaepHashAlgorithm.equals("SHA224")) {
                        mgfSpec = MGF1ParameterSpec.SHA224;
                        if (debug != null) {
                            System.out.println("                           mgf = SHA-224");
                        }
                    }
                } else if (debug != null) {
                    System.out.println("                               mgf = SHA-1  (-Dcom.ibm.crypto.provider.Default_RSA_OAEP_MGF1_is_SHA1=true) ");
                }
                if (debug != null) {
                    System.out.println("                              pSrc = PSource.PSpecified.DEFAULT");
                    System.out.println("==================================================================================");
                }
                myParams = new OAEPParameterSpec(this.oaepHashAlgorithm, "MGF1", mgfSpec, PSource.PSpecified.DEFAULT);
            }
        }
        if (debug != null) {
            if (this.mechanism == 1) {
                System.out.println("RSACipher.java:  init():  Creating a PKCS11Cipher object with mechanism = RSA_PKCS (RSA/ /PKCS1Padding)");
            } else if (this.mechanism == 3) {
                System.out.println("RSACipher.java:  init():  Creating a PKCS11Cipher object with mechanism = RSA_X_509 (RSA/ /NoPadding)");
            } else if (this.mechanism == 9) {
                System.out.println("RSACipher.java:  init():  Creating a PKCS11Cipher object with mechanism = RSA_PKCS_OAEP (RSA/ /OAEPPadding...)");
            }
        }
        PKCS11Cipher cp = null;
        cp = new PKCS11Cipher(this.mechanism);
        if (this.session == null) {
            this.session = this.sessionManager.getOpSession();
        } else {
            this.cancelOperation();
            if (this.session == null) {
                this.session = this.sessionManager.getOpSession();
            }
        }
        try {
            cp.engineInit(this.session, opmode, p11key.getObject(), myParams, (this.modulus.bitLength() + 7) / 8);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        if (debug != null) {
            System.out.println("RSACipher.java:  init():  Returning from the PKCS11Cipher.init() call");
        }
        this.opmode = opmode;
        this.key = key;
        this.cipher = cp;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "init");
        }
    }

    public static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int len = block.length;
        int high = 0;
        int low = 0;
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                buf.append('\n');
            }
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
            buf.append(' ');
        }
        return buf.toString();
    }
}

