[string]$ComputerName = $env:COMPUTERNAME

$dotNetRegistry = 'SOFTWARE\Microsoft\NET Framework Setup\NDP'

$dotNet4Registry = 'SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Full'

$dotNet4Builds = @{'30319'  = @{ Version = [System.Version]'4.0' }}

if($regKey = [Microsoft.Win32.RegistryKey]::OpenRemoteBaseKey('LocalMachine', $ComputerName)) {

    if ($netRegKey = $regKey.OpenSubKey("$dotNetRegistry")) {

        foreach ($versionKeyName in $netRegKey.GetSubKeyNames()) {

            if ($versionKeyName -match '^v[123]') {

                $versionKey = $netRegKey.OpenSubKey($versionKeyName)

                $version = [System.Version]($versionKey.GetValue('Version', ''))

                New-Object -TypeName PSObject -Property ([ordered]@{

                        ComputerName = $ComputerName

                        Build        = $version.Build

                        Version      = $version

                    })

            }

        }

    }

 

    if ($net4RegKey = $regKey.OpenSubKey("$dotNet4Registry")) {

        if(-not ($net4Release = $net4RegKey.GetValue('Release'))) {

            $net4Release = 30319

        }

            $version = [System.Version]($net4RegKey.GetValue('Version', ''))

        New-Object -TypeName PSObject -Property ([ordered]@{

                ComputerName = $ComputerName

                Build        = $net4Release

                Version      = $version

            })

    }

}