' List Installed Hot Fixes
On Error Resume Next
'Dim hotfix(1000,1)
Set objDictionary = CreateObject("scripting.dictionary")
count =0

strKeyPath = "SOFTWARE\Microsoft\Updates"
EnumerateSubKey(strKeypath)
'wscript.echo "count=" & count
ListTheHotfixes

if Err.Number <> 0 then
	WScript.Echo "#Error#"
else	
	WScript.Echo "#EG_SCRIPT_DONE#"
end if	
Wscript.echo 


Function ListTheHotfixes
	strComputer = "."
	Set objWMIService = GetObject("winmgmts:" _
		& "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")

	Set colQuickFixes = objWMIService.ExecQuery _
		("Select * from Win32_QuickFixEngineering")
	If(Not ISNull(colQuickFixes)) then
		If( colQuickFixes.Count > 0 ) then
			For Each objQuickFix in colQuickFixes
				description = checkDesc(objQuickFix.HotFixID,objQuickFix.Description)
				if description <> "-" then
					outputline= description	&"#" & HexDateToDate(objQuickFix.InstalledOn) &"#" & objQuickFix.InstalledBy
					Wscript.Echo outputline
				end if	
			Next
		End if
	Else
		WScript.Echo "#Error#"
		WScript.Quit
	End If
End Function

Function checkDesc(hotfixid,description)
	hotfixid=trim(hotfixid)
	if(Instr(hotfixid,"KB") = 1) then
			if( len(description) >0) then
				checkDesc= hotfixid & "#" & description	& " for Microsoft Windows ("&hotfixid &")"
			else
				checkDesc="-"
			end if
	else
		if( len(description) >0) then

				checkDesc= description
			else
				checkDesc="-"
			end if
	end if
End Function

Function HexDateToDate(hDate)
	On Error Resume Next
	highPart = CDbl("&h" & Left(hDate,8))
	if Err.Number = 0 then
		lowPart = CDbl("&h" & Right(hDate,8))
		intInstalledOn = highPart * (2^32) + lowPart 
		intInstalledOn = intInstalledOn / (60 * 10000000)
		intInstalledOn = intInstalledOn / 1440
		HexDateToDate = intInstalledOn + #1/1/1601#
	elseif len(hDate) > 0 then
		Err.Clear
		HexDateToDate = hDate
	else
		HexDateToDate = "-"
	end if	
End Function 

Function  EnumerateSubKey (strKeypath)
	const HKEY_LOCAL_MACHINE = &H80000002
	strComputer = "."
	Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" &_ 
	strComputer & "\root\default:StdRegProv")
	If oReg.EnumKey (HKEY_LOCAL_MACHINE, strKeyPath, arrSubKeys) = 0 Then
		If Not IsNull(arrSubKeys) Then
			For Each subkey In arrSubKeys 
				count = count + 1
				strValueName = "PackageName"
				tKeyPath = strKeyPath & "\" & subkey
				'WScript.Echo tKeyPath
				oReg.GetStringValue HKEY_LOCAL_MACHINE,tKeyPath,strValueName,strValue
				'WScript.Echo "*****" & strValue & "****"
				If Not IsNull(strValue) then
					oReg.GetStringValue  HKEY_LOCAL_MACHINE,tKeyPath,"InstalledDate",strValue1
					if isNull(strValue1) then
						strValue1 = "-"
					end if	
					oReg.GetStringValue  HKEY_LOCAL_MACHINE,tKeyPath,"InstalledBy",strValue2
					if isNull(strValue2) then
						strValue2 = "-"
					end if	
					value=strValue&"#"&strValue1&"#"&strValue2
					'objDictionary.Add subkey,value
					wScript.Echo subkey & "#" & value
				else
					EnumerateSubKey(tKeyPath)
				end if
			Next
		end if	
	End If
End Function 

