﻿$TestInputs=$args

$proxyAddress=$TestInputs[0]
#$proxyPort=$TestInputs[1]

Function Set-InternetProxy
{
    [CmdletBinding()]
    Param(  
        [Parameter(Mandatory=$True,ValueFromPipeline=$true,ValueFromPipelineByPropertyName=$true)]
        [String[]]$Proxy,

        [Parameter(Mandatory=$False,ValueFromPipeline=$true,ValueFromPipelineByPropertyName=$true)]
        [AllowEmptyString()]
        [String[]]$acs                
    )
    Begin{
            $regKey="HKCU:\Software\Microsoft\Windows\CurrentVersion\Internet Settings"       
    }
    
    Process{
        
        Set-ItemProperty -path $regKey ProxyEnable -value 1
        Set-ItemProperty -path $regKey ProxyServer -value $proxy
        Set-ItemProperty -Path $regKey ProxyOverride -Value '<local>'                
        if($acs) {                      
                 Set-ItemProperty -path $regKey AutoConfigURL -Value $acs          
        }
    }  
    End{
        Write-Output "Proxy is now enabled"
        Write-Output "Proxy Server : $proxy"
        if ($acs){         
            Write-Output "Automatic Configuration Script : $acs"
        }
        else{
            Write-Output "Automatic Configuration Script : Not Defined"
        }
    }
}
function Get-InternetProxy
{   
    $proxies = (Get-ItemProperty -Path 'HKCU:\Software\Microsoft\Windows\CurrentVersion\Internet Settings').proxyServer
    if ($proxies){
        if ($proxies -ilike "*=*"){
            $proxies -replace "=","://" -split(';') | Select-Object -First 1
        }
        else{
            "http://" + $proxies
        }
    }    
}
function refresh-system() {
    $signature = @'
[DllImport("wininet.dll", SetLastError = true, CharSet=CharSet.Auto)]
public static extern bool InternetSetOption(IntPtr hInternet, int dwOption, IntPtr lpBuffer, int dwBufferLength);
'@

    $INTERNET_OPTION_SETTINGS_CHANGED   = 39
    $INTERNET_OPTION_REFRESH            = 37
    $type = Add-Type -MemberDefinition $signature -Name wininet -Namespace pinvoke -PassThru
    $a = $type::InternetSetOption(0, $INTERNET_OPTION_SETTINGS_CHANGED, 0, 0)
    $b = $type::InternetSetOption(0, $INTERNET_OPTION_REFRESH, 0, 0)
    return $a -and $b
}

clear

#Set-InternetProxy "0.0.0.0:80"
#Set-InternetProxy "192.168.8.5:8085"
#$proxyHost="192.168.8.5"
#$proxyPort="8085"
#$proxyAddress = $proxyHost + ":" + $proxyPort
netsh winhttp set proxy $proxyAddress "<local>"
Set-InternetProxy $proxyAddress
refresh-system
