﻿<#
    /*****************************************************************************
    Author            :       Mounika Kuna
    Purpose           :       Provides Office 365 License Details by User
    Created           :       18/07/2020    
    /*****************************************************************************
#>

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$readingdate=[datetime]$TestInputs[5]
$rptNam=$TestInputs[6]
#>

$rptPath=$egurkhaPath+'\agent\O365\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$o365Domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver

$appId=''
$appSecret=''
$tenantID=''
$authString=''
$resource=''
$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

#------Get App Reg Details ------------
$GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
$unProtPath=$GraphDir+'\GraphDetails.dat'
$keyFileNam='\GraphDetailsKey.dat'
$kvalue=Get-Content -Path $GraphDir$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
$spoGraphDtls=$GraphDir+"\GraphDetails.ini"
$getInputs=Get-Content -Path $spoGraphDtls
Remove-Item $spoGraphDtls
$flag=$false
foreach($input in $getInputs){
    if($input.StartsWith('[') -and $input.ToLower().Contains($o365Domain.ToLower())){
        $flag=$true
    }
    if($flag){
        if($input.Contains("client_id")){
            $appId=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("client_secret")){
            $appSecret=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("TenantName")){
            $tenantID=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("Authority")){
            $authString=$input.ToString().Substring($input.IndexOf('~')+1)
            $authString=$authString+$o365Domain
        }
        if($input.Contains("Resource")){
            $resource=$input.ToString().Substring($input.IndexOf('~')+1)
            $flag=$false
        }
    }         
}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$O365ActiveUserDetCSV=$rptPath+'\O365ActiveUserDet'+$timenow+'.csv'
$url = "https://graph.microsoft.com/v1.0/reports/getOffice365ActiveUserDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url -filePath $O365ActiveUserDetCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $TotalO365ActiveUserDet=Import-Csv $O365ActiveUserDetCSV
    $url=$TotalO365ActiveUserDet.'@odata.nextLink'
    if($url -eq $null -or $url -eq ''){
        break
    }
}

$diffence=(NEW-TIMESPAN –Start $readingdate –End (Get-Date) | Select-Object Days).Days
$notFirsttime = $false
while($diffence -ge 1)
{
    if($notFirsttime){ $readingdate=$readingdate.AddDays(1) }
    $actualdate=$readingdate
    $notFirsttime = $true
    $TotalO365ActiveUser =$TotalO365ActiveUserDet | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
    if($TotalO365ActiveUser)
    {
        Write-Host 'ReadDate for the Date#'$actualdate.tostring(“yyyy-MM-dd”)
        break
    }
    else
    {
        Write-Host 'thereIs No Data on#'$actualdate.tostring(“yyyy-MM-dd”)
    }
    $diffence=$diffence-1
}
try{
	$TotalO365ActiveUser = $TotalO365ActiveUser | Where-Object { $_.UserPrincipalName -ne '(Unknown)' }
    foreach($User in $TotalO365ActiveUser){
        $HasExchangeLicense=0
        if($User.HasExchangeLicense -eq 'True'){
           $HasExchangeLicense=1
        }
        $HasOneDriveLicense=0
        if($User.HasOneDriveLicense -eq 'True'){
           $HasOneDriveLicense=1
        }
        $HasSharePointLicense=0
        if($User.HasSharePointLicense -eq 'True'){
           $HasSharePointLicense=1
        }
        $HasSkypeForBusinessLicense=0
        if($User.HasSkypeForBusinessLicense -eq 'True'){
           $HasSkypeForBusinessLicense=1
        }
        $HasYammerLicense=0
        if($User.HasYammerLicense -eq 'True'){
           $HasYammerLicense=1
        }
        $HasTeamsLicense=0
        if($User.HasTeamsLicense -eq 'True'){
           $HasTeamsLicense=1
        }

        $UserId = $User.UserPrincipalName
        $TotalLicenses=$HasExchangeLicense+$HasOneDriveLicense+$HasSharePointLicense+$HasSkypeForBusinessLicense+$HasYammerLicense+$HasTeamsLicense
        if($TotalLicenses -ne '0'){
            $TotalLicenseDD = $UserId+'##'+$User.ExchangeLastActivityDate+'~!~'+$User.OneDriveLastActivityDate+'~!~'+$User.SharePointLastActivityDate+'~!~'+$User.SkypeForBusinessLastActivityDate+'~!~'+$User.YammerLastActivityDate+'~!~'+$User.TeamsLastActivityDate+'~!~'+$User.ExchangeLicenseAssignDate+'~!~'+$User.OneDriveLicenseAssignDate+'~!~'+$User.SharePointLicenseAssignDate+'~!~'+$User.SkypeForBusinessLicenseAssignDate+'~!~'+$User.YammerLicenseAssignDate+'~!~'+$User.TeamsLicenseAssignDate+'~!~'+$User.AssignedProducts
            Write-Host 'TotalLicenseDD='$TotalLicenseDD
        }

        Write-Host 'info&Measures='$UserId'~'$TotalLicenses'~'$HasExchangeLicense'~'$HasOneDriveLicense'~'$HasSharePointLicense'~'$HasSkypeForBusinessLicense'~'$HasYammerLicense'~'$HasTeamsLicense
    }
}catch{    
    $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
	Write-error "Error Occured in O365LicDtlsByUsrTest Script >>> "$exceptionmsg 
}
Remove-Item $O365ActiveUserDetCSV
