﻿Function Get-LocalTime(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$dat, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$hr
    )
    Process
    {
        $ltimArr=@()
        $UTCTime=[DateTime]$dat
        $UTCTime=$UTCTime.AddHours([int]$hr)
        $strCurrentTimeZone = (Get-WmiObject win32_timezone).StandardName
        $TZ = [System.TimeZoneInfo]::FindSystemTimeZoneById($strCurrentTimeZone)
        $LocalTime = [System.TimeZoneInfo]::ConvertTimeFromUtc($UTCTime, $TZ)
        $ltimArr+='{0:yyyy-MM-dd}' -f $LocalTime
        $ltimArr+=(Get-Date $LocalTime).Hour
        Return $ltimArr
    }
}
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
$rptTimNUPN=$mperiodAndIsTeam[2].Trim()
$prxyCrds=$TestInputs[3].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[4]).ToString().trim()
$shwTopNDD=[int]$TestInputs[5]
#>

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }
$measures='Measures.First Feedback Rating Avg','Measures.Second Feedback Rating Avg','Measures.First Feedback Rating Count','Measures.Second Feedback Rating Count','Measures.First Feedback Rating Poor Count','Measures.Second Feedback Rating Poor Count','Measures.First Feedback Rating Poor Percentage','Measures.Second Feedback Rating Poor Percentage','Measures.First Feedback Token Audio Issue Count','Measures.Second Feedback Token Audio Issue Count','Measures.First Feedback Token Video Issue Count','Measures.Second Feedback Token Video Issue Count'
$Dimentions ='AllStreams.Start Time','AllStreams.End Time','AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.Is Teams','AllStreams.First UPN','AllStreams.Second UPN'
$FeedBackSumryStms=Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled} | Sort-Object -Property 'End Time' -Descending
$FeedBackSumryOutput=@()
if($rptTimNUPN -ne 'none'){
    foreach($strms in $FeedBackSumryStms){
	if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
        if($iswrite){
            $FeedBackSumryOutput+=$strms
        }
        $chktimNam=$strms.'End Time'+'#'+$strms.'First UPN'+'#'+$strms.'Second UPN'
        if($rptTimNUPN -eq $chktimNam){
            $iswrite=$true
        }
    }
}
if(!$iswrite){
    foreach($strms in $FeedBackSumryStms){
	if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
        $cmprTime=[DateTime][String]$strms.'End Time'
        $cmprTime=$cmprTime.ToUniversalTime()
        if($cmprTime -ne ''){
            if($dat1 -lt $cmprTime){
                $FeedBackSumryOutput+=$strms 
            }
        }
    }
}

#foreach($output in $FeedBackSumryOutput){
#    Write-Host $output.'End Time' $output.'First UPN' $output.'Second UPN'
#}

$lastObj=$FeedBackSumryStms |Select-Object -First 1
$rptEdTimNUPN='LastReporting EndTime and UPN#'+$lastObj.'End Time'+'~'+$lastObj.'First UPN'+'~'+$lastObj.'Second UPN'
Write-Host $rptEdTimNUPN

if($FeedBackSumryOutput){
    $FirstFeedbackRatingAvg=0
    $SecondFeedbackRatingAvg=0
    $FirstFeedbackRatingCount=0
    $SecondFeedbackRatingCount=0
    $FirstFeedbackRatingPoorCount=0
    $SecondFeedbackRatingPoorCount=0
    $FirstFeedbackRatingPoorPercentage=0
    $SecondFeedbackRatingPoorPercentage=0
    $FirstFeedbackTokenAudioIssueCount=0
    $SecondFeedbackTokenAudioIssueCount=0
    $FirstFeedbackTokenVideoIssueCount=0
    $SecondFeedbackTokenVideoIssueCount=0

    if($FeedBackSumryOutput){
        Write-host '********************* FirstFeedbackRatingAvg measure***********************'
        $FirstFeedbackRatingAvglist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Rating Avg')  -and $_.'First Feedback Rating Avg' -ne 'NaN' -and $_.'First Feedback Rating Avg' -gt 0.0001 } 
        $FirstFeedbackRatingAvg = ( $FirstFeedbackRatingAvglist | Measure-Object "First Feedback Rating Avg" -Average | select Average).Average
        if(-not $FirstFeedbackRatingAvg){  $FirstFeedbackRatingAvg=0 } else { $FirstFeedbackRatingAvg=$FirstFeedbackRatingAvg.ToString("#.##") }
        $FirstFeedbackRatingAvglist=$null

        Write-host '********************* SecondFeedbackRatingAvg measure***********************'
        $SecondFeedbackRatingAvglist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Rating Avg')  -and $_.'Second Feedback Rating Avg' -ne 'NaN' -and $_.'Second Feedback Rating Avg' -gt 0.0001 } 
        $SecondFeedbackRatingAvg = ($SecondFeedbackRatingAvglist | Measure-Object "Second Feedback Rating Avg" -Average | select Average).Average
        if(-not $SecondFeedbackRatingAvg){  $SecondFeedbackRatingAvg=0 } else { $SecondFeedbackRatingAvg=$SecondFeedbackRatingAvg.ToString("#.##") }
        $SecondFeedbackRatingAvglist=$null

        Write-host '********************* FirstFeedbackRatingCount measure ***********************'
        $FirstFeedbackRatingCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Rating Count')  -and $_.'First Feedback Rating Count' -ne 'NaN' } 
        $FirstFeedbackRatingCount = ($FirstFeedbackRatingCountlist | Measure-Object "First Feedback Rating Count" -Sum | select Sum).Sum
        if(-not $FirstFeedbackRatingCount){  $FirstFeedbackRatingCount=0 } else { $FirstFeedbackRatingCount=$FirstFeedbackRatingCount.ToString("#.##") }
        $FirstFeedbackRatingCountlist=$null

        Write-host '********************* SecondFeedbackRatingCount measure ***********************'
        $SecondFeedbackRatingCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Rating Count')  -and $_.'Second Feedback Rating Count' -ne 'NaN' } 
        $SecondFeedbackRatingCount = ($SecondFeedbackRatingCountlist | Measure-Object "Second Feedback Rating Count" -Sum | select Sum).Sum
        if(-not $SecondFeedbackRatingCount){  $SecondFeedbackRatingCount=0 } else { $SecondFeedbackRatingCount=$SecondFeedbackRatingCount.ToString("#.##") }
        $SecondFeedbackRatingCountlist=$null

        Write-host '********************* dd FirstFeedbackRatingPoorCount measure***********************'
        $FirstFeedbackRatingPoorCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Rating Poor Count')  -and $_.'First Feedback Rating Poor Count' -ne 'NaN' } 
        $FirstFeedbackRatingPoorCount = ($FirstFeedbackRatingPoorCountlist | Measure-Object "First Feedback Rating Poor Count" -Sum | select Sum).Sum
        if(-not $FirstFeedbackRatingPoorCount){  $FirstFeedbackRatingPoorCount=0 }  else { $FirstFeedbackRatingPoorCount=$FirstFeedbackRatingPoorCount.ToString("#.##") }
        if($FirstFeedbackRatingPoorCount){
            $ddlist = $FirstFeedbackRatingPoorCountlist | Where-Object { $_."First Feedback Rating Poor Count" -gt 0.0001 } | Sort-Object { $_."First Feedback Rating Poor Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddFirstFeedbackRatingPoorCount#' $strtTim ~!~ $endTim ~!~ $in.'First Feedback Rating Poor Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $FirstFeedbackRatingPoorCountlist=$null

        Write-host '********************* dd SecondFeedbackRatingPoorCount measure***********************'
        $SecondFeedbackRatingPoorCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Rating Poor Count')  -and $_.'Second Feedback Rating Poor Count' -ne 'NaN' } 
        $SecondFeedbackRatingPoorCount = ($SecondFeedbackRatingPoorCountlist | Measure-Object "Second Feedback Rating Poor Count" -Sum | select Sum).Sum
        if(-not $SecondFeedbackRatingPoorCount){  $SecondFeedbackRatingPoorCount=0 } else { $SecondFeedbackRatingPoorCount=$SecondFeedbackRatingPoorCount.ToString("#.##") }
        if($SecondFeedbackRatingPoorCount){
            $ddlist = $SecondFeedbackRatingPoorCountlist | Where-Object { $_."Second Feedback Rating Poor Count" -gt 0.0001 } | Sort-Object { $_."Second Feedback Rating Poor Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddSecondFeedbackRatingPoorCount#' $strtTim ~!~ $endTim ~!~ $in.'Second Feedback Rating Poor Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $SecondFeedbackRatingPoorCountlist=$null

        Write-host '*********************  FirstFeedbackRatingPoorPercentage measure***********************'
        $FirstFeedbackRatingPoorPercentagelist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Rating Poor Percentage')  -and $_.'First Feedback Rating Poor Percentage' -ne 'NaN' -and $_.'First Feedback Rating Poor Percentage' -gt 0.0001 } 
        $FirstFeedbackRatingPoorPercentage = ($FirstFeedbackRatingPoorPercentagelist | Measure-Object "First Feedback Rating Poor Percentage" -Average | select Average).Average
        if(-not $FirstFeedbackRatingPoorPercentage){  $FirstFeedbackRatingPoorPercentage=0 } else { $FirstFeedbackRatingPoorPercentage=$FirstFeedbackRatingPoorPercentage.ToString("#.##") }
        $FirstFeedbackRatingPoorPercentagelist=$null

        Write-host '*********************  SecondFeedbackRatingPoorPercentage measure***********************'
        $SecondFeedbackRatingPoorPercentagelist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Rating Poor Percentage')  -and $_.'Second Feedback Rating Poor Percentage' -ne 'NaN' -and $_.'Second Feedback Rating Poor Percentage' -gt 0.0001 } 
        $SecondFeedbackRatingPoorPercentage = ($SecondFeedbackRatingPoorPercentagelist  | Measure-Object "Second Feedback Rating Poor Percentage" -Average | select Average).Average
        if(-not $SecondFeedbackRatingPoorPercentage){  $SecondFeedbackRatingPoorPercentage=0 } else { $SecondFeedbackRatingPoorPercentage=$SecondFeedbackRatingPoorPercentage.ToString("#.##") }
        $SecondFeedbackRatingPoorPercentagelist=$null

        Write-host '********************* dd FirstFeedbackTokenAudioIssueCount measure***********************'
        $FirstFeedbackTokenAudioIssueCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Token Audio Issue Count')  -and $_.'First Feedback Token Audio Issue Count' -ne 'NaN' } 
        $FirstFeedbackTokenAudioIssueCount = ($FirstFeedbackTokenAudioIssueCountlist  | Measure-Object "First Feedback Token Audio Issue Count" -Sum | select Sum).Sum
        if(-not $FirstFeedbackTokenAudioIssueCount){  $FirstFeedbackTokenAudioIssueCount=0 } else { $FirstFeedbackTokenAudioIssueCount=$FirstFeedbackTokenAudioIssueCount.ToString("#.##") }
        if($FirstFeedbackTokenAudioIssueCount){
            $ddlist = $FirstFeedbackTokenAudioIssueCountlist | Where-Object { $_."First Feedback Token Audio Issue Count" -gt 0.0001 } | Sort-Object { $_."First Feedback Token Audio Issue Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddFirstFeedbackTokenAudioIssueCount#' $strtTim ~!~ $endTim ~!~ $in.'First Feedback Token Audio Issue Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $FirstFeedbackTokenAudioIssueCountlist=$null

        Write-host '********************* dd SecondFeedbackTokenAudioIssueCount measure***********************'
        $SecondFeedbackTokenAudioIssueCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Token Audio Issue Count')  -and $_.'Second Feedback Token Audio Issue Count' -ne 'NaN' } 
        $SecondFeedbackTokenAudioIssueCount = ($SecondFeedbackTokenAudioIssueCountlist  | Measure-Object "Second Feedback Token Audio Issue Count" -Sum | select Sum).Sum
        if(-not $SecondFeedbackTokenAudioIssueCount){  $SecondFeedbackTokenAudioIssueCount=0 }  else { $SecondFeedbackTokenAudioIssueCount=$SecondFeedbackTokenAudioIssueCount.ToString("#.##") }
        if($SecondFeedbackTokenAudioIssueCount){
            $ddlist = $SecondFeedbackTokenAudioIssueCountlist | Where-Object { $_."Second Feedback Token Audio Issue Count" -gt 0.0001 } | Sort-Object { $_."Second Feedback Token Audio Issue Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddSecondFeedbackTokenAudioIssueCount#' $strtTim ~!~ $endTim ~!~ $in.'Second Feedback Token Audio Issue Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $SecondFeedbackTokenAudioIssueCountlist=$null
    
        Write-host '********************* dd FirstFeedbackTokenVideoIssueCount measure***********************'
        $FirstFeedbackTokenVideoIssueCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'First Feedback Token Video Issue Count')  -and $_.'First Feedback Token Video Issue Count' -ne 'NaN' } 
        $FirstFeedbackTokenVideoIssueCount = ($FirstFeedbackTokenVideoIssueCountlist  | Measure-Object "First Feedback Token Video Issue Count" -Sum | select Sum).Sum
        if(-not $FirstFeedbackTokenVideoIssueCount){  $FirstFeedbackTokenVideoIssueCount=0 }  else { $FirstFeedbackTokenVideoIssueCount=$FirstFeedbackTokenVideoIssueCount.ToString("#.##") }
        if($FirstFeedbackTokenVideoIssueCount){
            $ddlist = $FirstFeedbackTokenVideoIssueCountlist | Where-Object { $_."First Feedback Token Video Issue Count" -gt 0.0001 } | Sort-Object { $_."First Feedback Token Video Issue Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddFirstFeedbackTokenVideoIssueCount#' $strtTim ~!~ $endTim ~!~ $in.'First Feedback Token Video Issue Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $FirstFeedbackTokenVideoIssueCountlist=$null

        Write-host '********************* dd SecondFeedbackTokenVideoIssueCount measure***********************'
        $SecondFeedbackTokenVideoIssueCountlist =$FeedBackSumryOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Second Feedback Token Video Issue Count')  -and $_.'Second Feedback Token Video Issue Count' -ne 'NaN' } 
        $SecondFeedbackTokenVideoIssueCount = ($SecondFeedbackTokenVideoIssueCountlist  | Measure-Object "Second Feedback Token Video Issue Count" -Sum | select Sum).Sum
        if(-not $SecondFeedbackTokenVideoIssueCount){  $SecondFeedbackTokenVideoIssueCount=0 } else { $SecondFeedbackTokenVideoIssueCount=$SecondFeedbackTokenVideoIssueCount.ToString("#.##") }
        if($SecondFeedbackTokenVideoIssueCount){
            $ddlist = $SecondFeedbackTokenVideoIssueCountlist | Where-Object { $_."Second Feedback Token Video Issue Count" -gt 0.0001 } | Sort-Object { $_."Second Feedback Token Video Issue Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddlist){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddSecondFeedbackTokenVideoIssueCount#' $strtTim ~!~ $endTim ~!~ $in.'Second Feedback Token Video Issue Count' ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'
            }
            $ddlist=$null
        }
        $SecondFeedbackTokenVideoIssueCountlist=$null
        Write-Host 'measures##' $FirstFeedbackRatingAvg ~ $SecondFeedbackRatingAvg ~ $FirstFeedbackRatingCount ~ $SecondFeedbackRatingCount ~ $FirstFeedbackRatingPoorCount ~ $SecondFeedbackRatingPoorCount ~ $FirstFeedbackRatingPoorPercentage ~ $SecondFeedbackRatingPoorPercentage ~ $FirstFeedbackTokenAudioIssueCount ~ $SecondFeedbackTokenAudioIssueCount ~ $FirstFeedbackTokenVideoIssueCount ~ $SecondFeedbackTokenVideoIssueCount
    }
}