﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear
#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
$rptTimNUPN=$mperiodAndIsTeam[2].Trim()
$rptNam=$TestInputs[3].Trim()
$prxyCrds=$TestInputs[4].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[5]).ToString().trim()
$showPoorStreams=$TestInputs[6]
$showGoodStreams=$TestInputs[7]
#>

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }
$measures='Measures.Video Stream Count','Measures.Video Poor Due To VideoPostFecplr Count','Measures.Video Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.Video Poor Due To VideoFrameRateAvg Count','Measures.Video Poor Stream Count','Measures.Video Good Stream Count','Measures.Video Unclassified Stream Count','Measures.Video Poor Percentage','Measures.Avg Video Post FECPLR','Measures.Avg Video Local Frame Loss Percentage','Measures.Avg Video Recv Frame Rate Average','Measures.Avg Video Low Frame Rate Call Percent','Measures.Avg Video Packet Loss Rate','Measures.Avg Video Frame Rate','Measures.Avg Video Dynamic Capability Percent'
$Dimentions ='AllStreams.Start Time','AllStreams.End Time','AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.Is Teams','AllStreams.Media Type','AllStreams.ClassifiedPoorCall','AllStreams.First UPN','AllStreams.Second UPN'
$VideoStms=Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 | Where-Object { $_.'Media Type' -eq 'Video' -and ($_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled)} | Sort-Object -Property 'End Time' -Descending

$dir=$egurkhaPath +'\agent\MTM\'+$rptNam
if(!(Test-Path -Path $dir )){
    $null=New-Item -ItemType directory -Path $dir
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$writPath=$dir+'\MTMVideoStrms'+ $timenow +".csv"
$iswrite=$false

$strmsVCnt=0
$gdStmsVCnt=0
$unclsfyStrmsVCnt=0
$FECPLR=0
$FrmLosPercn=0
$RvFrmRat=0
$LwFrmRatPercnt=0
$PcktLosRat=0
$DynCapbltyPercnt=0
$obj=$VideoStms| select -First 1
$rptEdTimNUPN=$obj.'End Time'+'#'+$obj.'First UPN'+'#'+$obj.'Second UPN'
if($showGoodStreams -eq 'none'){
    if($rptTimNUPN -ne 'none'){
        foreach($strms in $VideoStms){
            if($iswrite){
                $stmStr=([String]$strms.'Video Stream Count').Trim()
                if($stmStr -ne $null -and $stmStr -ne '' -and $stmStr -ne 'NaN'){$strmsVCnt+=[int]$stmStr}
                $stmGdStr=([String]$strms.'Video Good Stream Count').Trim()
                if($stmGdStr -ne $null -and $stmGdStr -ne '' -and $stmGdStr -ne 'NaN'){$gdStmsVCnt+=[int]$stmGdStr}
                $stmUnClsStr=([String]$strms.'Video Unclassified Stream Count').Trim()
                if($stmUnClsStr -ne $null -and $stmUnClsStr -ne '' -and $stmUnClsStr -ne 'NaN'){$unclsfyStrmsVCnt+=[int]$stmUnClsStr}   
                $FECPLRStr=([String]$strms.'Avg Video Post FECPLR').Trim()
                if($FECPLRStr -ne $null -and $FECPLRStr -ne '' -and $FECPLRStr -ne 'NaN'){$FECPLR+=[int]$FECPLRStr}
                $FrmLosPercnStr=([String]$strms.'Avg Video Local Frame Loss Percentage').Trim()
                if($FrmLosPercnStr -ne $null -and $FrmLosPercnStr -ne '' -and $FrmLosPercnStr -ne 'NaN'){$FrmLosPercn+=[int]$FrmLosPercnStr}
                $RvFrmRatStr=([String]$strms.'Avg Video Recv Frame Rate Average').Trim()
                if($RvFrmRatStr -ne $null -and $RvFrmRatStr -ne '' -and $RvFrmRatStr -ne 'NaN'){$RvFrmRat+=[int]$RvFrmRatStr}
                $LwFrmRatPercntStr=([String]$strms.'Avg Video Low Frame Rate Call Percent').Trim()
                if($LwFrmRatPercntStr -ne $null -and $LwFrmRatPercntStr -ne '' -and $LwFrmRatPercntStr -ne 'NaN'){$LwFrmRatPercnt+=[int]$LwFrmRatPercntStr}
                $PcktLosRatStr=([String]$strms.'Avg Video Packet Loss Rate').Trim()
                if($PcktLosRatStr -ne $null -and $PcktLosRatStr -ne '' -and $PcktLosRatStr -ne 'NaN'){$PcktLosRat+=[int]$PcktLosRatStr}
                $DynCapbltyPercntStr=([String]$strms.'Avg Video Dynamic Capability Percent').Trim()
                if($DynCapbltyPercntStr -ne $null -and $DynCapbltyPercntStr -ne '' -and $DynCapbltyPercntStr -ne 'NaN'){$DynCapbltyPercnt+=[int]$DynCapbltyPercntStr}
                $stmPrStr=([String]$strms.'Video Poor Stream Count').Trim()
                if($stmPrStr -ne $null -and $stmPrStr -ne '' -and $stmPrStr -ne 'NaN' -and [int]$stmPrStr -gt 0){
                    $strms| Export-Csv $writPath -Append 
                }
            }
            $chktimNam=$strms.'End Time'+'#'+$strms.'First UPN'+'#'+$strms.'Second UPN'
            if($rptTimNUPN -eq $chktimNam){
                $iswrite=$true
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $VideoStms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $stmStr=([String]$strms.'Video Stream Count').Trim()
                    if($stmStr -ne $null -and $stmStr -ne '' -and $stmStr -ne 'NaN'){$strmsVCnt+=[int]$stmStr}
                    $stmGdStr=([String]$strms.'Video Good Stream Count').Trim()
                    if($stmGdStr -ne $null -and $stmGdStr -ne '' -and $stmGdStr -ne 'NaN'){$gdStmsVCnt+=[int]$stmGdStr}
                    $stmUnClsStr=([String]$strms.'Video Unclassified Stream Count').Trim()
                    if($stmUnClsStr -ne $null -and $stmUnClsStr -ne '' -and $stmUnClsStr -ne 'NaN'){$unclsfyStrmsVCnt+=[int]$stmUnClsStr}   
                    $FECPLRStr=([String]$strms.'Avg Video Post FECPLR').Trim()
                    if($FECPLRStr -ne $null -and $FECPLRStr -ne '' -and $FECPLRStr -ne 'NaN'){$FECPLR+=[int]$FECPLRStr}
                    $FrmLosPercnStr=([String]$strms.'Avg Video Local Frame Loss Percentage').Trim()
                    if($FrmLosPercnStr -ne $null -and $FrmLosPercnStr -ne '' -and $FrmLosPercnStr -ne 'NaN'){$FrmLosPercn+=[int]$FrmLosPercnStr}
                    $RvFrmRatStr=([String]$strms.'Avg Video Recv Frame Rate Average').Trim()
                    if($RvFrmRatStr -ne $null -and $RvFrmRatStr -ne '' -and $RvFrmRatStr -ne 'NaN'){$RvFrmRat+=[int]$RvFrmRatStr}
                    $LwFrmRatPercntStr=([String]$strms.'Avg Video Low Frame Rate Call Percent').Trim()
                    if($LwFrmRatPercntStr -ne $null -and $LwFrmRatPercntStr -ne '' -and $LwFrmRatPercntStr -ne 'NaN'){$LwFrmRatPercnt+=[int]$LwFrmRatPercntStr}
                    $PcktLosRatStr=([String]$strms.'Avg Video Packet Loss Rate').Trim()
                    if($PcktLosRatStr -ne $null -and $PcktLosRatStr -ne '' -and $PcktLosRatStr -ne 'NaN'){$PcktLosRat+=[int]$PcktLosRatStr}
                    $DynCapbltyPercntStr=([String]$strms.'Avg Video Dynamic Capability Percent').Trim()
                    if($DynCapbltyPercntStr -ne $null -and $DynCapbltyPercntStr -ne '' -and $DynCapbltyPercntStr -ne 'NaN'){$DynCapbltyPercnt+=[int]$DynCapbltyPercntStr}
                    $stmPrStr=([String]$strms.'Video Poor Stream Count').Trim()
                    if($stmPrStr -ne $null -and $stmPrStr -ne '' -and $stmPrStr -ne 'NaN' -and [int]$stmPrStr -gt 0){
                        $strms| Export-Csv $writPath -Append 
                    }
                }
            }
        }
    }

}else{
    if($rptTimNUPN -ne 'none'){
        foreach($strms in $VideoStms){
            if($iswrite){
                $strms| Export-Csv $writPath -Append
            }
            $chktimNam=$strms.'End Time'+'#'+$strms.'First UPN'+'#'+$strms.'Second UPN'
            if($rptTimNUPN -eq $chktimNam){
                $iswrite=$true
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $VideoStms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $strms| Export-Csv $writPath -Append  
                }
            }
        }
    }
}
$strcnt='StreamsCnt#'+$strmsVCnt+'~'+$gdStmsVCnt+'~'+$unclsfyStrmsVCnt+'~'+$FECPLR+'~'+$FrmLosPercn+'~'+$RvFrmRat+'~'+$LwFrmRatPercnt+'~'+$PcktLosRat+'~'+$DynCapbltyPercnt+'~'+$rptEdTimNUPN
Write-Host $strcnt
Write-Host 'LastReporting WritePath#'$writPath

# SIG # Begin signature block
# MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUunmb1u4g+z4OqN+C3uvWdJI5
# f/mgghSjMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggU0MIIEHKADAgECAhAC4RhLEBaeoPexTwPcEzNS
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMTgwNzEwMDAw
# MDAwWhcNMjEwOTE1MTIwMDAwWjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggEiMA0GCSqG
# SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCg23tdYHXL3HC28IY79eKldqWU6RndJx1e
# 6dYI42cHOvJF0KPsL9Zf2zUJTwqSNE8WNZb4E5e+8LhlSrDQB3a4kBfIFjb+VX15
# qhNEUHopvb+0nMbeN7tVy7wzEYmXDM9BCuvqJwQl6oA8UTu+bNOFVt30fWfll2bD
# HbRYIV7ZX2rJVge3v/oZLtYHYLDCNPqJWaIo/wdleCve0dl4ARvu11Cp3n//177w
# ynxqdvxl02AL09CMGZutD/AfeRXrmAov7mRuBG8h+yZjFeJTUgWSritJD61+wO1i
# oGEZ+i95/0a3xlOPHtLh+iu3HBHu2XOL7As7mbwj2ybgjai7Ig5BAgMBAAGjggHF
# MIIBwTAfBgNVHSMEGDAWgBRaxLl7KgqjpepxA8Bg+S32ZXUOWDAdBgNVHQ4EFgQU
# PfJGp2zDpQh118w/CFQy/YBoZEAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoG
# CCsGAQUFBwMDMHcGA1UdHwRwMG4wNaAzoDGGL2h0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9zaGEyLWFzc3VyZWQtY3MtZzEuY3JsMDWgM6Axhi9odHRwOi8vY3JsNC5k
# aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDBMBgNVHSAERTBDMDcG
# CWCGSAGG/WwDATAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdpY2VydC5j
# b20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2MCQGCCsGAQUFBzABhhho
# dHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUHMAKGQmh0dHA6Ly9jYWNl
# cnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1cmVkSURDb2RlU2lnbmlu
# Z0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEBCwUAA4IBAQA/VCcnpMRz
# Np4bFWiQyKewpqbWYkH7MOTgH2t+bfWJpl705429H9QkCz7lvSAoFkX02ZNV1rIB
# hXvi9lTkgSVGjn2rqFuD/bRa7ztTKgRiPCu/YPEeCXfPzSmK4uWWah7v28S79ti+
# t4FqbNmYeXLFE/S6zYpF8SwsEfbfLWjMEBMtzfIG76YJ8OD0TVF+GkrIPWIweRsL
# 3ROjpuk6U/093pHhYQAVE4guCbZuh9BmE3hQ0psnW4sK9XY2JRtTv5hILc0/1J2m
# FoMGI6dRaIrwyNMg9luGHdCMjl/fjapxSJHgsbH9n/qmrjDpgdZ3xzVzN7EPvFUK
# ibtlp8I4oVbLMYIERDCCBEACAQEwgYYwcjELMAkGA1UEBhMCVVMxFTATBgNVBAoT
# DERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UE
# AxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBDQQIQAuEY
# SxAWnqD3sU8D3BMzUjAJBgUrDgMCGgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJ
# KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQB
# gjcCARUwIwYJKoZIhvcNAQkEMRYEFJT/ThdIZRxslOByYHz1/01eLRDgMA0GCSqG
# SIb3DQEBAQUABIIBAD6FmrQXfn+2R39uqXb4kGck7ObA9Ci8UhwJhug+zwHiWhSa
# m/Zpyx/5BKvBckm/mdDUNZZRF2Er7zb/vVxLwTSp5tV/hlJfsn/n+LrehFApSe5f
# 4zBaFfFzG3l2GtatFvgzYDNk1FK7RVbjnXohHSSCg+B2edOg3bLE0QNSJWL/+pAX
# fFCI1xs5mZHemM2UZ7lJrMmCD33ywE2pK8WNhToZwRHGf/oieb/Ol4UjxVKzczHP
# ta+jSFh9DaKMpGOT2N5O3buYl9mXTaZF0v183SJWqGTaFoGHYHkP83jmsMDu9lWM
# LIyfyLTFMr9INUEZ+dqmHiCS//reTMfJLfO09uihggIgMIICHAYJKoZIhvcNAQkG
# MYICDTCCAgkCAQEwgYYwcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0
# IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNl
# cnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQQIQDUJK4L46iP9gQCHO
# FADw3TAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkq
# hkiG9w0BCQUxDxcNMjEwMTEyMTMzNzI5WjAjBgkqhkiG9w0BCQQxFgQUVugd/yNK
# TsZ6rwCu9bAPRmM7toMwDQYJKoZIhvcNAQEBBQAEggEAg5M9gD2aUmUUBztZU69P
# uEJo8jmNGvvZy9vsOJNGkCebeABfNbdRx/lqfj9GWgXHz997C3XD4X8OtYtVUpwK
# ny+qkD/ZiKfy1bbrGlrppFqjGTpY57Vbkvs2t0c5W9u34STow4CnS+Ten8/r1CsI
# M3CrH0DC8Q6dSRIJWu9jBvAv35u3oxaA5iDJ19waHsrGZGaij8/Oat66upvLsy4d
# s37L3W1EIfEtOEno+E6aZEr3jjzHheTg/YQpDcUYRWvk53uk5/7fYHPS7RUicsve
# QZp64hZgk7YWH7bNzUTvnIm/8U11/3uJ+1dP7DkjsatL9oi2nj7/lox75nOoQ4Xd
# oQ==
# SIG # End signature block
